/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.store;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Arrays;
import org.gcube.contentmanager.storageserver.store.FolderStatusObject;
import org.gcube.contentmanager.storageserver.store.FolderStatusOperationManager;
import org.gcube.contentmanager.storageserver.store.StorageStatusObject;
import org.gcube.contentmanager.storageserver.store.StorageStatusOperationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDB {
    private MongoClient mongo;
    private DB db;
    private String[] server;
    private String collectionSSName;
    private String collectionFSName;
    private int port;
    private String pwd;
    private String user;
    private DBCollection ssCollection;
    private DBCollection fsCollection;
    Logger logger = LoggerFactory.getLogger(MongoDB.class);
    private static final String ACCOUNTING_DB = "accounting";
    private static final String DEFAULT_SS_COLLECTION = "storageStatus";
    private static final String DEFAULT_FS_COLLECTION = "folderStatus";
    private FolderStatusOperationManager folderOperationManager;
    private StorageStatusOperationManager ssOperationManager;
    protected static ReadPreference READ_PREFERENCE = ReadPreference.secondaryPreferred();
    protected static final WriteConcern WRITE_TYPE = WriteConcern.REPLICAS_SAFE;

    public MongoDB(String[] server, int port, String user, String password) {
        this.server = server;
        this.port = port;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = DEFAULT_SS_COLLECTION;
        this.collectionFSName = DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public MongoDB(String[] server, String user, String password) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = DEFAULT_SS_COLLECTION;
        this.collectionFSName = DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public MongoDB(String[] server, String user, String password, String ssCollection, String fsCollection) {
        this.server = server;
        this.pwd = password;
        this.user = user;
        this.collectionSSName = ssCollection != null ? ssCollection : DEFAULT_SS_COLLECTION;
        this.collectionFSName = fsCollection != null ? fsCollection : DEFAULT_FS_COLLECTION;
        this.folderOperationManager = new FolderStatusOperationManager(this.getFolderStatusCollection());
        this.ssOperationManager = new StorageStatusOperationManager(this.getStorageStatusCollection());
    }

    public StorageStatusObject updateUserVolume(StorageStatusObject ssRecord, String operation) {
        ssRecord = this.ssOperationManager.updateUser(ssRecord, operation);
        this.close();
        return ssRecord;
    }

    public StorageStatusObject overwriteUser(String consumer, String count, String volume) {
        StorageStatusObject ssRecord = this.ssOperationManager.overwriteUser(consumer, count, volume);
        this.close();
        return ssRecord;
    }

    public FolderStatusObject updateFolderVolume(FolderStatusObject fsRecord, String operation) {
        this.logger.debug("update folder recursively");
        fsRecord = this.folderOperationManager.updateFolder(fsRecord, operation);
        this.logger.debug("end update folder edge ");
        this.close();
        return fsRecord;
    }

    public StorageStatusObject getSSRecord(String consumer) {
        StorageStatusObject record = this.ssOperationManager.getSSRecord(consumer);
        this.close();
        return record;
    }

    public FolderStatusObject getFSRecord(String folder) {
        FolderStatusObject record = this.folderOperationManager.getFSRecord(folder);
        this.close();
        return record;
    }

    protected DB getDB() {
        if (this.db == null) {
            try {
                int i = -1;
                ArrayList<ServerAddress> srvList = new ArrayList<ServerAddress>();
                for (String srv : this.server) {
                    srvList.add(new ServerAddress(srv));
                }
                if (this.mongo == null) {
                    this.logger.debug(" open mongo connection ");
                    MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost(10).connectTimeout(30000).readPreference(READ_PREFERENCE).build();
                    if (this.pwd != null && this.pwd.length() > 0 && this.user != null && this.user.length() > 0) {
                        MongoCredential credential = MongoCredential.createMongoCRCredential((String)this.user, (String)ACCOUNTING_DB, (char[])this.pwd.toCharArray());
                        this.mongo = new MongoClient(srvList, Arrays.asList(credential), options);
                    } else {
                        this.mongo = new MongoClient(srvList, options);
                    }
                    this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoClientOptions());
                }
                this.db = this.mongo.getDB(ACCOUNTING_DB);
                this.db.setWriteConcern(WRITE_TYPE);
            }
            catch (Exception e) {
                this.close();
                this.logger.error("Problem to open the DB connection for gridfs file ");
                e.printStackTrace();
            }
            this.logger.info("new mongo connection pool opened");
        }
        return this.db;
    }

    public DBCollection getStorageStatusCollection() {
        if (this.ssCollection == null) {
            return this.getDB().getCollection(this.collectionSSName);
        }
        return this.ssCollection;
    }

    public DBCollection getFolderStatusCollection() {
        if (this.fsCollection == null) {
            return this.getDB().getCollection(this.collectionFSName);
        }
        return this.fsCollection;
    }

    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }
}

