/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class StringFunctions {
    public static Expression contains(Expression expression, String substring) {
        return Expression.x("CONTAINS(" + expression.toString() + ", \"" + substring + "\")");
    }

    public static Expression contains(String expression, String substring) {
        return StringFunctions.contains(Expression.x(expression), substring);
    }

    public static Expression initCap(Expression expression) {
        return Expression.x("INITCAP(" + expression.toString() + ")");
    }

    public static Expression initCap(String expression) {
        return StringFunctions.initCap(Expression.x(expression));
    }

    public static Expression title(Expression expression) {
        return Expression.x("TITLE(" + expression.toString() + ")");
    }

    public static Expression title(String expression) {
        return StringFunctions.title(Expression.x(expression));
    }

    public static Expression length(Expression expression) {
        return Expression.x("LENGTH(" + expression.toString() + ")");
    }

    public static Expression length(String expression) {
        return StringFunctions.length(Expression.x(expression));
    }

    public static Expression lower(Expression expression) {
        return Expression.x("LOWER(" + expression.toString() + ")");
    }

    public static Expression lower(String identifier) {
        return StringFunctions.lower(Expression.x(identifier));
    }

    public static Expression ltrim(Expression expression) {
        return Expression.x("LTRIM(" + expression.toString() + ")");
    }

    public static Expression ltrim(String expression) {
        return StringFunctions.ltrim(Expression.x(expression));
    }

    public static Expression ltrim(Expression expression, String characters) {
        return Expression.x("LTRIM(" + expression.toString() + ", \"" + characters + "\")");
    }

    public static Expression ltrim(String expression, String characters) {
        return StringFunctions.ltrim(Expression.x(expression), characters);
    }

    public static Expression position(Expression expression, String substring) {
        return Expression.x("POSITION(" + expression.toString() + ", \"" + substring + "\")");
    }

    public static Expression position(String expression, String substring) {
        return StringFunctions.position(Expression.x(expression), substring);
    }

    public static Expression repeat(Expression expression, int n) {
        return Expression.x("REPEAT(" + expression.toString() + ", " + n + ")");
    }

    public static Expression repeat(String expression, int n) {
        return StringFunctions.repeat(Expression.x(expression), n);
    }

    public static Expression replace(Expression expression, String substring, String repl) {
        return Expression.x("REPLACE(" + expression.toString() + ", \"" + substring + "\", \"" + repl + "\")");
    }

    public static Expression replace(String expression, String substring, String repl) {
        return StringFunctions.replace(Expression.x(expression), substring, repl);
    }

    public static Expression replace(Expression expression, String substring, String repl, int n) {
        return Expression.x("REPLACE(" + expression.toString() + ", \"" + substring + "\", \"" + repl + "\", " + n + ")");
    }

    public static Expression replace(String expression, String substring, String repl, int n) {
        return StringFunctions.replace(Expression.x(expression), substring, repl, n);
    }

    public static Expression rtrim(Expression expression) {
        return Expression.x("RTRIM(" + expression.toString() + ")");
    }

    public static Expression rtrim(String expression) {
        return StringFunctions.rtrim(Expression.x(expression));
    }

    public static Expression rtrim(Expression expression, String characters) {
        return Expression.x("RTRIM(" + expression.toString() + ", \"" + characters + "\")");
    }

    public static Expression rtrim(String expression, String characters) {
        return StringFunctions.rtrim(Expression.x(expression), characters);
    }

    public static Expression split(Expression expression) {
        return Expression.x("SPLIT(" + expression.toString() + ")");
    }

    public static Expression split(String expression) {
        return StringFunctions.split(Expression.x(expression));
    }

    public static Expression split(Expression expression, String sep) {
        return Expression.x("SPLIT(" + expression.toString() + ", \"" + sep + "\")");
    }

    public static Expression split(String expression, String sep) {
        return StringFunctions.split(Expression.x(expression), sep);
    }

    public static Expression substr(Expression expression, int position, int length) {
        return Expression.x("SUBSTR(" + expression.toString() + ", " + position + ", " + length + ")");
    }

    public static Expression substr(String expression, int position, int length) {
        return Expression.x("SUBSTR(" + expression.toString() + ", " + position + ", " + length + ")");
    }

    public static Expression substr(Expression expression, int position) {
        return Expression.x("SUBSTR(" + expression.toString() + ", " + position + ")");
    }

    public static Expression substr(String expression, int position) {
        return Expression.x("SUBSTR(" + expression.toString() + ", " + position + ")");
    }

    public static Expression trim(Expression expression) {
        return Expression.x("TRIM(" + expression.toString() + ")");
    }

    public static Expression trim(String expression) {
        return StringFunctions.trim(Expression.x(expression));
    }

    public static Expression trim(Expression expression, String characters) {
        return Expression.x("TRIM(" + expression.toString() + ", \"" + characters + "\")");
    }

    public static Expression trim(String expression, String characters) {
        return StringFunctions.trim(Expression.x(expression), characters);
    }

    public static Expression upper(Expression expression) {
        return Expression.x("UPPER(" + expression.toString() + ")");
    }

    public static Expression upper(String expression) {
        return StringFunctions.upper(Expression.x(expression));
    }
}

