/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageserver.consumer;

import com.mongodb.DBObject;
import java.util.List;
import org.bson.types.ObjectId;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageserver.accounting.Report;
import org.gcube.contentmanager.storageserver.accounting.ReportException;
import org.gcube.contentmanager.storageserver.accounting.ReportFactory;
import org.gcube.contentmanager.storageserver.data.CubbyHole;
import org.gcube.contentmanager.storageserver.data.OpLogRemoteObject;
import org.gcube.contentmanager.storageserver.parse.utils.ValidationUtils;
import org.gcube.contentmanager.storageserver.store.MongoDB;
import org.gcube.contentmanager.storageserver.store.StorageStatusObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAccountingConsumer
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(UserAccountingConsumer.class);
    static final int MINUTE_DECREMENT = -2;
    private CubbyHole c;
    private int number;
    private Report report;
    private String op;
    private String user;
    private String password;
    String[] server;
    List<String> dtsHosts;

    public UserAccountingConsumer(String[] srvs, CubbyHole c, int number, List<String> dtsHosts) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        this.dtsHosts = dtsHosts;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    public UserAccountingConsumer(String[] srvs, String user, String password, CubbyHole c, int number, List<String> dtsHosts) {
        this.c = c;
        this.number = number;
        this.server = srvs;
        this.dtsHosts = dtsHosts;
        this.user = user;
        this.password = password;
        try {
            this.init();
        }
        catch (ReportException e) {
            throw new RuntimeException("Accounting report Exception initialization");
        }
    }

    private void init() throws ReportException {
        this.report = ReportFactory.getReport(1);
        this.report.init();
    }

    @Override
    public void run() {
        logger.debug("Consuming SU started ");
        MongoDB mongo = null;
        while (true) {
            DBObject x = null;
            try {
                logger.debug("SU waiting next record...");
                x = this.c.get();
                logger.debug("Consumer #" + this.number + " got: " + x);
                this.op = (String)x.get("op");
                DBObject obj = (DBObject)x.get("o");
                OpLogRemoteObject record = this.retrieveObjectFields(obj);
                logger.debug("[recordCheck] operation: " + this.op + " name: " + record.getName() + " type: " + record.getType() + " path: " + record.getFilename() + " dir Path: " + record.getDir() + " length: " + record.getLength() + " owner: " + record.getOwner() + " lastOperation " + record.getLastOperation() + "\n\t lastUser: " + record.getLastUser() + " lastAccess: " + record.getLastAccess());
                if (record.getLength() > 0L && (record.getFilename() != null && record.getFilename().length() > 0 && record.getDir().length() > 0 && record.getDir().contains("/") || record.getLinkCount() > 0)) {
                    String id = ((DBObject)x.get("o")).get("_id").toString();
                    logger.debug("Consumer id  " + id);
                    record.setLength(record.getLength() / 1024L);
                    String scope = null;
                    String pathString = (String)obj.get("onScope");
                    logger.debug("[recordCheck] it is a link to: " + pathString);
                    scope = record.getDir() != null && record.getDir().contains("/") ? this.retrieveScopeFromRemoteFilePath(record.getDir()) : this.retrieveScopeFromRemoteFilePath(pathString);
                    logger.debug("scope retrieved ");
                    boolean validScope = ValidationUtils.validationScope(scope);
                    if (validScope) {
                        if (record.getDelete() != null) {
                            record.setLastOperation("DELETE");
                        } else {
                            if (record.getLastOperation() != null && this.op != null && record.getLastOperation().equalsIgnoreCase("LINK") && this.op.equalsIgnoreCase("u")) {
                                logger.debug("[recordCheck] update on link object is not accounted. Skip next ");
                                continue;
                            }
                            if (record.getLastOperation() == null || record.getLastUser() == null) {
                                logger.warn("lastOperation: " + record.getLastOperation() + " lastUser: " + record.getLastUser() + ". These values cannot be null. Skip next ");
                                continue;
                            }
                            if (this.dtsHosts != null && record.getLastOperation() != null && record.getLastOperation().equalsIgnoreCase("DOWNLOAD")) {
                                logger.debug("[recordCheck] check if the caller is from dts. CallerIP: " + record.getCallerIp() + " dts value: " + this.dtsHosts);
                                for (String host : this.dtsHosts) {
                                    logger.debug("scan " + host);
                                    if (!record.getCallerIp().contains(host)) continue;
                                    record.setLastOperation("workspace.accounting");
                                    logger.debug("[recordCheck] the caller is dts service:  caller " + record.getCallerIp() + " dts host: " + host + " the new user is: " + record.getLastUser());
                                }
                            } else if (record.getLastOperation() != null && record.getLastOperation().equalsIgnoreCase("UPLOAD") && this.op.equalsIgnoreCase("u")) {
                                logger.info("[recordCheck] metadata update on a previous insert. Record discarded: " + id);
                                continue;
                            }
                        }
                        logger.debug("[recordCheck]  accounting operation " + record.getLastOperation());
                        StorageStatusObject ssr = null;
                        if (this.isNeedSSReport(record.getLastOperation())) {
                            try {
                                logger.debug("[recordCheck] update SS record yet");
                                if (mongo == null) {
                                    mongo = new MongoDB(this.server, this.user, this.password);
                                }
                                if (record.getLastOperation().equalsIgnoreCase("COPY") || record.getLastOperation().equalsIgnoreCase("SOFT_COPY")) {
                                    record.setOwner(record.getLastUser());
                                }
                                ssr = new StorageStatusObject(record.getOwner(), record.getLength(), 1);
                                ssr = mongo.updateUserVolume(ssr, record.getLastOperation());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                mongo.close();
                                logger.error("[recordCheck] Problem when updating storage status record: " + e.getMessage());
                            }
                        }
                        try {
                            ScopeProvider.instance.set(scope);
                            if (ssr != null) {
                                this.report(record, scope, ssr.getVolume() + "", ssr.getCount() + "");
                                continue;
                            }
                            this.report(record, scope, null, null);
                        }
                        catch (Exception e) {
                            logger.error("[recordCheck] Problem sending accounting report. Exception message: " + e.getMessage());
                        }
                        continue;
                    }
                    logger.warn("[recordCheck] operation " + record.getLastOperation() + " is not accounted: invalid scope: " + scope);
                    continue;
                }
                logger.debug("operation " + record.getLastOperation() + " is not accounted");
                continue;
            }
            catch (Exception e) {
                logger.error("ERROR Processing record: " + x + " Exception throws: " + e.getMessage());
                logger.info("skip to next record ");
                if (mongo == null) continue;
                mongo.close();
                continue;
            }
            break;
        }
    }

    private boolean isNeedSSReport(String lastOperation) {
        logger.trace("Last operation is " + lastOperation);
        return lastOperation.equalsIgnoreCase("UPLOAD") || lastOperation.equalsIgnoreCase("COPY") || lastOperation.equalsIgnoreCase("SOFT_COPY") || lastOperation.equalsIgnoreCase("DELETE");
    }

    public void runWithoutThread(DBObject x) {
        try {
            this.report = ReportFactory.getReport(1);
        }
        catch (ReportException e1) {
            e1.printStackTrace();
        }
        this.report.init();
        this.run();
    }

    private OpLogRemoteObject retrieveObjectFields(DBObject obj) {
        ObjectId id;
        OpLogRemoteObject record = new OpLogRemoteObject();
        record.setFilename((String)obj.get("filename"));
        record.setType((String)obj.get("type"));
        record.setName((String)obj.get("name"));
        record.setOwner((String)obj.get("owner"));
        record.setCreationTime((String)obj.get("creationTime"));
        record.setDir((String)obj.get("dir"));
        if (obj.get("lastAccess") != null) {
            record.setLastAccess((String)obj.get("lastAccess"));
        }
        if (obj.get("callerIP") != null) {
            record.setCallerIp((String)obj.get("callerIP"));
        }
        if (obj.get("lastOperation") != null) {
            record.setLastOperation((String)obj.get("lastOperation"));
        }
        if (obj.get("lastUser") != null) {
            record.setLastUser((String)obj.get("lastUser"));
        }
        if (obj.get("linkCount") != null) {
            record.setLinkCount((Integer)obj.get("linkCount"));
        }
        if (obj.get("onDeleting") != null) {
            record.setDelete((String)obj.get("onDeleting"));
        }
        if (obj.get("_id") != null && ObjectId.isValid((String)(id = (ObjectId)obj.get("_id")).toString())) {
            record.setId(id.toString());
        }
        long length = -1L;
        if (obj.get("length") != null) {
            record.setLength((Long)obj.get("length"));
        }
        return record;
    }

    private void report(OpLogRemoteObject record, String scope, String totVolume, String totCount) {
        StorageUsageRecord sur = this.report.setGenericProperties(null, "storage-usage", record.getLastUser(), scope, record.getCreationTime(), record.getLastAccess(), record.getOwner(), record.getLastOperation(), record.getLength() + "");
        sur = this.report.setSpecificProperties(sur, record.getFilename(), "STORAGE", record.getCallerIp(), record.getId());
        logger.info("[accounting call] type: storage usage ");
        this.report.printRecord(sur);
        this.report.send(sur);
    }

    private String retrieveScopeFromRemoteFilePath(String filename) {
        String[] split = filename.split("/");
        if (split.length > 0) {
            String scope = null;
            int i = 1;
            if (split[1].equals("VOLATILE")) {
                i = 2;
            }
            scope = "/" + split[i];
            ++i;
            while (!split[i].equals("home") && !split[i].equals("public")) {
                scope = scope + "/" + split[i];
                logger.debug("scope building: " + scope);
                ++i;
            }
            logger.debug("[recordCheck] scope retrieved: " + scope);
            return scope;
        }
        logger.error("Scope bad format: scope not retrieved from string: " + filename);
        return null;
    }
}

