/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;

public class ClientTest {
    private static final GCUBELog logger = new GCUBELog(ClientTest.class);
    static final String URL_1 = "146.48.122.153";

    public static void main(String[] args) {
        String[] server = new String[]{URL_1};
        long start = System.currentTimeMillis();
        ServiceEngine client = new ServiceEngine(server, args[1], args[0]);
        if (args[2].equalsIgnoreCase("upload")) {
            String id = client.put(true).LFile(args[3]).RFile(args[4]);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("main(String[]) bucket id: " + id));
            }
        } else if (args[2].equalsIgnoreCase("uploadis")) {
            File f = new File(args[3]);
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            String id = client.put(true).LFile((InputStream)is).RFile(args[4]);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("main(String[]) bucket id: " + id));
            }
        } else if (args[2].equalsIgnoreCase("download")) {
            client.get().LFile(args[3]).RFile(args[4]);
        } else if (args[2].equalsIgnoreCase("downloadById")) {
            client.get().LFile(args[3]).RFileById(args[4]);
        } else if (args[2].equalsIgnoreCase("showDir")) {
            List dirs = client.showDir().RDir(args[3]);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" Time for call: " + (System.currentTimeMillis() - start)));
            }
            ClientTest.showList(dirs);
        } else if (args[2].equalsIgnoreCase("remove")) {
            client.remove().RFile(args[3]);
        } else if (args[2].equalsIgnoreCase("removedir")) {
            client.removeDir().RDir(args[3]);
        } else {
            logger.error((Object)"Operation not valid");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" Total time: " + (System.currentTimeMillis() - start)));
        }
    }

    private static void showList(List dirs) {
        if (dirs != null) {
            for (StorageObject obj : dirs) {
                if (obj.isDirectory()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("found directory : " + obj.getName()));
                    continue;
                }
                if (obj.isFile()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("found file: " + obj.getName()));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("no type associated with object:  " + obj.getName()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TOT objects: " + dirs.size()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"dir empty!");
        }
    }
}

