/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;

public class StorageClient {
    private GCUBEScope scope;
    private String clientID;
    private String typeAccess;
    private String memoryType;
    private String serviceClass;
    private String serviceName;
    private String owner;
    private String server;
    private static final GCUBELog logger = new GCUBELog(StorageClient.class);

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, String server) {
        String id = owner;
        this.owner = owner;
        this.scope = scope;
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, String server, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scope = scope;
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server) {
        String id = owner;
        this.owner = owner;
        this.scope = GCUBEScope.getScope((String)scope);
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scope = GCUBEScope.getScope((String)scope);
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope) {
        String id = owner;
        this.owner = owner;
        this.scope = scope;
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, GCUBEScope scope, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scope = scope;
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope) {
        String id = owner;
        this.owner = owner;
        this.scope = GCUBEScope.getScope((String)scope);
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scope = GCUBEScope.getScope((String)scope);
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        if (!this.typeAccess.equalsIgnoreCase("public")) {
            if (this.typeAccess.equalsIgnoreCase("private")) {
                this.clientID = serviceClass + "/" + serviceName + "/" + id;
            } else if (this.typeAccess.equalsIgnoreCase("shared")) {
                this.clientID = serviceClass + "/" + serviceName;
            } else {
                throw new IllegalArgumentException("type is not correctly: public, private or shared");
            }
        }
    }

    public IClient getClient() throws Exception {
        String[] newServer = null;
        if (this.server == null) {
            String[] serverFounded = this.checkVarEnvMongo();
            if (serverFounded == null) {
                ISClientConnector isclient = new ISClientConnector();
                serverFounded = isclient.getServer("StorageManager", this.scope);
            }
            newServer = serverFounded;
        } else {
            String[] serverPassed = new String[]{this.server};
            newServer = serverPassed;
        }
        if (newServer == null) {
            throw new Exception("Generic resource not found");
        }
        String environment = this.scope.getName();
        if (this.memoryType != null && this.memoryType.toString().equalsIgnoreCase("VOLATILE")) {
            environment = "VOLATILE/" + this.scope.getName();
        }
        ServiceEngine engine = new ServiceEngine(newServer, this.clientID, environment, this.typeAccess, this.owner);
        engine.setServiceClass(this.serviceClass);
        engine.setServiceName(this.serviceName);
        engine.setGcubeAccessType(this.typeAccess.toLowerCase());
        if (this.memoryType != null) {
            engine.setGcubeMemoryType(this.memoryType.toLowerCase());
        }
        engine.setGcubeScope(this.scope.toString());
        engine.setOwnerGcube(this.owner);
        return engine;
    }

    private String[] checkVarEnvMongo() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String server = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")) continue;
            server = env.get(key);
        }
        if (server != null) {
            String[] servers = new String[]{server};
            return servers;
        }
        return null;
    }
}

