package org.gcube.contentmanager.storageclient.wrapper;

import java.io.StringReader;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISClient.ISMalformedQueryException;
import org.gcube.common.core.informationsystem.client.ISClient.ISUnsupportedQueryException;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
//import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISClientConnector {
	/**
	 * Logger for this class
	 */
	private static final  GCUBELog logger= new GCUBELog(ISClientConnector.class);
	private ISClient isClient;
	private String[] server;
	private String env;
	private String clientId;
	private GCUBEGenericResourceQuery genericResourceQuery; 
	private static HashMap isCache;
	public ISClientConnector() throws Exception{
		 isClient = GHNContext.getImplementation(ISClient.class);
		
	}
	
	public String[] getServer(String secondaryType, GCUBEScope scope) throws ISMalformedQueryException, ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {
		if(isCache!=null)
			server=(String[]) isCache.get("MongoDBServer");
		if(server==null){
			GCUBEGenericResourceQuery query = isClient.getQuery(GCUBEGenericResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("//Profile/Name","MongoDBServer"));
			try{
				for (GCUBEGenericResource resource:isClient.execute(query, scope)){
					String body=resource.getBody();
					server=parseXmlFile(new InputSource(new StringReader(body)));
				}
			}catch(ISException e){
				logger.error("ISException RETRY connect to is");
				for (GCUBEGenericResource resource:isClient.execute(query, scope)){
					String body=resource.getBody();
					server=parseXmlFile(new InputSource(new StringReader(body)));
				}
			}
			if(server!= null){
				if(isCache==null)
					isCache=new HashMap<String, String[]>();
				isCache.put("MongoDBServer", server);
				logger.info("ISCACHE: ELEMENT INSERTED ");
			}
				
		}else{
			logger.info("ISCACHE: ELEMENT EXTRACTED");
		}
		return server;
	}
	
	public String getEnvironment(String secondaryType, String field) throws MalformedScopeExpressionException, ISMalformedQueryException, ISUnsupportedQueryException, ISException{
		return env;
	}
	
	public String getClientId(String secondaryType, String field) throws MalformedScopeExpressionException, ISMalformedQueryException, ISUnsupportedQueryException, ISException{
		return clientId;
	}
	
	private String[] parseXmlFile(InputSource body){
		String[] list=null;
		try{
		//get the factory
		  DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		  DocumentBuilder db = dbf.newDocumentBuilder();
		  Document doc = db.parse(body);
		  doc.getDocumentElement().normalize();
		  NodeList nodeLst = doc.getElementsByTagName("server_list");
		  int i=0;
		  list=new String[nodeLst.getLength()];
		  
		  for (int s = 0; s < nodeLst.getLength(); s++) {

		    Node fstNode = nodeLst.item(s);
		    
		    if (fstNode.getNodeType() == Node.ELEMENT_NODE) {
		  
		      Element fstElmnt = (Element) fstNode;
		      NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("server");
		      Element fstNmElmnt = (Element) fstNmElmntLst.item(0);
		     
		      String ip=fstNmElmnt.getAttribute("ip");
		      String port=fstNmElmnt.getAttribute("port");
		      list[i]=ip;
		      i++;
		    }

		  }
		} catch (Exception e) {
		   e.printStackTrace();
		}
		return list;
	}	
}