package org.gcube.contentmanager.storageclient.wrapper;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.Property;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISClientConnector {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
	private String[] server;
	private String env;
	private String clientId;
	private String backendType;
	protected String username;
	protected String password;
	private static HashMap isCache;
	
	public ISClientConnector(){
	}
	
	public String[] getServerAccess(String resourceType, String scope){
		String savedScope=null;
		if(scope!=null){
			savedScope=ScopeProvider.instance.get();
			ScopeProvider.instance.set(scope);
		}
		logger.trace("get server from IS storage-manager-version: 2.1.0-SNAPSHOT ");
		if(isCache!=null){
			server=(String[]) isCache.get("MongoDBServer");
			username=(String)isCache.get("username");
			password=(String)isCache.get("password");
		}
		if(server==null){
			if(resourceType.equalsIgnoreCase("runtimeResource")){
				getServerRRFws();
			}else{
				getServerFws();
			}
			if(server!= null){
				if(isCache==null)
					isCache=new HashMap<String, String[]>();
				isCache.put("MongoDBServer", server);
				if(username != null && username.length() > 0){
					isCache.put("username", username);
					isCache.put("password", password);
				}
				logger.info("ISCACHE: ELEMENT INSERTED ");
			}
				
		}else{
			logger.info("ISCACHE: ELEMENT EXTRACTED");
		}
		if(scope!=null){
			ScopeProvider.instance.set(savedScope);
		}
		return server;
	}

	
	public String getEnvironment(String secondaryType, String field){
		return env;
	}
	
	public String getClientId(String secondaryType, String field){
		return clientId;
	}
	
	@Deprecated
	private String[] parseXmlFile(InputSource body){
		String[] list=null;
		try{
		//get the factory
		  DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		  DocumentBuilder db = dbf.newDocumentBuilder();
		  Document doc = db.parse(body);
		  doc.getDocumentElement().normalize();
		  NodeList nodeLst = doc.getElementsByTagName("server_list");
		  int i=0;
		  list=new String[nodeLst.getLength()];
		  
		  for (int s = 0; s < nodeLst.getLength(); s++) {

		    Node fstNode = nodeLst.item(s);
		    
		    if (fstNode.getNodeType() == Node.ELEMENT_NODE) {
		  
		      Element fstElmnt = (Element) fstNode;
		      NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("server");
		      Element fstNmElmnt = (Element) fstNmElmntLst.item(0);
		     
		      String ip=fstNmElmnt.getAttribute("ip");
		      String port=fstNmElmnt.getAttribute("port");
		      list[i]=ip;
		      i++;
		    }

		  }
		} catch (Exception e) {
		   e.printStackTrace();
		}
		return list;
	}

	
	public String[] getServerRRFws(){
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> resources = client.submit(query);
		if(resources.size() > 1){
			logger.info("found "+resources.size()+" RR ");
			// take the RR with property priority setted to DEFAULT
			//take servers take RR name
			return getServers(resources);
		}else if(resources.size() == 1){
			logger.info("found only one RR, take it"); 
			return getServers(resources.get(0));
			//take RR name
		}else{
			logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE "+ScopeProvider.instance.get());
			throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: "+ScopeProvider.instance.get());
		}
	}
	

	private String[] getServers(ServiceEndpoint res) {
		server=new String[res.profile().accessPoints().size()];
		int i=0;
		for (AccessPoint ap:res.profile().accessPoints()) {
			if (ap.name().equals("server"+(i+1))) {
				server[i] = ap.address();
	// if presents, try to get user and password			
				username = ap.username();	
				if(username != null && username.length() > 0){
					try {
						password = StringEncrypter.getEncrypter().decrypt(ap.password());
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				i++;
			}
		}
		Iterator<AccessPoint> it= res.profile().accessPoints().iterator();
		AccessPoint ap=(AccessPoint)it.next();
		Map<String, Property>map= ap.propertyMap();
		Property type=map.get("type");
		backendType=type.value();
		logger.info("Type of backend found "+backendType);
		return server;
	}
	
	private String[] getServers(List<ServiceEndpoint> resources) {
		ServiceEndpoint defaultResource=null;
		logger.info("search RR with priority ");
	// search RR with property DEFAULT	
		for (ServiceEndpoint res : resources){
			String priority=retrievePropertyValue(res, "priority");
			if (priority!=null){
				defaultResource=res;
				logger.info("found a RR with priority: ");
				break;
			}
		}
		if(defaultResource!=null){
			server=new String[defaultResource.profile().accessPoints().size()];
			int i=0;
			for (AccessPoint ap:defaultResource.profile().accessPoints()) {
				if (ap.name().equals("server"+(i+1))) {
					server[i] = ap.address();
					// if presents, try to get user and password			
					username = ap.username();
					password="";
					if(username != null && username.length() > 0){
						try {
							password = StringEncrypter.getEncrypter().decrypt(ap.password());
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					i++;
				}
			}
			backendType=retrievePropertyValue(defaultResource, "type");
			logger.info("Type of backend found in RR is "+backendType);
			return server;

		}else{
			throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
		}
	}

	@Deprecated
	public void getServerFws(){
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/Name/text() eq 'MongoDBServer'").setResult("$resource/Profile/Body/server_list");
		DiscoveryClient<ServerList> client = clientFor(ServerList.class);
		List<ServerList> servers = client.submit(query);
		for (ServerList gr:servers) {
			server=new String[gr.getEndpoints().size()];
			int i=0;
			for(Server s : gr.getEndpoints()){
				server[i]=s.ip;
				i++;
			}
			break;
		}
	}

	public String getBackendType(String scope) {
		if(backendType!=null) return backendType;
		backendType = retrievePropertyValue("type", scope);
		return backendType;
	}

	
	
	private String retrievePropertyValue(String name, String scope) {
		String savedScope=null;
		if(scope!=null){
			savedScope=ScopeProvider.instance.get();
			ScopeProvider.instance.set(scope);
		}
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
		List<ServiceEndpoint> resources = client.submit(query);
		ServiceEndpoint res=resources.get(0);
		Iterator<AccessPoint> it= res.profile().accessPoints().iterator();
		AccessPoint ap=(AccessPoint)it.next();
		Map<String, Property>map= ap.propertyMap();
		Property type=map.get(name);
		String value=type.value();
		if(scope!=null){
			ScopeProvider.instance.set(savedScope);
		}
		return value;
	}

	private String retrievePropertyValue(ServiceEndpoint res, String name) {
		Iterator<AccessPoint> it= res.profile().accessPoints().iterator();
		AccessPoint ap=(AccessPoint)it.next();
		Map<String, Property>map= ap.propertyMap();
		Property type=map.get(name);
		if (type!=null)
			return type.value();
		else
			return null;
	}


/***************************/
	@Deprecated
	@XmlRootElement(name = "server_list")
	public static class ServerList {

		@XmlElementRef
		private List<Server> servers = new ArrayList<Server>();
	
		@Override
		public String toString() {
			return "[servers=" + servers + "]";
		}
	
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((servers == null) ? 0 : servers.hashCode());
			return result;
		}
	
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			ServerList other = (ServerList) obj;
			if (servers == null) {
				if (other.servers != null)
					return false;
			} else if (!servers.equals(other.servers))
				return false;
			return true;
		}
	
		public List<Server> getEndpoints() {
			return servers;
		}
	
		public void setEndpoints(ArrayList<Server> endpoints) {
			this.servers = endpoints;
		}

	}

	@Deprecated
	@XmlRootElement(name = "server")
	public static class Server {

		@XmlAttribute(name = "ip")
		public String ip;
		@XmlAttribute(name = "port")
		public String port;
	
		@Override
		public String toString() {
			return "Server [ip=" + ip + ", port=" + port + "]";
		}
	
		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((ip == null) ? 0 : ip.hashCode());
			result = prime * result + ((port == null) ? 0 : port.hashCode());
			return result;
		}
	
		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			Server other = (Server) obj;
			if (ip == null) {
				if (other.ip != null)
					return false;
			} else if (!ip.equals(other.ip))
				return false;
			if (port == null) {
				if (other.port != null)
					return false;
			} else if (!port.equals(other.port))
				return false;
			return true;
		}

	}



/*************************************************************/
	
	
}