/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionById;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionOld;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionFactory {
    static Logger logger = LoggerFactory.getLogger(SMPURLConnectionFactory.class);

    public static SMPConnection getSmp(URL url) {
        String urlString = url.toString();
        if (SMPURLConnectionFactory.isNewNewType(urlString)) {
            logger.info("detected new smp format " + url);
            SMPConnection connection = SMPURLConnectionFactory.load(url);
            if (connection != null) {
                return connection;
            }
            return new SMPURLConnectionById(url);
        }
        logger.info("detected old smp format " + url);
        return new SMPURLConnectionOld(url);
    }

    private static boolean isNewNewType(String urlString) {
        String[] urlParam = urlString.split("/");
        String infraHost = urlParam[2];
        if (Utils.isScopeProviderMatch(infraHost)) {
            return true;
        }
        String infra = Utils.getInfraFromResolverHost(infraHost);
        String rootScope = "/" + infra;
        ScopeBean scope = new ScopeBean(rootScope);
        if (scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
            return Utils.validationScope2(rootScope);
        }
        return false;
    }

    private static SMPConnection load(URL url) {
        ServiceLoader<SMPConnection> loader = ServiceLoader.load(SMPConnection.class);
        Iterator<SMPConnection> iterator = loader.iterator();
        ArrayList<SMPConnection> impls = new ArrayList<SMPConnection>();
        while (iterator.hasNext()) {
            impls.add(iterator.next());
        }
        int implementationCounted = impls.size();
        if (implementationCounted == 0) {
            logger.info(" 0 implementation found. Load default implementation of SMPConnection");
            return null;
        }
        if (implementationCounted > 0) {
            SMPConnection connection = (SMPConnection)impls.get(0);
            logger.info("1 implementation of TransportManager found. ");
            connection.init(url);
            return connection;
        }
        return null;
    }
}

