/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
    private String[] server;
    private String backendType;
    private String[] volatileHost;
    protected String username;
    protected String password;
    protected ServiceEndpoint storageResource;
    private static HashMap<String, Object> isCache;

    public String[] retrieveConnectionInfo(ServiceEndpoint resource) {
        return this.fillConnectionFields(resource);
    }

    public List<ServiceEndpoint> getServiceEndpoint(String category, String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "' and $resource/Profile/Name eq '" + name + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public ServiceEndpoint getStorageEndpoint(String scope) {
        if (this.getStorageResource() == null) {
            logger.debug("discovering service endpoint");
            String savedScope = null;
            if (scope != null) {
                savedScope = ScopeProvider.instance.get();
                logger.debug("set scopeProvider to scope " + scope + " scope provider scope is " + savedScope);
                ScopeProvider.instance.set(scope);
            }
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (scope != null) {
                logger.debug("reset scopeProvider to scope " + scope);
                ScopeProvider.instance.set(savedScope);
            }
            if (resources.size() > 0) {
                ServiceEndpoint storageResource = this.getPriorityResource(resources);
                this.setStorageResource(storageResource);
                return storageResource;
            }
            throw new RuntimeException("Storage ServiceEndpoint not found under scope: " + scope);
        }
        logger.debug("service endpoint already discovered");
        return this.getStorageResource();
    }

    private String[] fillConnectionFields(ServiceEndpoint resource) {
        if (resource != null) {
            String[] server = new String[resource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                server[i] = ap.address();
                this.setUsername(ap.username());
                this.setPassword("");
                if (this.getUsername() != null && this.getUsername().length() > 0) {
                    try {
                        this.setPassword(StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            this.setBackendType(this.retrievePropertyValue(resource, "type"));
            String[] volatileHost = new String[]{this.retrievePropertyValue(resource, "volatile")};
            this.setVolatileHost(volatileHost);
            logger.info("Type of backend found in RR is " + this.backendType);
            return server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    private ServiceEndpoint getPriorityResource(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            this.setStorageResource(res);
            logger.info("found a RR with priority: ");
            break;
        }
        return defaultResource;
    }

    public String getBackendType(ServiceEndpoint resource) {
        if (this.getBackendType() != null) {
            return this.getBackendType();
        }
        this.setBackendType(this.retrievePropertyValue(resource, "type"));
        return this.getBackendType();
    }

    public String[] getVolatileHost(ServiceEndpoint resource) {
        if (this.getVolatileHost() != null) {
            return this.getVolatileHost();
        }
        String[] volatileHost = new String[]{this.retrievePropertyValue(resource, "volatile")};
        this.setVolatileHost(volatileHost);
        return volatileHost;
    }

    public String retrievePropertyValue(String name, String scope) {
        ServiceEndpoint.AccessPoint ap;
        Map map;
        ServiceEndpoint.Property type;
        logger.debug("retrieving property " + name + " value");
        ServiceEndpoint res = this.getStorageEndpoint(scope);
        Iterator it = res.profile().accessPoints().iterator();
        String value = null;
        while (it.hasNext() && ((type = (ServiceEndpoint.Property)(map = (ap = (ServiceEndpoint.AccessPoint)it.next()).propertyMap()).get(name)) == null || (value = type.value()) == null)) {
        }
        if (value != null && value.length() > 0) {
            logger.debug("value found");
        } else {
            logger.warn("value of the property " + name + " not found");
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public String getResolverHost(ServiceEndpoint serviceEndpoint) {
        return serviceEndpoint.profile().runtime().hostedOn();
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getBackendType() {
        return this.backendType;
    }

    public void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String[] getVolatileHost() {
        return this.volatileHost;
    }

    public void setVolatileHost(String[] volatileHost) {
        this.volatileHost = volatileHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServiceEndpoint getStorageResource() {
        return this.storageResource;
    }

    public void setStorageResource(ServiceEndpoint storageResource) {
        this.storageResource = storageResource;
    }
}

