/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.protocol.utils;

import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final String GCUBE_RESOLVER_HOST = "data.gcube.org";
    private static final String D4SCIENCE_RESOLVER_HOST = "data.d4science.org";
    private static final String GCUBE_INFRA = "gcube";
    private static final String D4SCIENCE_INFRA = "d4science.research-infrastructures.eu";
    public static final String INFRASTRUCTURE_ENV_VARIABLE_NAME = "infrastructure";
    public static final String URI_RESOLVER_RESOURCE_CATEGORY = "Service";
    public static final String URI_RESOLVER_RESOURCE_NAME = "HTTP-URI-Resolver";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getInfraFromResolverHost(String resolverHost) {
        if (resolverHost.equals(GCUBE_RESOLVER_HOST)) {
            return GCUBE_INFRA;
        }
        if (resolverHost.equals(D4SCIENCE_RESOLVER_HOST)) {
            return D4SCIENCE_INFRA;
        }
        return resolverHost;
    }

    public static List<ServiceEndpoint> queryServiceEndpoint(String category, String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "' and $resource/Profile/Name eq '" + name + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public static String getResolverHost(ServiceEndpoint serviceEndpoint) {
        return serviceEndpoint.profile().runtime().hostedOn();
    }
}

