/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.contentmanager.storageclient.wrapper.BackendType;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
    private String[] server;
    private String backendType;
    private String[] volatileHost;
    protected String username;
    protected String password;
    protected ServiceEndpoint storageResource;
    public String region;
    private static HashMap<String, Object> isCache;
    public final String CATEGORY = "Storage";
    public final String NAME = "StorageManager";

    public ISClientConnector(String backendType) {
        this.setBackendType(backendType);
    }

    public ISClientConnector() {
    }

    public String[] retrieveConnectionInfo(ServiceEndpoint resource) {
        return this.fillConnectionFields(resource);
    }

    public List<ServiceEndpoint> getServiceEndpoint(String category, String name) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "' and $resource/Profile/Name eq '" + name + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        return resources;
    }

    public ServiceEndpoint getStorageEndpoint() {
        if (this.getStorageResource() == null) {
            logger.debug("discovering service endpoint");
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Storage' and $resource/Profile/Name eq 'StorageManager' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources.size() > 0) {
                ServiceEndpoint storageResource = this.getPriorityResource(resources);
                this.setStorageResource(storageResource);
                return storageResource;
            }
            throw new RuntimeException("Storage ServiceEndpoint not found under scope: " + SecretManagerProvider.instance.get().getContext());
        }
        logger.debug("service endpoint already discovered");
        return this.getStorageResource();
    }

    private String[] fillConnectionFields(ServiceEndpoint resource) {
        logger.debug("fillConnectionsFields method ");
        if (resource != null) {
            logger.debug("checking resource " + resource.id());
            ArrayList<String> server = new ArrayList<String>();
            if (!this.getBackendType(resource).equals(BackendType.MongoDB.name())) {
                logger.info("searching backend: " + this.getBackendType());
                for (Iterator ap : resource.profile().accessPoints()) {
                    if (!ap.name().equals(this.getBackendType())) continue;
                    server.add(ap.address());
                    this.setUsername(ap.username());
                    this.decryptPwd((ServiceEndpoint.AccessPoint)ap);
                    this.setRegion(this.retrievePropertyValue((ServiceEndpoint.AccessPoint)ap, "region"));
                    break;
                }
            } else {
                int i = 0;
                for (ServiceEndpoint.AccessPoint ap : resource.profile().accessPoints()) {
                    if (!ap.name().equals("server" + (i + 1))) continue;
                    server.add(ap.address());
                    this.setUsername(ap.username());
                    this.setPassword("");
                    if (this.getUsername() != null && this.getUsername().length() > 0) {
                        try {
                            this.setPassword(StringEncrypter.getEncrypter().decrypt(ap.password()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                logger.info("credentials Mongodb: " + this.getUsername() + " " + this.getPassword());
            }
            String[] volatileHost = new String[]{this.retrievePropertyValue(resource, "volatile")};
            this.setVolatileHost(volatileHost);
            logger.info("Type of backend found in RR is " + this.backendType);
            String[] servers = new String[server.size()];
            servers = server.toArray(servers);
            return servers;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    private void decryptPwd(ServiceEndpoint.AccessPoint ap) {
        this.setPassword("");
        if (this.getUsername() != null && this.getUsername().length() > 0) {
            try {
                this.setPassword(StringEncrypter.getEncrypter().decrypt(ap.password()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ServiceEndpoint getPriorityResource(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            this.setStorageResource(res);
            logger.info("found a RR with priority: ");
            break;
        }
        return defaultResource;
    }

    public String getBackendType(ServiceEndpoint resource) {
        if (this.getBackendType() != null) {
            return this.getBackendType();
        }
        this.setBackendType(this.retrievePropertyValue(resource, "type"));
        return this.getBackendType();
    }

    public String[] getVolatileHost(ServiceEndpoint resource) {
        if (this.getVolatileHost() != null) {
            return this.getVolatileHost();
        }
        String[] volatileHost = new String[]{this.retrievePropertyValue(resource, "volatile")};
        this.setVolatileHost(volatileHost);
        return volatileHost;
    }

    public String retrievePropertyValue(String name) {
        ServiceEndpoint.AccessPoint ap;
        Map map;
        ServiceEndpoint.Property type;
        ServiceEndpoint res = this.getStorageEndpoint();
        Iterator it = res.profile().accessPoints().iterator();
        String value = null;
        while (it.hasNext() && ((type = (ServiceEndpoint.Property)(map = (ap = (ServiceEndpoint.AccessPoint)it.next()).propertyMap()).get(name)) == null || (value = type.value()) == null)) {
        }
        return value;
    }

    public String retrievePropertyValue(ServiceEndpoint.AccessPoint ap, String name) {
        String value = null;
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            value = type.value();
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    public String getResolverHost(ServiceEndpoint serviceEndpoint) {
        return serviceEndpoint.profile().runtime().hostedOn();
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getBackendType() {
        return this.backendType;
    }

    private void setBackendType(String backendType) {
        this.backendType = backendType;
    }

    public String[] getVolatileHost() {
        return this.volatileHost;
    }

    public void setVolatileHost(String[] volatileHost) {
        this.volatileHost = volatileHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServiceEndpoint getStorageResource() {
        return this.storageResource;
    }

    public void setStorageResource(ServiceEndpoint storageResource) {
        this.storageResource = storageResource;
    }

    private void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }
}

