/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement;

import java.io.InputStream;
import java.net.MalformedURLException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringEncrypter;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.ExternalResourceLinkPlugin;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ExternalResourceBrokenLinkException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;

public class StorageManagerResourcePlugin
implements ExternalResourceLinkPlugin {
    public String getPluginName() {
        return this.getClass().getName();
    }

    public InputStream getContent(ExternalResourceLink item) throws ExternalResourceBrokenLinkException, InternalErrorException {
        String url = item.getResourceId();
        try {
            IClient client = this.getStorageClient(url);
            String[] urlParam = url.split("\\?");
            String location = StorageManagerResourcePlugin.extractLocation(urlParam[0]);
            InputStream is = client.get().RFileAStream(location);
            if (is == null) {
                throw new ExternalResourceBrokenLinkException("Link " + url + " broken");
            }
            return is;
        }
        catch (MalformedURLException e) {
            throw new InternalErrorException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
    }

    private IClient getStorageClient(String url) throws StringEncrypter.EncryptionException, MalformedURLException, Exception {
        String[] urlParam = url.split("\\?");
        String param = new StringEncrypter("DES").decrypt(urlParam[1]);
        String[] getParam = param.split("\\&");
        String serviceClass = null;
        String serviceName = null;
        String owner = null;
        String accessType = null;
        String scopeType = null;
        AccessType type = null;
        String server = null;
        for (String par : getParam) {
            String[] par1;
            if (par.contains("ServiceClass")) {
                par1 = par.split("=");
                serviceClass = par1[1];
                continue;
            }
            if (par.contains("ServiceName")) {
                par1 = par.split("=");
                serviceName = par1[1];
                continue;
            }
            if (par.contains("owner")) {
                par1 = par.split("=");
                owner = par1[1];
                continue;
            }
            if (par.contains("scope")) {
                par1 = par.split("=");
                scopeType = par1[1];
                continue;
            }
            if (par.contains("server")) {
                par1 = par.split("=");
                server = par1[1];
                continue;
            }
            if (!par.contains("AccessType")) continue;
            par1 = par.split("=");
            accessType = par1[1];
            if (accessType.equalsIgnoreCase("public")) {
                type = AccessType.PUBLIC;
                continue;
            }
            if (!accessType.equalsIgnoreCase("shared")) continue;
            type = AccessType.SHARED;
        }
        if (serviceName == null || serviceClass == null || owner == null || scopeType == null || type == null) {
            throw new MalformedURLException();
        }
        GCUBEScope scope = GCUBEScope.getScope(scopeType);
        System.out.println(scopeType);
        IClient client = new StorageClient(serviceClass, serviceName, owner, type, scopeType, server).getClient();
        return client;
    }

    public static String extractLocation(String url) {
        String[] loc = url.split("//");
        return loc[1];
    }

    public long getSize(ExternalResourceLink item) throws ExternalResourceBrokenLinkException, InternalErrorException {
        String url = item.getResourceId();
        try {
            IClient client = this.getStorageClient(url);
            String[] urlParam = url.split("\\?");
            String location = StorageManagerResourcePlugin.extractLocation(urlParam[0]);
            return client.getSize().RFile(location);
        }
        catch (MalformedURLException e) {
            throw new InternalErrorException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
    }
}

