/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.sf.csv4j.CSVFieldMapProcessor;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReader;
import net.sf.csv4j.CSVSortedFieldMapProcessor;
import net.sf.csv4j.LineToFieldMapAdapter;
import net.sf.csv4j.LineToSortedFieldMapAdapter;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;

public class CSVStreamProcessor {
    private char comment = (char)35;
    private boolean hasHeader = true;

    public char getComment() {
        return this.comment;
    }

    public void setComment(char comment) {
        this.comment = comment;
    }

    public boolean isHasHeader() {
        return this.hasHeader;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processStream(InputStreamReader is, CSVLineProcessor processor) throws IOException, ProcessingException, ParseException {
        try (CSVReader reader = new CSVReader(new BufferedReader(is), this.comment);){
            List<String> fields;
            int lineCnt = 0;
            while (processor.continueProcessing() && (fields = reader.readLine()).size() != 0) {
                try {
                    if (this.hasHeader && lineCnt == 0) {
                        processor.processHeaderLine(reader.getLineNumber(), fields);
                    } else {
                        processor.processDataLine(reader.getLineNumber(), fields);
                    }
                }
                catch (Exception e) {
                    throw new ProcessingException(e, reader.getLineNumber());
                }
                ++lineCnt;
            }
            int n = lineCnt;
            return n;
        }
    }

    public int processStream(InputStreamReader is, CSVFieldMapProcessor processor) throws IOException, ProcessingException, ParseException {
        this.hasHeader = true;
        return this.processStream(is, new LineToFieldMapAdapter(processor));
    }

    public int processStream(InputStreamReader is, CSVSortedFieldMapProcessor processor) throws IOException, ProcessingException, ParseException {
        this.hasHeader = true;
        return this.processStream(is, new LineToSortedFieldMapAdapter(processor));
    }
}

