/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTTL
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public GetTTL(String[] server, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getPathServer() + " in bucket: " + this.bucket);
        }
        long currentTTL = -1L;
        try {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server);
            TransportManager tm = tmf.getTransport(this.backendType);
            currentTTL = tm.getTTL(this.bucket);
        }
        catch (Exception e) {
            throw new RemoteBackendException(" Error in getTTL operation ", e.getCause());
        }
        return currentTTL + "";
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName;
        this.localPath = file.getPathClient();
        this.remotePath = remotePath;
        this.bucket = bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

