/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.InputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Upload.class);
    private InputStream is;
    private boolean replaceOption;

    public Upload(String[] server, String bucket, Monitor monitor, boolean isChunk, String bck) {
        super(server, bucket, monitor, isChunk, bck);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" UPLOAD " + myFile.getPathClient() + " author: " + myFile.getOwner());
        }
        String objectId = null;
        try {
            objectId = this.put(myFile, this.isChunk, false, this.replaceOption, false);
        }
        catch (Throwable e) {
            throw new RemoteBackendException(" Error in upload operation ", e.getCause());
        }
        return objectId;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        this.replaceOption = replaceOption;
        DirectoryBucket dirBuc = new DirectoryBucket(server, remotePath, author);
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        Object dirObject = null;
        this.bucket = bucketName;
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String remotePath, String author, String[] server, String rootArea) {
        DirectoryBucket dirBuc = new DirectoryBucket(server, remotePath, author);
        String bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        Object dirObject = null;
        this.is = resource.getInputStream();
        this.bucket = bucketName;
        return this.bucket;
    }
}

