/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.DateUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoInputStream;
import org.gcube.contentmanagement.blobstorage.transport.backend.util.MongoOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMongoClient
extends TransportManager {
    final Logger logger = LoggerFactory.getLogger(DefaultMongoClient.class);
    private String[] server;
    private Mongo mongo;
    private static DefaultMongoClient istance;
    private static final String ROOT_PATH_PATCH_V1 = "/home/null/";
    private static final String ROOT_PATH_PATCH_V2 = "/public/";

    public DefaultMongoClient(String[] server) {
        try {
            this.server = server;
            DB db = this.getDB();
            DBCollection coll = db.getCollection("fs.files");
            coll.createIndex(new BasicDBObject("filename", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object get(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient get method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        GridFSDBFile f = this.retrieveRemoteObject(serverLocation, gfs, 0);
        Object id = null;
        if (f != null) {
            id = f.getId();
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                if (f.containsField("lock") && f.get("lock") != null) {
                    f.put("lock", null);
                    f.save();
                }
                this.download(gfs, resource, f, false);
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return id;
    }

    private GridFSDBFile retrieveRemoteObject(String serverLocation, GridFS gfs, int count) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        GridFSDBFile f = null;
        f = gfs.findOne(serverLocation);
        if (f == null) {
            f = this.patchRemoteFilePathVersion1(serverLocation, gfs);
        }
        if (f == null) {
            try {
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)new ObjectId(serverLocation));
                f = gfs.findOne(query);
            }
            catch (Exception e) {
                f = null;
            }
        }
        return f;
    }

    private void checkTTL(GridFSDBFile f) throws IllegalAccessError {
        if (f.containsField("timestamp") && f.get("timestamp") != null) {
            long timestamp = (Long)f.get("timestamp");
            long currentTTL = System.currentTimeMillis() - timestamp;
            throw new IllegalAccessError("the file is locked currentTTL: " + currentTTL + "TTL bound " + 180000L);
        }
        this.checkTTL(f);
    }

    private boolean isTTLUnlocked(GridFSDBFile f) {
        if (f.get("timestamp") == null) {
            return true;
        }
        long timestamp = (Long)f.get("timestamp");
        System.out.println("timestamp found: " + timestamp);
        if (timestamp != 0L) {
            long currentTTL = System.currentTimeMillis() - timestamp;
            System.out.println("currentTTL: " + currentTTL + " TTL stabilito: " + 180000L);
            if (180000L < currentTTL) {
                f.put("timestamp", null);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String lock(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        GridFSDBFile f;
        if (resource.getPathClient() != null && !resource.getPathClient().isEmpty()) {
            this.get(resource, serverLocation, type).toString();
        }
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient lock method: " + op.toString());
        String key = null;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        Class<? extends Object> o = type;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + serverLocation);
        }
        if ((f = gfs.findOne(serverLocation)) == null) {
            f = this.patchRemoteFilePathVersion1(serverLocation, gfs);
        }
        if (f == null) {
            try {
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)new ObjectId(serverLocation));
                f = gfs.findOne(query);
            }
            catch (Exception e) {
                f = null;
            }
        }
        if (f != null) {
            String lock = (String)f.get("lock");
            if (lock == null || lock.isEmpty() || this.isTTLUnlocked(f)) {
                key = f.getId() + "" + System.currentTimeMillis();
                f.put("lock", key);
                f.put("timestamp", System.currentTimeMillis());
                f.save();
            } else {
                this.checkTTL(f);
            }
        } else {
            this.mongo.close();
            throw new FileNotFoundException("REMOTE FILE NOT FOUND: WRONG PATH OR WRONG OBJECT ID");
        }
        return key;
    }

    @Override
    public String put(Object resource, String bucket, String key, boolean replace) throws UnknownHostException {
        GridFSDBFile fold;
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient put method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((fold = gfs.findOne(path)) != null) {
            String oldir = (String)fold.get("dir");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("old dir  found " + oldir);
            }
            if (oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir())) {
                String lock;
                ObjectId oldId = (ObjectId)fold.getId();
                if (!replace) {
                    return oldId.toString();
                }
                if (fold.containsField("countLink") && fold.get("countLink") != null) {
                    throw new RemoteBackendException("The file cannot be replaced because is linked from another remote file");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("remove id: " + oldId);
                }
                if (!((lock = (String)fold.get("lock")) == null || lock.isEmpty() || this.isTTLUnlocked(fold) || lock.equalsIgnoreCase(key))) {
                    throw new IllegalAccessError("The file is locked");
                }
                gfs.remove(oldId);
            }
        }
        GridFSInputFile f2 = null;
        f2 = this.preparePayload(resource, gfs, 0, bucket, name, dir);
        Object id = f2.getId();
        return id.toString();
    }

    private GridFSInputFile preparePayload(Object resource, GridFS gfs, int count, String bucket, String name, String dir) {
        GridFSInputFile f2 = null;
        try {
            if (((MyFile)resource).getInputStream() != null) {
                f2 = gfs.createFile(((MyFile)resource).getInputStream());
                f2.save();
                ((MyFile)resource).getInputStream().close();
                ((MyFile)resource).setInputStream(null);
            } else {
                f2 = ((MyFile)resource).getType() != null && ((MyFile)resource).getType().equals("output") ? gfs.createFile(((MyFile)resource).getName()) : gfs.createFile(new File(((MyFile)resource).getPathClient()));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            f2.put("filename", bucket);
            f2.put("type", "file");
            f2.put("name", name);
            f2.put("dir", dir);
            f2.put("owner", ((MyFile)resource).getOwner());
            f2.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
            Object id = f2.getId();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + id);
            }
            this.buildDirTree(gfs, dir);
            if (((MyFile)resource).getType() != null && ((MyFile)resource).getType().equals("output")) {
                ((MyFile)resource).setOutputStream(new MongoOutputStream(this.mongo, f2.getOutputStream()));
            } else {
                f2.save();
                this.mongo.close();
            }
        }
        catch (IOException e1) {
            this.logger.error("Connection error. " + e1.getMessage());
            if (count < 9) {
                this.logger.info(" Retry : #" + ++count);
                this.preparePayload(resource, gfs, count, bucket, name, dir);
            }
            this.logger.error("max number of retry completed ");
            throw new RemoteBackendException(e1);
        }
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String unlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException {
        GridFSDBFile f;
        String id = null;
        if (((MyFile)resource).getPathClient() != null && !((MyFile)resource).getPathClient().isEmpty()) {
            id = this.put(resource, bucket, key4unlock, true);
        }
        OperationDefinition op = ((MyFile)resource).getOperationDefinition();
        this.logger.info("MongoClient unlock method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        String dir = ((MyFile)resource).getRemoteDir();
        String name = ((MyFile)resource).getName();
        String path = bucket;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DIR: " + dir + " name: " + name + " fullPath " + path + " bucket: " + bucket);
        }
        if ((f = gfs.findOne(path)) == null) {
            f = gfs.findOne(new ObjectId(path));
        }
        if (f == null) {
            f = this.patchRemoteFilePathVersion1(path, gfs);
        }
        if (f == null) throw new FileNotFoundException(path);
        String oldir = (String)f.get("dir");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("old dir  found " + oldir);
        }
        if (!oldir.equalsIgnoreCase(((MyFile)resource).getRemoteDir()) && ((MyFile)resource).getRemoteDir() != null) throw new FileNotFoundException(path);
        String lock = (String)f.get("lock");
        if (lock == null || lock.isEmpty()) return id;
        String lck = (String)f.get("lock");
        if (!lck.equalsIgnoreCase(key4unlock)) throw new IllegalAccessError("bad key for unlock");
        f.put("lock", null);
        f.put("timestamp", null);
        f.save();
        return id;
    }

    @Override
    public Map getValues(MyFile resource, String bucket, Class<? extends Object> type) throws UnknownHostException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient getValues method: " + op.toString());
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo get values of dir: " + bucket);
        }
        HashMap<Object, StorageObject> map = null;
        BasicDBObject query = new BasicDBObject();
        query.put("dir", (Object)bucket);
        List<GridFSDBFile> list = gfs.find(query);
        list = this.patchRemoteDirPathVersion1(bucket, gfs, query, list);
        for (GridFSDBFile f : list) {
            if (map == null) {
                map = new HashMap<Object, StorageObject>();
            }
            StorageObject s_obj = null;
            if (f.get("type") == null || f.get("type").toString().equalsIgnoreCase("file")) {
                String creationTime;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found object: " + f.get("name") + "    type:  " + f.get("type"));
                }
                s_obj = new StorageObject(f.get("name").toString(), "file");
                String owner = (String)f.get("owner");
                if (owner != null) {
                    s_obj.setOwner(owner);
                }
                if ((creationTime = (String)f.get("creationTime")) != null) {
                    s_obj.setCreationTime(creationTime);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found directory: " + f.get("name") + "    type:  " + f.get("type"));
                }
                BasicDBObject queryDir = new BasicDBObject();
                queryDir.put("dir", (Object)(f.get("dir").toString() + f.get("name").toString()));
                List<GridFSDBFile> listDir = gfs.find(queryDir);
                s_obj = list != null && list.size() > 0 ? new StorageObject(f.get("name").toString(), "dir") : null;
            }
            if (s_obj == null) continue;
            map.put(f.get("name"), s_obj);
        }
        this.mongo.close();
        return map;
    }

    @Override
    public void removeRemoteFile(String bucket) throws UnknownHostException {
        GridFSDBFile f;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mongo delete bucket: " + bucket);
        }
        if ((f = gfs.findOne(bucket)) == null) {
            f = this.patchRemoteFilePathVersion1(bucket, gfs);
        }
        if (f != null) {
            this.checkAndRemove(gfs, f);
        } else {
            ObjectId id;
            GridFSDBFile fID;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File Not Found. Try to delete by ObjectID");
            }
            if (bucket.length() > 23 && (fID = gfs.findOne(id = new ObjectId(bucket))) != null) {
                String dir = (String)fID.get("dir");
                String filename = (String)fID.get("filename");
                this.checkAndRemove(gfs, fID);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("object deleted by ID");
                }
            }
        }
        this.mongo.close();
    }

    private void checkAndRemove(GridFS gfs, GridFSDBFile f) {
        this.logger.info("check and remove object with id " + f.getId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("fileFound\n remove file");
        }
        if (f != null && f.containsField("linkCount") && f.get("linkCount") != null) {
            f.put("dir", null);
            f.put("filename", null);
            f.put("name", null);
            f.save();
        } else if (f.containsField("link") && f.get("link") != null) {
            while (f != null && f.containsField("link") && f.get("link") != null) {
                ObjectId oId;
                String id = (String)f.get("link");
                GridFSDBFile fLink = gfs.find(new ObjectId(id));
                int linkCount = (Integer)fLink.get("linkCount");
                if (--linkCount == 0) {
                    if (fLink.get("name") == null && fLink.get("filename") == null && fLink.get("dir") == null) {
                        ObjectId idF = (ObjectId)f.getId();
                        gfs.remove(idF);
                        if (fLink.containsField("link") && fLink.get("link") != null) {
                            id = (String)fLink.get("link");
                            f = gfs.find(new ObjectId(id));
                        } else {
                            f = null;
                        }
                        ObjectId idLink = (ObjectId)fLink.getId();
                        gfs.remove(idLink);
                        continue;
                    }
                    fLink.put("linkCount", null);
                    fLink.save();
                    oId = (ObjectId)f.getId();
                    gfs.remove(oId);
                    f = null;
                    continue;
                }
                fLink.put("linkCount", linkCount);
                fLink.save();
                oId = (ObjectId)f.getId();
                gfs.remove(oId);
                f = null;
            }
        } else {
            ObjectId id = (ObjectId)f.getId();
            gfs.remove(id);
        }
    }

    @Override
    public void removeDir(String remoteDir) throws UnknownHostException {
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(remoteDir);
        if (remoteDir.contains(ROOT_PATH_PATCH_V1) || remoteDir.contains(ROOT_PATH_PATCH_V2)) {
            if (remoteDir.contains(ROOT_PATH_PATCH_V1)) {
                String remoteDirV1 = remoteDir.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
                dirs.add(remoteDirV1);
            } else {
                String remoteDirV2 = remoteDir.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1);
                dirs.add(remoteDirV2);
                String remoteDirV2patch = "/" + remoteDirV2;
                dirs.add(remoteDirV2patch);
            }
        }
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        for (String directory : dirs) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mongo delete bucket: " + directory);
            }
            BasicDBObject query = new BasicDBObject();
            String regex = directory + "*";
            query.put("dir", (Object)Pattern.compile(regex));
            this.removeObject(gfs, query);
            query = new BasicDBObject();
            String[] dir = directory.split("/");
            StringBuffer parentDir = new StringBuffer();
            for (int i = 0; i < dir.length - 1; ++i) {
                parentDir.append(dir[i] + "/");
            }
            String name = dir[dir.length - 1];
            query.put("dir", (Object)parentDir.toString());
            query.put("name", (Object)name);
            this.removeObject(gfs, query);
        }
        this.mongo.close();
    }

    @Override
    public long getSize(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long length = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = gfs.findOne(remotePath)) == null) {
            f = this.patchRemoteFilePathVersion1(remotePath, gfs);
        }
        if (f != null) {
            length = f.getLength();
        }
        this.mongo.close();
        return length;
    }

    @Override
    public long getTTL(String remotePath) throws UnknownHostException {
        GridFSDBFile f;
        long timestamp = -1L;
        long currentTTL = -1L;
        long remainsTTL = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MongoDB - pathServer: " + remotePath);
        }
        if ((f = gfs.findOne(remotePath)) == null) {
            f = this.patchRemoteFilePathVersion1(remotePath, gfs);
        }
        if (f != null && (timestamp = ((Long)f.get("timestamp")).longValue()) > 0L) {
            currentTTL = System.currentTimeMillis() - timestamp;
            remainsTTL = 180000L - currentTTL;
        }
        this.mongo.close();
        return remainsTTL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long renewTTL(MyFile resource) throws UnknownHostException, IllegalAccessException {
        String lock;
        long ttl = -1L;
        DB db = this.getDB();
        GridFS gfs = new GridFS(db);
        MyFile file = resource;
        String key = file.getLockedKey();
        String remotePath = file.getPathServer();
        GridFSDBFile f = gfs.findOne(remotePath);
        if (f == null) {
            f = this.patchRemoteFilePathVersion1(remotePath, gfs);
        }
        if (f != null && (lock = (String)f.get("lock")) != null && !lock.isEmpty()) {
            String lck = (String)f.get("lock");
            if (!lck.equalsIgnoreCase(key)) throw new IllegalAccessError("bad key for unlock");
            if (f.containsField("countRenew") && f.get("countRenew") != null) {
                int count = (Integer)f.get("countRenew");
                if (count >= 5) throw new IllegalAccessException("The number max of TTL renew reached. The number max is: 5");
                f.put("countRenew", count + 1);
            } else {
                f.put("countRenew", 1);
            }
            f.put("timestamp", System.currentTimeMillis());
            f.save();
            ttl = 180000L;
        }
        this.mongo.close();
        return ttl;
    }

    @Override
    public void initBackend(String[] server) {
        try {
            this.server = server;
            DB db = this.getDB();
            DBCollection coll = db.getCollection("fs.files");
            coll.createIndex(new BasicDBObject("filename", (Object)1));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    private void buildDirTree(GridFS gfs, String dir) {
        String[] dirTree = dir.split("/");
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("/");
        for (int i = 1; i < dirTree.length; ++i) {
            BasicDBObject query = new BasicDBObject();
            query.put("name", (Object)dirTree[i]);
            query.put("dir", (Object)strBuff.toString());
            query.put("type", (Object)"dir");
            GridFSDBFile f = gfs.findOne(query);
            if (f == null) {
                byte[] data = new byte[1];
                GridFSInputFile f3 = gfs.createFile(data);
                f3.put("name", dirTree[i]);
                f3.put("dir", strBuff.toString());
                f3.put("type", "dir");
                f3.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" Create new  object with name: " + dirTree[i] + " dir: " + strBuff.toString() + " type= dir");
                }
            }
            strBuff.append(dirTree[i] + "/");
        }
    }

    private void download(GridFS gfs, MyFile resource, GridFSDBFile f, boolean isLock) throws IOException {
        OperationDefinition op = resource.getOperationDefinition();
        this.logger.info("MongoClient download method: " + op.toString());
        while (f != null && f.containsField("link") && f.get("link") != null) {
            BasicDBObject query = new BasicDBObject();
            query.put("_id", (Object)new ObjectId((String)f.get("link")));
            f = gfs.findOne(query);
        }
        if (resource.getPathClient() != null && !resource.getPathClient().isEmpty()) {
            this.writeByPath(resource, f, isLock, 0);
        } else if (resource.getOutputStream() != null) {
            this.writeByOutputStream(resource, f, isLock, 0);
            this.mongo.close();
        }
        if (resource != null && resource.getType() != null && resource.getType().equalsIgnoreCase("input")) {
            this.writeByInputStream(resource, f, isLock, 0);
        }
    }

    private String writeByInputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) {
        String key = null;
        resource.setInputStream(new MongoInputStream(this.mongo, f.getInputStream()));
        return key;
    }

    private String writeByOutputStream(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        f.writeTo(resource.getOutputStream());
        resource.setOutputStream(null);
        f.save();
        return key;
    }

    private String writeByPath(MyFile resource, GridFSDBFile f, boolean isLock, int count) throws IOException {
        String key = null;
        try {
            MongoInputStream is = new MongoInputStream(this.mongo, f.getInputStream());
            File file = new File(resource.getPathClient());
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.close();
            is.close();
            resource.setPathClient(null);
        }
        catch (IOException e) {
            this.logger.error("Connection error. " + e.getMessage());
            if (count < 9) {
                this.logger.info(" Retry : #" + ++count);
                this.writeByPath(resource, f, isLock, count);
            }
            this.logger.error("max number of retry completed ");
            throw new RuntimeException(e);
        }
        return key;
    }

    private void removeObject(GridFS gfs, BasicDBObject query) {
        List<GridFSDBFile> list = gfs.find(query);
        for (GridFSDBFile f : list) {
            if (f != null) {
                this.checkAndRemove(gfs, f);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("File Not Found");
        }
    }

    private DB getDB() throws UnknownHostException {
        DB db = null;
        int i = -1;
        for (String srv : this.server) {
            try {
                ++i;
                if (this.mongo != null) {
                    this.mongo.close();
                }
                MongoOptions options = new MongoOptions();
                options.autoConnectRetry = true;
                options.socketKeepAlive = true;
                options.maxWaitTime = 240000;
                options.connectionsPerHost = 35;
                this.mongo = new Mongo(srv, options);
                this.logger.debug("Istantiate MongoDB with options: " + this.mongo.getMongoOptions());
                db = this.mongo.getDB("remotefs");
                GridFS gfs = new GridFS(db);
                String firstServer = this.server[0];
                this.server[0] = srv;
                this.server[i] = firstServer;
                break;
            }
            catch (Exception e) {
                this.logger.warn("server " + srv + " is not a primary retry ");
            }
        }
        return db;
    }

    private GridFSDBFile patchRemoteFilePathVersion1(String serverLocation, GridFS gfs) {
        GridFSDBFile f = null;
        String path = serverLocation;
        String locationV1 = null;
        if (serverLocation.contains(ROOT_PATH_PATCH_V1)) {
            locationV1 = path.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            f = gfs.findOne(locationV1);
            if (f == null) {
                String locationV1patch = locationV1.substring(1);
                f = gfs.findOne(locationV1patch);
            }
        } else if (serverLocation.contains(ROOT_PATH_PATCH_V2) && (f = gfs.findOne(locationV1 = path.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1))) == null) {
            String locationV1patch = "/" + locationV1;
            f = gfs.findOne(locationV1patch);
        }
        return f;
    }

    private List<GridFSDBFile> patchRemoteDirPathVersion1(String bucket, GridFS gfs, BasicDBObject query, List<GridFSDBFile> list) {
        List<GridFSDBFile> patchList = null;
        if (bucket.contains(ROOT_PATH_PATCH_V1)) {
            String locationV2 = bucket.replace(ROOT_PATH_PATCH_V1, ROOT_PATH_PATCH_V2);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV2);
            patchList = gfs.find(queryPatch);
        } else if (bucket.contains(ROOT_PATH_PATCH_V2)) {
            String locationV1 = bucket.replace(ROOT_PATH_PATCH_V2, ROOT_PATH_PATCH_V1);
            BasicDBObject queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV1);
            patchList = gfs.find(queryPatch);
            String locationV1patch = "/" + locationV1;
            queryPatch = new BasicDBObject();
            queryPatch.put("dir", (Object)locationV1patch);
            List<GridFSDBFile> patchList2 = gfs.find(queryPatch);
            if (patchList2 != null && !patchList2.isEmpty()) {
                if (patchList != null) {
                    patchList.addAll(patchList2);
                } else {
                    patchList = patchList2;
                }
            }
        }
        if (patchList != null && !patchList.isEmpty()) {
            list.addAll((Collection<GridFSDBFile>)patchList);
        }
        return list;
    }

    @Override
    public String link(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        GridFSInputFile destinationFile;
        GridFS gfs;
        boolean replace = true;
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        String sourceId = null;
        this.logger.debug("link operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            int count;
            DB db = this.getDB();
            gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                count = 1;
                if (f.containsField("linkCount") && f.get("linkCount") != null) {
                    count = (Integer)f.get("linkCount");
                    ++count;
                }
            } else {
                throw new IllegalArgumentException(" source remote file not found at: " + source);
            }
            f.put("linkCount", count);
            sourceId = f.getId().toString();
            f.save();
            GridFSDBFile fold = gfs.findOne(destinationPath);
            if (fold != null) {
                String oldir = (String)fold.get("dir");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("old dir  found " + oldir);
                }
                if (oldir.equalsIgnoreCase(resource.getRemoteDir())) {
                    String lock;
                    ObjectId oldId = (ObjectId)fold.getId();
                    if (!replace) {
                        return oldId.toString();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("remove id: " + oldId);
                    }
                    if ((lock = (String)fold.get("lock")) != null && !lock.isEmpty() && !this.isTTLUnlocked(fold)) {
                        throw new IllegalAccessError("The file is locked");
                    }
                    gfs.remove(oldId);
                }
            }
            destinationFile = null;
            byte[] data = new byte[1];
            destinationFile = gfs.createFile(data);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Directory: " + dir);
            }
            destinationFile.put("filename", destinationPath);
            destinationFile.put("type", "file");
            destinationFile.put("name", name);
            destinationFile.put("dir", dir);
            destinationFile.put("owner", resource.getOwner());
            destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
            destinationFile.put("link", sourceId);
            destinationId = destinationFile.getId().toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ObjectId: " + destinationId);
            }
        } else {
            throw new IllegalArgumentException(" invalid argument: source: " + source + " dest: " + destination + " the values must be not null and not empty");
        }
        this.buildDirTree(gfs, dir);
        destinationFile.save();
        this.mongo.close();
        return destinationId.toString();
    }

    @Override
    public String copy(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        this.logger.debug("copy operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                InputStream is = f.getInputStream();
                GridFSDBFile dest = gfs.findOne(destination);
                GridFSInputFile destinationFile = gfs.createFile(is);
                if (dest != null) {
                    this.checkAndRemove(gfs, dest);
                    destinationFile.put("filename", destination);
                    destinationFile.put("type", "file");
                    destinationFile.put("name", destination.substring(destination.lastIndexOf("/") + 1));
                    destinationFile.put("dir", dir);
                    destinationFile.put("owner", resource.getOwner());
                    destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                    this.buildDirTree(gfs, dir);
                } else {
                    BasicDBObject query = new BasicDBObject();
                    query.put("dir", (Object)destination);
                    List<GridFSDBFile> folder = gfs.find(query);
                    if (folder != null && folder.size() > 0) {
                        destination = this.appendFileSeparator(destination);
                        destinationFile.put("filename", destination + name);
                        destinationFile.put("type", "file");
                        destinationFile.put("name", name);
                        destinationFile.put("dir", destination);
                        destinationFile.put("owner", resource.getOwner());
                        destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        this.buildDirTree(gfs, destination);
                    } else if (destination.lastIndexOf("/") == destination.length() - 1) {
                        destinationFile.put("filename", destination + name);
                        destinationFile.put("type", "file");
                        destinationFile.put("name", name);
                        destinationFile.put("dir", destination);
                        destinationFile.put("owner", resource.getOwner());
                        destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        this.buildDirTree(gfs, destination);
                    } else {
                        destinationFile.put("filename", destination);
                        destinationFile.put("type", "file");
                        String newName = destination.substring(destination.lastIndexOf("/") + 1);
                        destinationFile.put("name", newName);
                        destinationFile.put("dir", dir);
                        destinationFile.put("owner", resource.getOwner());
                        destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        this.buildDirTree(gfs, dir);
                    }
                }
                destinationId = destinationFile.getId().toString();
                destinationFile.save();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ObjectId: " + destinationId);
                }
                this.mongo.close();
            } else {
                throw new RemoteBackendException(" the source path is wrong. There isn't a file");
            }
        }
        return destinationId.toString();
    }

    @Override
    public String move(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        String destination = destinationPath;
        String dir = resource.getRemoteDir();
        String name = resource.getName();
        String destinationId = null;
        this.logger.debug("move operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            GridFSDBFile f = gfs.findOne(source);
            if (f != null) {
                GridFSDBFile fNewPath = gfs.findOne(destinationPath);
                if (fNewPath != null) {
                    ObjectId oldId = (ObjectId)fNewPath.getId();
                    gfs.remove(oldId);
                    this.checkAndRemove(gfs, fNewPath);
                    f.put("dir", dir);
                    f.put("filename", destinationPath);
                    f.put("name", name);
                    f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                    f.put("owner", resource.getOwner());
                    destinationId = f.getId().toString();
                    this.buildDirTree(gfs, dir);
                    f.save();
                } else {
                    BasicDBObject query = new BasicDBObject();
                    query.put("dir", (Object)destination);
                    List<GridFSDBFile> folder = gfs.find(query);
                    if (folder != null && folder.size() > 0) {
                        destination = this.appendFileSeparator(destination);
                        f.put("filename", destination + name);
                        f.put("type", "file");
                        f.put("name", name);
                        f.put("dir", destination);
                        f.put("owner", resource.getOwner());
                        f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, destination);
                    } else if (destination.lastIndexOf("/") == destination.length() - 1) {
                        f.put("filename", destination + name);
                        f.put("type", "file");
                        f.put("name", name);
                        f.put("dir", destination);
                        f.put("owner", resource.getOwner());
                        f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, destination);
                    } else {
                        f.put("filename", destination);
                        f.put("type", "file");
                        String newName = destination.substring(destination.lastIndexOf("/") + 1);
                        f.put("name", newName);
                        f.put("dir", dir);
                        f.put("owner", resource.getOwner());
                        f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                        destinationId = f.getId().toString();
                        this.buildDirTree(gfs, dir);
                    }
                    f.save();
                }
                this.mongo.close();
                return destinationId;
            }
            throw new RemoteBackendException(" the source path is wrong. There isn't a file at this path: " + source);
        }
        throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
    }

    @Override
    public String getName() {
        return "MongoDB";
    }

    @Override
    public List<String> copyDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        String parentFolder = this.extractParent(source);
        String destinationId = null;
        ArrayList<String> idList = null;
        this.logger.debug("copyDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", (Object)new BasicDBObject("$regex", source + "*"));
            List<GridFSDBFile> folder = gfs.find(query);
            if (folder != null) {
                idList = new ArrayList<String>(folder.size());
                for (GridFSDBFile f : folder) {
                    if (!f.get("type").equals("file")) continue;
                    InputStream is = f.getInputStream();
                    String name = (String)f.get("name");
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    GridFSInputFile destinationFile = gfs.createFile(is);
                    destinationFile.put("filename", filename);
                    destinationFile.put("type", "file");
                    destinationFile.put("dir", dir);
                    destinationFile.put("owner", resource.getOwner());
                    destinationFile.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                    idList.add(destinationFile.getId().toString());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ObjectId: " + destinationId);
                    }
                    this.buildDirTree(gfs, dir);
                    destinationFile.save();
                }
            }
            this.mongo.close();
        }
        return idList;
    }

    @Override
    public List<String> moveDir(MyFile resource, String sourcePath, String destinationPath) throws UnknownHostException {
        String source = sourcePath;
        source = this.appendFileSeparator(source);
        String parentFolder = this.extractParent(source);
        String destination = destinationPath;
        destination = this.appendFileSeparator(destination);
        ArrayList<String> idList = null;
        this.logger.debug("moveDir operation on Mongo backend, parameters: source path: " + source + " destination path: " + destination);
        if (source != null && !source.isEmpty() && destination != null && !destination.isEmpty()) {
            DB db = this.getDB();
            GridFS gfs = new GridFS(db);
            BasicDBObject query = new BasicDBObject();
            query.put("dir", (Object)new BasicDBObject("$regex", source + "*"));
            List<GridFSDBFile> folder = gfs.find(query);
            if (folder != null && folder.size() > 0) {
                Object subTree = null;
                for (GridFSDBFile f : folder) {
                    if (idList == null) {
                        idList = new ArrayList<String>(folder.size());
                    }
                    String name = (String)f.get("name");
                    if (!f.get("type").equals("file")) continue;
                    String oldFilename = (String)f.get("filename");
                    String oldDir = (String)f.get("dir");
                    int relativePathIndex = source.length();
                    String relativeDirTree = parentFolder + "/" + oldDir.substring(relativePathIndex);
                    String relativePath = parentFolder + "/" + oldFilename.substring(relativePathIndex);
                    String filename = destination + relativePath;
                    String dir = destination + relativeDirTree;
                    f.put("filename", filename);
                    f.put("dir", dir);
                    f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
                    f.put("owner", resource.getOwner());
                    String id = f.getId().toString();
                    idList.add(id);
                    f.save();
                    this.buildDirTree(gfs, dir);
                }
            }
        } else {
            throw new IllegalArgumentException("parameters not completed, source: " + source + ", destination: " + destination);
        }
        this.mongo.close();
        return idList;
    }

    private List<String> moveDirTree(MyFile resource, String parentFolder, String destination, List<String> idList, GridFS gfs, List<GridFSDBFile> folder) {
        for (GridFSDBFile f1 : folder) {
            this.logger.info("name " + f1.get("name"));
        }
        for (GridFSDBFile f : folder) {
            String dir;
            if (idList == null) {
                idList = new ArrayList<String>(folder.size());
            }
            String name = (String)f.get("name");
            if (f.get("type").equals("dir")) {
                BasicDBObject query = new BasicDBObject();
                dir = (String)f.get("dir");
                query.put("dir", (Object)(dir + name + "/"));
                List<GridFSDBFile> subFolders = gfs.find(query);
                for (GridFSDBFile f2 : subFolders) {
                    this.logger.info("subname " + f2.get("name"));
                }
                String newParent = parentFolder + "/" + name + "/";
                f.save();
                f = null;
                folder = null;
                if (subFolders == null || subFolders.size() <= 0) continue;
                idList = this.moveDirTree(resource, newParent, destination + newParent, idList, gfs, subFolders);
                continue;
            }
            String filename = destination + name;
            dir = destination;
            f.put("filename", filename);
            f.put("dir", dir);
            f.put("creationTime", DateUtils.now("dd MM yyyy 'at' hh:mm:ss z"));
            f.put("owner", resource.getOwner());
            idList.add(f.getId().toString());
            this.buildDirTree(gfs, dir);
            f.save();
        }
        return idList;
    }

    private String extractParent(String source) {
        source = source.substring(0, source.length() - 1);
        String parent = source.substring(source.lastIndexOf("/") + 1);
        this.logger.debug("parent folder extracted: " + parent);
        return parent;
    }

    private String appendFileSeparator(String source) {
        if (source.lastIndexOf("/") != source.length() - 1) {
            source = source + "/";
        }
        return source;
    }
}

