/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
    private String[] server;
    private String env;
    private String clientId;
    private String backendType;
    private static HashMap isCache;

    public String[] getServer(String resourceType, String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        logger.trace("get server from IS ");
        if (isCache != null) {
            this.server = (String[])isCache.get("MongoDBServer");
        }
        if (this.server == null) {
            if (resourceType.equalsIgnoreCase("runtimeResource")) {
                this.getServerRRFws();
            } else {
                this.getServerFws();
            }
            if (this.server != null) {
                if (isCache == null) {
                    isCache = new HashMap();
                }
                isCache.put("MongoDBServer", this.server);
                logger.info("ISCACHE: ELEMENT INSERTED ");
            }
        } else {
            logger.info("ISCACHE: ELEMENT EXTRACTED");
        }
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return this.server;
    }

    public String getEnvironment(String secondaryType, String field) {
        return this.env;
    }

    public String getClientId(String secondaryType, String field) {
        return this.clientId;
    }

    @Deprecated
    private String[] parseXmlFile(InputSource body) {
        String[] list = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(body);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("server_list");
            int i = 0;
            list = new String[nodeLst.getLength()];
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("server");
                Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
                String ip = fstNmElmnt.getAttribute("ip");
                String port = fstNmElmnt.getAttribute("port");
                list[i] = ip;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String[] getServerRRFws() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        if (resources.size() > 1) {
            logger.info("found " + resources.size() + " RR ");
            return this.getServers(resources);
        }
        if (resources.size() == 1) {
            logger.info("found only one RR, take it");
            return this.getServers(resources.get(0));
        }
        logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE " + ScopeProvider.instance.get());
        throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: " + ScopeProvider.instance.get());
    }

    private String[] getServers(ServiceEndpoint res) {
        ServiceEndpoint.AccessPoint ap2;
        this.server = new String[res.profile().accessPoints().size()];
        int i = 0;
        for (ServiceEndpoint.AccessPoint ap2 : res.profile().accessPoints()) {
            if (!ap2.name().equals("server" + (i + 1))) continue;
            this.server[i] = ap2.address();
            ++i;
        }
        Iterator it = res.profile().accessPoints().iterator();
        ap2 = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap2.propertyMap();
        ServiceEndpoint.Property type = map.get("type");
        this.backendType = type.value();
        logger.info("Type of backend found " + this.backendType);
        return this.server;
    }

    private String[] getServers(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            logger.info("found a RR with priority: ");
            break;
        }
        if (defaultResource != null) {
            this.server = new String[defaultResource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : defaultResource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                this.server[i] = ap.address();
                ++i;
            }
            this.backendType = this.retrievePropertyValue(defaultResource, "type");
            logger.info("Type of backend found in RR is " + this.backendType);
            return this.server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    @Deprecated
    public void getServerFws() {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq 'MongoDBServer'").setResult("$resource/Profile/Body/server_list");
        DiscoveryClient<ServerList> client = ICFactory.clientFor(ServerList.class);
        List<ServerList> servers = client.submit(query);
        Iterator<ServerList> i$ = servers.iterator();
        if (i$.hasNext()) {
            ServerList gr = i$.next();
            this.server = new String[gr.getEndpoints().size()];
            int i = 0;
            for (Server s : gr.getEndpoints()) {
                this.server[i] = s.ip;
                ++i;
            }
        }
    }

    public String getBackendType(String scope) {
        if (this.backendType != null) {
            return this.backendType;
        }
        this.backendType = this.retrievePropertyValue("type", scope);
        return this.backendType;
    }

    private String retrievePropertyValue(String name, String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient<ServiceEndpoint> client = ICFactory.clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> resources = client.submit(query);
        ServiceEndpoint res = resources.get(0);
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get(name);
        String value = type.value();
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map<String, ServiceEndpoint.Property> map = ap.propertyMap();
        ServiceEndpoint.Property type = map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    @Deprecated
    @XmlRootElement(name="server")
    public static class Server {
        @XmlAttribute(name="ip")
        public String ip;
        @XmlAttribute(name="port")
        public String port;

        public String toString() {
            return "Server [ip=" + this.ip + ", port=" + this.port + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
            result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Server other = (Server)obj;
            if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
                return false;
            }
            return !(this.port == null ? other.port != null : !this.port.equals(other.port));
        }
    }

    @Deprecated
    @XmlRootElement(name="server_list")
    public static class ServerList {
        @XmlElementRef
        private List<Server> servers = new ArrayList<Server>();

        public String toString() {
            return "[servers=" + this.servers + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.servers == null ? 0 : this.servers.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerList other = (ServerList)obj;
            return !(this.servers == null ? other.servers != null : !this.servers.equals(other.servers));
        }

        public List<Server> getEndpoints() {
            return this.servers;
        }

        public void setEndpoints(ArrayList<Server> endpoints) {
            this.servers = endpoints;
        }
    }
}

