/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RawContentLocationSelectionStrategy {
    private static final Log log = LogFactory.getLog(RawContentLocationSelectionStrategy.class);

    public abstract BaseLayerStream retrieveFromPreferredLocation(List<RawContentLocation> var1, BasicStorageHints var2) throws BaseLayerException;

    public RawContentLocation saveAtPreferredLocation(String objectID, BaseLayerStream bls, BasicStorageHints storageHints) throws BaseLayerException {
        RawFileContentManager manager = this.selectManagerForWriting(objectID, storageHints);
        if (BaseLayerUtils.requestsFor("append-content", storageHints) && !manager.supportsAppending()) {
            throw new ValueNotValidException("Data provider does not support appending as requested in hint.", storageHints.getHintValue("append-content"), "append-content");
        }
        long start = System.currentTimeMillis();
        String uniqueStorageLocationID = manager.getUniqueStorageLocationIDFor(objectID);
        RawContentLocation newLocation = manager.saveBinaryContent(uniqueStorageLocationID, bls, storageHints);
        long stop = System.currentTimeMillis();
        long elapsedTime = stop - start;
        log.debug((Object)("Elapsed time for transfer: " + elapsedTime));
        storageHints.addConsumedHint("elapsed-transfer-time", "" + (stop - start));
        return newLocation;
    }

    protected abstract RawFileContentManager selectManagerForWriting(String var1, BasicStorageHints var2);
}

