/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerAuthenticator;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.util.remotefile.protocols.url.http.HTTPCommunicator;

public class HTTPPseudoContentManager
implements RawFileContentManager,
InstantiableManager {
    static final String HTTP_PREFIX = "http://";
    static final String HTTPS_PREFIX = "https://";
    static final String DATA_PROVIDER_PREFIX = "http://";
    final String URL_PREFIX;
    private static final Log log = LogFactory.getLog(HTTPPseudoContentManager.class);

    public static String getDataProviderPrefix() {
        return "http://";
    }

    public HTTPPseudoContentManager(String managedURL) {
        this.URL_PREFIX = managedURL;
    }

    URL getURLFor(String uniqueStorageID) throws ValueNotValidException {
        URL url;
        if (uniqueStorageID == null) {
            throw new ValueNotValidException("Storage location may not be null.", uniqueStorageID, "contentmanagement:location");
        }
        try {
            url = this.URL_PREFIX == null || this.URL_PREFIX.equals("") || uniqueStorageID.startsWith(this.URL_PREFIX) ? new URL(uniqueStorageID) : new URL(this.URL_PREFIX + uniqueStorageID);
        }
        catch (MalformedURLException e) {
            log.error((Object)e);
            throw new ValueNotValidException("Malformed URL as storage location.", uniqueStorageID, "contentmanagement:location");
        }
        return url;
    }

    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        log.warn((Object)"saveBinaryContent is not supported in pseudo content manager");
        throw new UnsupportedOperationException("Cannot delete remote content.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseLayerStream getBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        URL u = this.getURLFor(location.getContentID());
        int length = -1;
        try {
            BufferedInputStream is;
            log.debug((Object)"Getting binary content using Java's URLConnection. Therefore acquiring lock...");
            Authenticator authenticator = BaseLayerAuthenticator.getAnonymousAuthenticator();
            synchronized (authenticator) {
                log.debug((Object)"Got lock, now download content.");
                Authenticator.setDefault(BaseLayerAuthenticator.getAuthenticatorFor(hints));
                URLConnection conn = u.openConnection();
                length = conn.getContentLength();
                String mimeType = hints.getHintValue("content-mime-type");
                if (mimeType == null) {
                    mimeType = conn.getContentType();
                    log.debug((Object)("Connection MIME-Type is set to " + mimeType));
                }
                File f = File.createTempFile("downloader", "downloader", null);
                f.deleteOnExit();
                HTTPCommunicator.retrieve(u, f);
                is = new BufferedInputStream(new FileInputStream(f));
                if (BaseLayerUtils.requestsFor("guess-content-mime-type", hints)) {
                    String guessedMimeType = URLConnection.guessContentTypeFromStream(is);
                    log.debug((Object)("Guessed MIME-Type is set to " + guessedMimeType));
                    BaseLayerUtils.consumeHint("guess-content-mime-type", hints);
                    if (guessedMimeType != null) {
                        mimeType = guessedMimeType;
                    }
                }
                if (mimeType != null && !"content/unknown".equals(mimeType)) {
                    hints.addHint("content-mime-type", mimeType);
                    log.debug((Object)("MIME-Type has been set to " + mimeType));
                }
                Authenticator.setDefault(BaseLayerAuthenticator.getAnonymousAuthenticator());
            }
            log.debug((Object)"Unlocked. Returning stream for content...");
            if (length == -1) {
                return new BaseLayerStream(is);
            }
            return new BaseLayerStream(is, length);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new BaseLayerException("Error in data access.", ioe);
        }
    }

    public boolean deleteBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        log.warn((Object)"deleteBinaryContent is not supported in pseudo content manager");
        throw new UnsupportedOperationException("Cannot delete remote content.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsBinaryContent(RawContentLocation location, BasicStorageHints hints) throws BaseLayerException {
        BaseLayerStream bls;
        try {
            bls = this.getBinaryContent(location, hints);
        }
        catch (BaseLayerException ble) {
            if (ble.getCause() instanceof FileNotFoundException) {
                return false;
            }
            log.error((Object)ble);
            throw ble;
        }
        try {
            bls.getStream().read();
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            bls.dispose();
        }
        return true;
    }

    public boolean handles(String dataprovider) {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return dataprovider.startsWith("http://") || dataprovider.startsWith(HTTPS_PREFIX);
        }
        if (!dataprovider.startsWith(HTTPPseudoContentManager.getDataProviderPrefix())) {
            return false;
        }
        if (dataprovider.startsWith(this.getDataProvider())) {
            return true;
        }
        String newProvider = HTTPPseudoContentManager.getDataProviderPrefix() + BaseLayerUtils.removeProtocolUsernamePasswordFromURL(dataprovider);
        return newProvider.startsWith(this.getDataProvider());
    }

    public String getDataProvider() {
        if (this.URL_PREFIX == null || this.URL_PREFIX == "") {
            return "http://";
        }
        return this.URL_PREFIX;
    }

    public boolean supportsAppending() {
        return false;
    }

    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        StringBuffer newURL = new StringBuffer(HTTPPseudoContentManager.getDataProviderPrefix());
        if (hints.hasHint("user")) {
            newURL.append(hints.getHintValue("user"));
            if (hints.hasHint("passwd")) {
                newURL.append(':');
                newURL.append(hints.getHintValue("passwd"));
            }
            newURL.append('@');
        }
        newURL.append(BaseLayerUtils.removeProtocolUsernamePasswordFromURL(currentLocation.getContentID()));
        return new RawContentLocation(this.getDataProvider(), newURL.toString());
    }

    public static HTTPPseudoContentManager getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (params.length > 0) {
            return new HTTPPseudoContentManager(params[0]);
        }
        return new HTTPPseudoContentManager("");
    }

    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }
}

