/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.inMessageImpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.RawContentLocation;

public class InMemoryRawContentLocation
extends RawContentLocation {
    private static final Log log = LogFactory.getLog(InMemoryRawContentLocation.class);
    private byte[] content;

    public InMemoryRawContentLocation(String contentid, String dataprovider, byte[] content) {
        super.setContentID(contentid);
        super.setDataprovider(dataprovider);
        if (content == null) {
            log.warn((Object)("In memory location " + contentid + " has content NULL."));
        }
        this.setContent(content);
    }

    public void setContent(byte[] content) {
        this.content = content;
        if (content != null) {
            super.setSize(content.length);
        } else {
            super.setSize(Long.MIN_VALUE);
        }
    }

    public byte[] getContent() {
        return this.content;
    }
}

