/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.networkFileTransfer.gfal;

import it.infn.catania.gfal.GFalFile;
import it.infn.catania.gfal.GFalFileException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;

public class BufferedGFALInputStream
extends InputStream {
    private static final Log log = LogFactory.getLog(BufferedGFALInputStream.class);
    public static final int BEHIND_END_OF_FILE = -2;
    protected static final GFalFileException NO_MARK_SET = new GFalFileException("No mark set.");
    private GFalFile inputFile;
    private int bufferSize;
    private byte[] buffer;
    private int bufferPos = 0;
    private long markedPos = -2L;
    private GFalFileException markingError = NO_MARK_SET;
    private boolean largeFile = true;

    public BufferedGFALInputStream(GFalFile inputFile, BasicStorageHints hints) throws ValueNotValidException, IOException {
        this.inputFile = inputFile;
        if (hints.hasHint("is-large-file")) {
            this.largeFile = BaseLayerUtils.requestsFor("is-large-file", hints);
            hints.markHint("is-large-file", true);
        }
        this.bufferSize = hints.hasHint("preferred-buffer-size") ? BaseLayerUtils.convertHintToInteger(hints.consumeHint("preferred-buffer-size", false), "preferred-buffer-size") : BaseLayerStream.getDefaultBufferSize();
        this.prepareBufferForRead();
    }

    private int fillBuffer(boolean logUnreadBytes) throws IOException {
        if (logUnreadBytes && log.isWarnEnabled() && this.buffer != null && this.available() > 0) {
            log.warn((Object)("Buffer contains " + this.available() + " unread bytes, that will be overwritten."));
        }
        try {
            this.buffer = this.inputFile.readFile(this.bufferSize);
        }
        catch (GFalFileException e) {
            log.error((Object)e);
            throw new IOException(e.getMessage());
        }
        this.bufferPos = 0;
        return this.buffer.length;
    }

    public int read() throws IOException {
        int available = this.prepareBufferForRead();
        if (available < 1) {
            return -1;
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    private int prepareBufferForRead() throws EOFException, IOException {
        if (this.inputFile == null) {
            throw new IOException("Input file has been closed or is unavailable for other reasons.");
        }
        if (this.buffer == null) {
            return this.fillBuffer(false);
        }
        if (this.bufferPos == -2) {
            throw new EOFException("Passed end of file already.");
        }
        if (this.bufferPos == this.buffer.length) {
            return this.fillBuffer(true);
        }
        return this.buffer.length - this.bufferPos;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
        super.close();
        try {
            this.inputFile.closeFile();
            this.inputFile = null;
        }
        catch (GFalFileException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int available = this.prepareBufferForRead();
        if (available < 1) {
            return -1;
        }
        int copiedBytes = Math.min(len, available);
        System.arraycopy(this.buffer, this.bufferPos, b, off, copiedBytes);
        this.bufferPos += copiedBytes;
        return copiedBytes;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        try {
            long oldpos = this.getCurrentPosition();
            long newpos = this.inputFile.lseekFile(n, 1, true);
            this.fillBuffer(false);
            return newpos - oldpos;
        }
        catch (GFalFileException e) {
            throw new IOException(e.getMessage());
        }
    }

    private long getCurrentPosition() throws GFalFileException {
        return this.inputFile.lseekFile(0L, 1, this.largeFile);
    }

    public int available() {
        assert (this.buffer != null) : "Buffer has not been initialized by calling fillBuffer.";
        if (this.bufferPos == -2) {
            return 0;
        }
        return this.buffer.length - this.bufferPos;
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markedPos = this.getCurrentPosition();
        }
        catch (GFalFileException e) {
            log.warn((Object)("Could not identify current position: " + e.getMessage() + " - this means, that reset will not work properly!"));
            log.debug((Object)e);
            this.markedPos = -2L;
            this.markingError = e;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        if (this.markedPos == -2L) {
            throw new IOException("Could not reset position. Reason was when marking position: " + this.markingError.getMessage());
        }
        try {
            this.inputFile.lseekFile(this.markedPos, 0, this.largeFile);
            this.fillBuffer(false);
        }
        catch (GFalFileException e) {
            throw new IOException("Could not reset position. Reason: " + e.getMessage());
        }
    }

    public synchronized long determineStreamLength() {
        try {
            this.mark(Integer.MAX_VALUE);
            long size = this.inputFile.lseekFile(0L, 2, this.largeFile);
            this.reset();
            return size;
        }
        catch (Exception e) {
            log.debug((Object)"Could not determine file size.", (Throwable)e);
            return Long.MIN_VALUE;
        }
    }

    public boolean isLargeFile() {
        return this.largeFile;
    }

    public void setLargeFile(boolean isLargeFile) {
        this.largeFile = isLargeFile;
    }
}

