/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.baselayer.rdbmsImpl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.contentmanagement.baselayer.BaseLayerStream;
import org.gcube.contentmanagement.baselayer.BaseLayerUtils;
import org.gcube.contentmanagement.baselayer.InstantiableManager;
import org.gcube.contentmanagement.baselayer.RawContentLocation;
import org.gcube.contentmanagement.baselayer.RawFileContentManager;
import org.gcube.contentmanagement.baselayer.RelationshipAndPropertyManager;
import org.gcube.contentmanagement.baselayer.exceptions.BaseLayerException;
import org.gcube.contentmanagement.baselayer.exceptions.DuplicateIDException;
import org.gcube.contentmanagement.baselayer.exceptions.ObjectNotFoundException;
import org.gcube.contentmanagement.baselayer.exceptions.TemporaryUnavailableException;
import org.gcube.contentmanagement.baselayer.exceptions.ValueNotValidException;
import org.gcube.contentmanagement.baselayer.rdbmsImpl.BlobStream;
import org.gcube.contentmanagement.baselayer.rdbmsImpl.SubstringStream;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicInfoObjectDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicStorageHints;
import org.gcube.contentmanagement.storagelayer.StorageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJDBCDatabase
implements RawFileContentManager,
RelationshipAndPropertyManager,
InstantiableManager {
    BasicDataSource bds;
    String dataSourceName;
    Map<Integer, String> typeMappingTable;
    boolean trustDatabaseMetadata = true;
    long maxBlobStreamLength = Integer.MAX_VALUE;
    int retriesToConnectOnStartup = 3;
    Map<Integer, String> userDefinedTypeMapping;
    Map<String, String> defaultPrecisionMapping;
    static final int UUID_LENGTH = 36;
    static final int LONGER_ID_LENGTH = 255;
    String uuidType;
    String longerIDType;
    static final Pattern[] PROHIBITED_NAME_PATTERN = new Pattern[]{Pattern.compile("^|[\\\\/]\\.\\.[\\\\/]")};
    private static final Log log = LogFactory.getLog(GenericJDBCDatabase.class);
    static final String SCHEMA_VERSIONS_TABLE = "Schema_Versions";
    static final String SCHEMA_VERSION_TABLE_COLUMN = "Table_Name";
    static final String SCHEMA_VERSION_VERSION_COLUMN = "Schema_Version";
    static final String SCHEMA_VERSION_DATE_COLUMN = "Version_Date";
    static final int SCHEMA_VERSIONS_TABLE_VERSION = 1;
    static final int SCHEMA_NOT_VERSIONED = 0;
    static final String RAW_CONTENT_TABLE = "Raw_Object_Content";
    static final int RAW_CONTENT_TABLE_VERSION = 1;
    static final String RAW_CONTENT_ID_COLUMN = "Raw_Object_ID";
    static final String RAW_CONTENT_COLUMN = "Raw_Content";
    static final String SEQUENCE_TABLE = "Generic_JDBC_Sequence";
    static final String SEQUENCE_KEY_COLUMN = "Sequence_Name";
    static final String SEQUENCE_VALUE_COLUMN = "Sequence_Value";
    static final String INFO_OBJECT_TABLE = "Info_Object";
    static final int INFO_OBJECT_TABLE_VERSION = 1;
    static final String INFO_OBJECT_ID_COLUMN = "Info_Object_ID";
    static final String PROPERTY_TABLE = "Storage_Property";
    static final int PROPERTY_TABLE_VERSION = 1;
    static final String PROPERTY_OID_COLUMN = "Property_Object_ID";
    static final String PROPERTY_NAME_COLUMN = "Property_Name";
    static final String PROPERTY_TYPE_COLUMN = "Property_Type";
    static final String PROPERTY_VALUE_COLUMN = "Property_Value";
    static final String REFERENCE_TABLE = "Object_Reference";
    static final int REFERENCE_TABLE_VERSION = 2;
    static final String REFERENCE_SOURCE_ID_COLUMN = "Reference_Source";
    static final String REFERENCE_TARGET_ID_COLUMN = "Reference_Target";
    static final String REFERENCE_ROLE_COLUMN = "Reference_Role";
    static final String REFERENCE_SECONDARY_ROLE_COLUMN = "Reference_Secondary_Role";
    static final String REFERENCE_POSITION_COLUMN = "Reference_Position";
    static final String REFERENCE_PROPAGATION_COLUMN = "Reference_Propagation";
    static final String OBJECT_CONTENT_LINK_TABLE = "Link_Table";
    static final int OBJECT_CONTENT_LINK_TABLE_VERSION = 1;
    static final String OC_OBJECT_ID_COLUMN = "Object_ID";
    static final String OC_CONTENT_ID_COLUMN = "Content_ID";
    static final String OC_DATAPROVIDER_COLUMN = "Data_Provider";
    static final String UNLINKED_RAW_CONTENT = null;
    static final BasicReferenceDescription[] NO_REFERENCES = new BasicReferenceDescription[0];
    static final BasicPropertyDescription[] NO_PROPERTIES = new BasicPropertyDescription[0];
    static final Map<String, BasicPropertyDescription> EMPTY_PROPERTY_MAP = Collections.emptyMap();
    static final List<BasicReferenceDescription> EMPTY_REFERENCE_COLLECTION = Collections.emptyList();
    boolean performAdditionalChecks = true;
    String dataProvider;
    GenericConnectionAliveTester connectionTester = new GenericConnectionAliveTester();
    boolean useSubstringForReadingBLOBs = false;

    public GenericJDBCDatabase(String dataSourceName, String driverClassName, String driverURL, String maxParallelConnections) throws BaseLayerException {
        this(dataSourceName, driverClassName, driverURL);
        try {
            int max = new Integer(maxParallelConnections);
            this.bds.setMaxActive(max);
            this.bds.setMaxIdle(20);
            this.bds.setMaxWait(10000L);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"Error getting max parallel connections", (Throwable)nfe);
            log.debug((Object)"Using default number of pooled connections.");
        }
    }

    public GenericJDBCDatabase(String dataSourceName, String driverClassName, String sourceURL) throws BaseLayerException {
        log.debug((Object)("Setting up database connection to datasource '" + dataSourceName + "'..."));
        log.debug((Object)("The url of the datasource is:" + sourceURL));
        if (sourceURL.startsWith("jdbc:derby")) {
            sourceURL = "jdbc:derby:" + GHNContext.getContext().getStorageRoot() + "/gcoredb/storage_db;create=true";
        }
        this.bds = new BasicDataSource();
        this.bds.setDriverClassName(driverClassName);
        this.bds.setUrl(sourceURL);
        this.bds.setDefaultAutoCommit(false);
        this.dataSourceName = dataSourceName;
        this.defaultPrecisionMapping = new HashMap<String, String>();
        this.userDefinedTypeMapping = new HashMap<Integer, String>();
        Connection c = null;
        TemporaryUnavailableException lastException = null;
        int tries = 0;
        while (c == null) {
            ++tries;
            try {
                c = this.getConnection();
            }
            catch (TemporaryUnavailableException e) {
                log.error((Object)("Connection failed:  " + tries + " time(s)."));
                log.debug((Object)e);
                lastException = e;
            }
            if (tries < this.retriesToConnectOnStartup) continue;
            log.fatal((Object)("Failed " + this.retriesToConnectOnStartup + " time(s) to connect to database - giving up."), (Throwable)lastException);
            throw new BaseLayerException("Could not establish database connection.", lastException);
        }
        try {
            c.setReadOnly(true);
        }
        catch (SQLException e) {
            log.warn((Object)"Could not set READ-ONLY for transaction.");
            log.debug((Object)e);
        }
        DATABASE_PRODUCT product = DATABASE_PRODUCT.UNKNOWN;
        try {
            DatabaseMetaData meta = c.getMetaData();
            String dbProduct = meta.getDatabaseProductName();
            String dbVersion = meta.getDatabaseProductVersion();
            product = this.adjustParametersFor(dbProduct, dbVersion, c);
            c.close();
        }
        catch (SQLException sqle) {
            log.warn((Object)("Could not retrieve database metadata correctly. Reason:" + sqle.getMessage()));
            log.debug((Object)sqle);
        }
        this.initializeDatabase(product);
        this.dataProvider = "jdbc:" + dataSourceName;
        log.debug((Object)"Database connection ready for use.");
    }

    private DATABASE_PRODUCT adjustParametersFor(String dbProduct, String dbVersion, Connection c) throws BaseLayerException {
        log.info((Object)("Making adjustments for: " + dbProduct + " Version " + dbVersion));
        this.defaultPrecisionMapping.put("VARCHAR", "36");
        this.initializeNativeTypeMapping(c);
        this.uuidType = this.getNativeType(12);
        this.defaultPrecisionMapping.put("VARCHAR", "255");
        this.initializeNativeTypeMapping(c);
        this.longerIDType = this.getNativeType(12);
        this.defaultPrecisionMapping.put("VARCHAR", "32000");
        this.initializeNativeTypeMapping(c);
        DATABASE_PRODUCT product = DATABASE_PRODUCT.UNKNOWN;
        if (dbProduct.equalsIgnoreCase("MySQL")) {
            product = DATABASE_PRODUCT.MYSQL;
            this.userDefinedTypeMapping.put(new Integer(2004), "LONGBLOB");
            this.userDefinedTypeMapping.put(new Integer(12), "TEXT");
            this.uuidType = "VARCHAR(36)";
            this.longerIDType = "VARCHAR(255)";
            String[] testStatements = new String[]{"SELECT 1"};
            this.connectionTester = new GenericConnectionAliveTester(testStatements);
            this.useSubstringForReadingBLOBs = true;
        }
        if (dbProduct.equalsIgnoreCase("PostgreSQL")) {
            product = DATABASE_PRODUCT.POSTGRESQL;
            this.trustDatabaseMetadata = false;
            if (dbVersion.startsWith("7.")) {
                this.maxBlobStreamLength = -1L;
            }
            this.userDefinedTypeMapping.put(new Integer(12), "TEXT");
            this.userDefinedTypeMapping.put(new Integer(2004), "BYTEA");
            this.uuidType = "TEXT";
            this.longerIDType = "TEXT";
        }
        if (dbProduct.equalsIgnoreCase("Apache Derby") || dbProduct.equalsIgnoreCase("Cloudscape")) {
            product = dbProduct.equalsIgnoreCase("Apache Derby") ? DATABASE_PRODUCT.DERBY : DATABASE_PRODUCT.CLOUDSCAPE;
            this.trustDatabaseMetadata = false;
            this.userDefinedTypeMapping.put(new Integer(2004), "BLOB(2G)");
        }
        this.initializeNativeTypeMapping(c);
        log.debug(this.typeMappingTable);
        log.debug((Object)("uuidType is " + this.uuidType));
        log.debug((Object)("longerIDType is " + this.longerIDType));
        log.debug((Object)("Product: " + (Object)((Object)product)));
        return product;
    }

    private void initializeDatabase(DATABASE_PRODUCT product) throws BaseLayerException {
        String sqlStringCreateIndex;
        String sqlStringCreateTable;
        log.info((Object)"Initializing / updating database schema...");
        boolean everythingFine = true;
        Connection c = this.getConnection();
        try {
            c.setTransactionIsolation(8);
            c.setAutoCommit(false);
        }
        catch (SQLException sqle) {
            everythingFine = false;
            log.warn((Object)"Could not set isolation level to SERIALIZABLE and/or AUTOCOMMIT to false, update of database might cause inconsistency!");
            log.debug((Object)sqle);
        }
        if (!this.doesTableExist(SCHEMA_VERSIONS_TABLE, c)) {
            log.info((Object)"Creating table 'Schema_Versions'.");
            try {
                sqlStringCreateTable = "CREATE TABLE Schema_Versions (Table_Name " + this.longerIDType + " PRIMARY KEY NOT NULL," + SCHEMA_VERSION_VERSION_COLUMN + " " + this.getNativeType(4) + "," + SCHEMA_VERSION_DATE_COLUMN + " " + this.getNativeType(91) + ")";
                log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                c.createStatement().execute(sqlStringCreateTable);
                c.commit();
                this.setSchemaVersion(SCHEMA_VERSIONS_TABLE, 1, c);
                c.commit();
            }
            catch (SQLException sqle) {
                everythingFine = false;
                sqle.printStackTrace();
                log.debug((Object)sqle.getSQLState());
                log.debug((Object)sqle);
                this.releaseConnection(c);
                throw new BaseLayerException("Unexpected problem while accessing database.", sqle);
            }
            if (this.performAdditionalChecks && !this.doesTableExist(SCHEMA_VERSIONS_TABLE, c)) {
                everythingFine = false;
                log.warn((Object)"Could not create database table Schema_Versions");
            }
        }
        if (!this.doesTableExist(RAW_CONTENT_TABLE, c)) {
            log.info((Object)"Creating table 'Raw_Object_Content'.");
            if (this.getNativeType(2004) == null) {
                everythingFine = false;
                log.warn((Object)"Could not create table 'Raw_Object_Content' because the database does not support BLOB fields.");
            } else {
                try {
                    sqlStringCreateTable = "CREATE TABLE Raw_Object_Content (Raw_Object_ID " + this.longerIDType + " PRIMARY KEY NOT NULL, " + RAW_CONTENT_COLUMN + " " + this.getNativeType(2004) + " NOT NULL)";
                    log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                    c.createStatement().execute(sqlStringCreateTable);
                    c.commit();
                    this.setSchemaVersion(RAW_CONTENT_TABLE, 1, c);
                    c.commit();
                }
                catch (SQLException sqle) {
                    everythingFine = false;
                    log.debug((Object)sqle);
                    this.releaseConnection(c);
                    throw new BaseLayerException("Could not create database table Raw_Object_Content", sqle);
                }
                if (this.performAdditionalChecks && !this.doesTableExist(RAW_CONTENT_TABLE, c)) {
                    everythingFine = false;
                    log.warn((Object)"Could not create database table Raw_Object_Content");
                }
            }
        }
        if (!this.doesTableExist(INFO_OBJECT_TABLE, c)) {
            log.info((Object)"Creating table 'Info_Object'.");
            try {
                sqlStringCreateTable = "CREATE TABLE Info_Object (Info_Object_ID " + this.uuidType + " PRIMARY KEY NOT NULL)";
                log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                c.createStatement().execute(sqlStringCreateTable);
                c.commit();
                this.setSchemaVersion(INFO_OBJECT_TABLE, 1, c);
                c.commit();
            }
            catch (SQLException sqle) {
                everythingFine = false;
                log.debug((Object)sqle);
                this.releaseConnection(c);
                throw new BaseLayerException("Unexpected problem while accessing database.", sqle);
            }
            if (this.performAdditionalChecks && !this.doesTableExist(INFO_OBJECT_TABLE, c)) {
                everythingFine = false;
                log.warn((Object)"Could not create database table Info_Object");
            }
        }
        if (!this.doesTableExist(PROPERTY_TABLE, c)) {
            log.info((Object)"Creating table 'Storage_Property'.");
            try {
                sqlStringCreateTable = "CREATE TABLE Storage_Property (Property_Object_ID " + this.uuidType + " NOT NULL REFERENCES " + INFO_OBJECT_TABLE + "(" + INFO_OBJECT_ID_COLUMN + ") ON DELETE CASCADE, " + PROPERTY_NAME_COLUMN + " " + this.longerIDType + " NOT NULL, " + PROPERTY_TYPE_COLUMN + " " + this.longerIDType + ", " + PROPERTY_VALUE_COLUMN + " " + this.getNativeType(12) + ", " + " PRIMARY KEY (" + PROPERTY_OID_COLUMN + ", " + PROPERTY_NAME_COLUMN + "))";
                log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                c.createStatement().execute(sqlStringCreateTable);
                c.commit();
                this.setSchemaVersion(PROPERTY_TABLE, 1, c);
                c.commit();
            }
            catch (SQLException sqle) {
                everythingFine = false;
                log.debug((Object)sqle);
                this.releaseConnection(c);
                throw new BaseLayerException("Unexpected problem while creating table.", sqle);
            }
            if (product == DATABASE_PRODUCT.MYSQL) {
                String varCharType = this.getNativeType(12);
                if (varCharType != null && (varCharType.equalsIgnoreCase("TEXT") || varCharType.equalsIgnoreCase("LONGTEXT") || varCharType.equalsIgnoreCase("MEDIUMTEXT") || varCharType.equalsIgnoreCase("TINYTEXT"))) {
                    try {
                        String mysqlStringCreateIndex = "CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value(255))";
                        log.debug((Object)"  Statement is: CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value(255))");
                        c.createStatement().execute("CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value(255))");
                        c.commit();
                        log.info((Object)"Success!");
                    }
                    catch (SQLException sqle) {
                        everythingFine = false;
                        log.warn((Object)("Property values will not be indexed due to problem with database! Probably somebody can fix that manually for datasource " + this.dataSourceName));
                        log.debug((Object)sqle);
                    }
                }
            } else if (product == DATABASE_PRODUCT.POSTGRESQL) {
                try {
                    String postgresqlStringCreateIndex1 = "CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property USING hash (Property_Value)";
                    log.debug((Object)"  Statement is: CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property USING hash (Property_Value)");
                    c.createStatement().execute("CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property USING hash (Property_Value)");
                    c.commit();
                    String postgresqlStringCreateIndex2 = "CREATE INDEX IDX_Storage_Property_Property_Name ON Storage_Property USING hash (Property_Name)";
                    log.debug((Object)"  Statement is: CREATE INDEX IDX_Storage_Property_Property_Name ON Storage_Property USING hash (Property_Name)");
                    c.createStatement().execute("CREATE INDEX IDX_Storage_Property_Property_Name ON Storage_Property USING hash (Property_Name)");
                    c.commit();
                    log.info((Object)"Success!");
                }
                catch (SQLException sqle) {
                    everythingFine = false;
                    log.warn((Object)("Property values will not be indexed due to problem with database! Probably somebody can fix that manually for datasource " + this.dataSourceName));
                    log.debug((Object)sqle);
                }
            } else {
                try {
                    sqlStringCreateIndex = "CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value)";
                    log.debug((Object)"  Statement is: CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value)");
                    c.createStatement().execute("CREATE INDEX IDX_Storage_Property_Property_Value ON Storage_Property(Property_Value)");
                    c.commit();
                }
                catch (SQLException sqle) {
                    log.debug((Object)sqle);
                    everythingFine = false;
                    log.error((Object)("Could not create index. Reason: " + sqle.getMessage()));
                    log.warn((Object)("This may degrade performance when retrieving objects by property value. Probably somebody can create suitable index for datasource " + this.dataSourceName + " manually."));
                }
                if (this.performAdditionalChecks && !this.doesTableExist(PROPERTY_TABLE, c)) {
                    everythingFine = false;
                    log.warn((Object)"Could not create database table Storage_Property");
                }
            }
        }
        if (!this.doesTableExist(REFERENCE_TABLE, c)) {
            log.info((Object)"Creating table 'Object_Reference'.");
            try {
                sqlStringCreateTable = "CREATE TABLE Object_Reference (Reference_Source " + this.uuidType + " NOT NULL REFERENCES " + INFO_OBJECT_TABLE + "(" + INFO_OBJECT_ID_COLUMN + ") ON DELETE NO ACTION, " + REFERENCE_TARGET_ID_COLUMN + " " + this.uuidType + " NOT NULL REFERENCES " + INFO_OBJECT_TABLE + "(" + INFO_OBJECT_ID_COLUMN + ") ON DELETE NO ACTION, " + REFERENCE_ROLE_COLUMN + " " + this.longerIDType + " NOT NULL, " + REFERENCE_SECONDARY_ROLE_COLUMN + " " + this.longerIDType + "," + REFERENCE_POSITION_COLUMN + " " + this.getNativeType(4) + ", " + REFERENCE_PROPAGATION_COLUMN + " " + this.longerIDType + ", " + " PRIMARY KEY (" + REFERENCE_SOURCE_ID_COLUMN + ", " + REFERENCE_TARGET_ID_COLUMN + "))";
                log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                c.createStatement().execute(sqlStringCreateTable);
                c.commit();
                this.setSchemaVersion(REFERENCE_TABLE, 1, c);
                c.commit();
            }
            catch (SQLException sqle) {
                everythingFine = false;
                log.debug((Object)sqle);
                this.releaseConnection(c);
                throw new BaseLayerException("Unexpected problem while creating table.", sqle);
            }
            try {
                String sqlStringCreateIndex1 = "CREATE INDEX IDX_Object_Reference_Reference_Source ON Object_Reference(Reference_Source)";
                log.debug((Object)"  Statement is: CREATE INDEX IDX_Object_Reference_Reference_Source ON Object_Reference(Reference_Source)");
                c.createStatement().execute("CREATE INDEX IDX_Object_Reference_Reference_Source ON Object_Reference(Reference_Source)");
                String sqlStringCreateIndex2 = "CREATE INDEX IDX_Object_Reference_Reference_Target ON Object_Reference(Reference_Target)";
                log.debug((Object)"  Statement is: CREATE INDEX IDX_Object_Reference_Reference_Target ON Object_Reference(Reference_Target)");
                c.createStatement().execute("CREATE INDEX IDX_Object_Reference_Reference_Target ON Object_Reference(Reference_Target)");
                c.commit();
            }
            catch (SQLException sqle) {
                everythingFine = false;
                log.debug((Object)sqle);
                log.error((Object)("Could not create indexes. Reason: " + sqle.getMessage()));
            }
            if (this.performAdditionalChecks && !this.doesTableExist(REFERENCE_TABLE, c)) {
                everythingFine = false;
                log.warn((Object)"Could not create database table Object_Reference");
            }
        }
        if (!this.doesTableExist(OBJECT_CONTENT_LINK_TABLE, c)) {
            log.info((Object)"Creating table 'Link_Table'.");
            try {
                sqlStringCreateTable = "CREATE TABLE Link_Table (Object_ID " + this.uuidType + " REFERENCES " + INFO_OBJECT_TABLE + "(" + INFO_OBJECT_ID_COLUMN + ") ON DELETE SET NULL, " + OC_CONTENT_ID_COLUMN + " " + this.longerIDType + " NOT NULL, " + OC_DATAPROVIDER_COLUMN + " " + this.longerIDType + " NOT NULL, " + " PRIMARY KEY (" + OC_CONTENT_ID_COLUMN + ", " + OC_DATAPROVIDER_COLUMN + "))";
                log.debug((Object)("  Statement is: " + sqlStringCreateTable));
                c.createStatement().execute(sqlStringCreateTable);
                c.commit();
                this.setSchemaVersion(OBJECT_CONTENT_LINK_TABLE, 1, c);
                c.commit();
            }
            catch (SQLException sqle) {
                throw new BaseLayerException("Unexpected problem while creating table.", sqle);
            }
            try {
                sqlStringCreateIndex = "CREATE INDEX IDX_Link_Table_Content_ID ON Link_Table(Content_ID)";
                log.debug((Object)"  Statement is: CREATE INDEX IDX_Link_Table_Content_ID ON Link_Table(Content_ID)");
                c.createStatement().execute("CREATE INDEX IDX_Link_Table_Content_ID ON Link_Table(Content_ID)");
                String sqlStringCreateIndex1 = "CREATE INDEX IDX_Link_Table_Object_ID ON Link_Table(Object_ID)";
                log.debug((Object)"  Statement is: CREATE INDEX IDX_Link_Table_Object_ID ON Link_Table(Object_ID)");
                c.createStatement().execute("CREATE INDEX IDX_Link_Table_Object_ID ON Link_Table(Object_ID)");
                c.commit();
            }
            catch (SQLException sqle) {
                log.error((Object)("Could not create index. Reason: " + sqle.getMessage()));
            }
            if (this.performAdditionalChecks && !this.doesTableExist(OBJECT_CONTENT_LINK_TABLE, c)) {
                log.warn((Object)"Could not create database table Link_Table");
            }
        }
        if (everythingFine) {
            log.info((Object)"Database schema is up-to-date.");
        } else {
            log.warn((Object)"ATTENTION: Encountered problems in initializing / updating database schema. Please read log carefully for warnings and errors.");
        }
        try {
            c.close();
        }
        catch (SQLException sqle) {
            throw new BaseLayerException("Unexpected problem while closing database connection.", sqle);
        }
    }

    private int getSchemaVersion(String tableName, Connection c) throws BaseLayerException {
        try {
            int version;
            PreparedStatement ps = c.prepareStatement("SELECT Schema_Version FROM Schema_Versions WHERE Table_Name = ?");
            ps.setString(1, tableName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                version = rs.getInt(1);
            } else if (this.doesTableExist(tableName, c)) {
                version = 0;
            } else {
                throw new ObjectNotFoundException("Table does not exist.", tableName);
            }
            rs.close();
            ps.close();
            return version;
        }
        catch (SQLException sqle) {
            throw new BaseLayerException("Unexpected problem checking database schema version.", sqle);
        }
    }

    private boolean setSchemaVersion(String tableName, int version, Connection c) throws SQLException, BaseLayerException {
        PreparedStatement ps;
        int previousVersion;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting schema of table " + tableName + " to version " + version));
        }
        if ((previousVersion = this.getSchemaVersion(tableName, c)) == version) {
            return false;
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (previousVersion == 0) {
            ps = c.prepareStatement("INSERT INTO Schema_Versions (Table_Name, Schema_Version, Version_Date) VALUES (?,?,?)");
            ps.setString(1, tableName);
            ps.setInt(2, version);
            ps.setDate(3, currentDate);
        } else {
            ps = c.prepareStatement("UPDATE Schema_Versions SET Schema_Version = ? , Version_Date = ?  WHERE Table_Name = ?");
            ps.setInt(1, version);
            ps.setDate(2, currentDate);
            ps.setString(3, tableName);
        }
        int count = ps.executeUpdate();
        ps.close();
        return count == 1;
    }

    private String getUniqueIdentifier() {
        return BaseLayerUtils.getNewUUID();
    }

    public Connection getConnection() throws TemporaryUnavailableException {
        log.debug((Object)"Requested connection.");
        Connection c = null;
        boolean poolable = true;
        if (poolable) {
            try {
                log.trace((Object)"Using pooled connection");
                if (c == null) {
                    c = this.bds.getConnection();
                }
                while (!this.connectionTester.isAlive(c)) {
                    log.debug((Object)("Received closed or othervise unusable connection: " + this.connectionTester.isAlive(c)));
                    GenericJDBCDatabase.closeDatabaseConnectionEntirelyAndQuietly(c);
                    c = this.bds.getConnection();
                }
                c.getTransactionIsolation();
            }
            catch (SQLException sqle) {
                throw new TemporaryUnavailableException("Could not establish connection with database.", sqle);
            }
        }
        try {
            log.trace((Object)"Using non-pooled connection");
            Class.forName(this.bds.getDriverClassName());
            c = DriverManager.getConnection(this.bds.getUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.performAdditionalChecks) {
            try {
                log.debug((Object)"Setting autocommit and readonly to false.");
                if (c.getAutoCommit()) {
                    c.setAutoCommit(false);
                }
                if (c.isReadOnly()) {
                    c.setReadOnly(false);
                }
            }
            catch (SQLException sqle) {
                log.warn((Object)("Could not set auto-commit and read-only to false. Reason: " + sqle.getMessage()));
                log.debug((Object)sqle);
                log.warn((Object)"Trying to get a better connection.");
                GenericJDBCDatabase.closeDatabaseConnectionEntirelyAndQuietly(c);
                return this.getConnection();
            }
        }
        log.debug((Object)"Connection is ready to use.");
        return c;
    }

    static void closeDatabaseConnectionEntirelyAndQuietly(Connection c) {
        if (c instanceof PoolableConnection) {
            try {
                ((PoolableConnection)c).reallyClose();
            }
            catch (SQLException sqle) {
                log.debug((Object)"Error while closing, but didn't want to use this connection anymore, so that should be no big deal.", (Throwable)sqle);
            }
        } else {
            try {
                c.close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"Error while closing, but didn't want to use this connection anymore, so that should be no big deal.", (Throwable)sqle);
            }
        }
        c = null;
    }

    public void releaseConnection(Connection connection) {
        block5: {
            log.debug((Object)"Connection released.");
            try {
                if (connection.isClosed()) break block5;
                try {
                    if (!connection.getAutoCommit()) {
                        log.warn((Object)"Possibly uncommited changes when closing connection.");
                        connection.rollback();
                    }
                }
                catch (SQLException sqle) {
                    log.error((Object)"Problems when resolving uncommitted changes when releasing connection!");
                }
                log.debug((Object)"Closing connection.");
                connection.close();
            }
            catch (SQLException sqle) {
                log.error((Object)("Problems closing the database connection. Reason: " + sqle.getMessage()));
            }
        }
        log.debug((Object)"Done releasing connection.");
    }

    @Override
    public RawContentLocation saveBinaryContent(String uniqueStorageID, BaseLayerStream binaryFileContent, BasicStorageHints hints) throws BaseLayerException {
        log.debug((Object)("Saving binary content to RDBMS for ID " + uniqueStorageID + " using hints " + hints));
        if (BaseLayerUtils.requestsFor("create-new-file-when-file-exists", hints) && !hints.isConsumedHint("create-new-file-when-file-exists")) {
            uniqueStorageID = BaseLayerUtils.makePseudoUniqueLocation(new RawContentLocation(uniqueStorageID, this.getDataProvider()), this, hints).getContentID();
            hints.markHint("create-new-file-when-file-exists", true);
        }
        binaryFileContent.setLimit(hints);
        log.debug((Object)"Getting fixed length stream...");
        binaryFileContent = binaryFileContent.toFixedLengthStream();
        log.debug((Object)"Done.");
        long length = binaryFileContent.needsLimitTreatment() ? Math.min(binaryFileContent.getLength(), binaryFileContent.getLimit()) : binaryFileContent.getLength();
        if (length > this.maxBlobStreamLength) {
            throw new BaseLayerException("Binary content of size " + (double)binaryFileContent.getLength() / 1048576.0 + " MB exceeds storage capacity of a BLOB field (" + (double)this.maxBlobStreamLength / 1048576.0 + " MB).");
        }
        log.debug((Object)"Getting connection and starting DB transaction to write BLOB.");
        Connection c = this.getConnection();
        try {
            PreparedStatement ps;
            c.setTransactionIsolation(8);
            if (this.checkRawContentExists(uniqueStorageID, c)) {
                ps = c.prepareStatement("UPDATE Raw_Object_Content SET Raw_Content = ? WHERE Raw_Object_ID = ?");
                ps.setBinaryStream(1, binaryFileContent.getStream(), (int)length);
                ps.setString(2, uniqueStorageID);
            } else {
                ps = c.prepareStatement("INSERT INTO Raw_Object_Content (Raw_Object_ID, Raw_Content) VALUES (?,?)");
                ps.setString(1, uniqueStorageID);
                ps.setBinaryStream(2, binaryFileContent.getStream(), (int)length);
            }
            ps.executeUpdate();
            ps.close();
            c.commit();
            log.debug((Object)"Transaction committed.");
            hints.addHint("bytes-transferred", length + "");
            hints.markHint("bytes-transferred", true);
            binaryFileContent.dispose();
            log.debug((Object)"Done writing stream to database.");
            RawContentLocation rawContentLocation = new RawContentLocation(uniqueStorageID, this.dataProvider);
            return rawContentLocation;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            binaryFileContent.dispose();
            this.releaseConnection(c);
        }
    }

    private boolean checkRawContentExists(String uniqueStorageID, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Raw_Object_ID FROM Raw_Object_Content WHERE Raw_Object_ID = ?");
        ps.setString(1, uniqueStorageID);
        ResultSet rs = ps.executeQuery();
        boolean exists = rs.next();
        rs.close();
        ps.close();
        return exists;
    }

    @Override
    public BaseLayerStream getBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws BaseLayerException {
        this.ensureResponsibleFor(rcl);
        Connection c = this.getConnection();
        try {
            if (this.useSubstringForReadingBLOBs) {
                return new SubstringStream(c, rcl.getContentID(), hints);
            }
            c.setTransactionIsolation(2);
            PreparedStatement ps = c.prepareStatement("SELECT Raw_Content FROM Raw_Object_Content WHERE Raw_Object_ID = ?");
            ps.setString(1, rcl.getContentID());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                BlobStream bs = new BlobStream(rs.getBlob(1), c);
                bs.setBuffered(true);
                return bs;
            }
            log.warn((Object)(rcl.getContentID() + " does not exist."));
            throw new ObjectNotFoundException("Raw content does not exist.", rcl.getContentID());
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Unexpected problem while accessing database.", sqle);
        }
    }

    @Override
    public boolean deleteBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws BaseLayerException {
        boolean result = false;
        this.ensureResponsibleFor(rcl);
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            result = this.deleteBinaryContent(rcl, c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            this.releaseConnection(c);
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        return result;
    }

    private boolean deleteBinaryContent(RawContentLocation rcl, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("DELETE FROM Raw_Object_Content WHERE Raw_Object_ID = ?");
        ps.setString(1, rcl.getContentID());
        ps.executeUpdate();
        boolean result = ps.getUpdateCount() > 0;
        ps.close();
        return result;
    }

    @Override
    public boolean existsBinaryContent(RawContentLocation rcl, BasicStorageHints hints) throws BaseLayerException {
        this.ensureResponsibleFor(rcl);
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(2);
            boolean exists = this.checkRawContentExists(rcl.getContentID(), c);
            c.commit();
            c.close();
            return exists;
        }
        catch (SQLException sqle) {
            this.releaseConnection(c);
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
    }

    @Override
    public String createInfoObject(String name, String type, BasicStorageHints hints) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            String newOID;
            if (hints != null && hints.getHintValue("use-predefined-id") != null) {
                newOID = hints.getHintValue("use-predefined-id");
                log.debug((Object)("(Re-)Creating new object with predefined OID '" + newOID + "'."));
                this.ensureOIDNotExists(newOID, c);
                BaseLayerUtils.consumeHint("use-predefined-id", hints);
            } else {
                newOID = this.getUniqueIdentifier();
                log.debug((Object)("Creating new object with generated ID '" + newOID + "'."));
            }
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            boolean success = this.createInfoObject(newOID, c);
            if (!success) {
                c.rollback();
                c.close();
                throw new ValueNotValidException("Could not create successfully new info object.", name, null);
            }
            log.debug((Object)"Setting date of creation.");
            this.setProperty(newOID, "contentmanagement:ObjectCreatedMillis", "contentmanagement:TimeInMilliseconds", "" + System.currentTimeMillis(), c);
            String userDN = hints.consumeHint("initiated-by", false);
            if (userDN != null) {
                try {
                    this.setProperty(newOID, "contentmanagement:ObjectCreatedBy", "X.509.DistinguishedName", userDN);
                }
                catch (BaseLayerException ble) {
                    log.error((Object)("Could not update modifier to " + userDN));
                }
            }
            log.debug((Object)"Setting property name.");
            if (name == null || name.trim().length() <= 0) {
                throw new ValueNotValidException("Cannot create object without a name.", name, "contentmanagement:ObjectName");
            }
            this.setProperty(newOID, "contentmanagement:ObjectName", "xsd:string", name, c);
            log.debug((Object)"Setting property type.");
            if (type != null && type.trim().length() > 0) {
                this.setProperty(newOID, "contentmanagement:ObjectType", "xsd:string", type, c);
            }
            c.commit();
            c.close();
            log.debug((Object)"Object created.");
            String string = newOID;
            return string;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private boolean createInfoObject(String newOID, Connection c) throws SQLException, BaseLayerException {
        log.debug((Object)("Creating new object with ID '" + newOID + "'."));
        this.ensureOIDNotExists(newOID, c);
        PreparedStatement ps = c.prepareStatement("INSERT INTO Info_Object (Info_Object_ID) VALUES ( ? )");
        ps.setString(1, newOID);
        int count = ps.executeUpdate();
        ps.close();
        if (log.isDebugEnabled()) {
            boolean exists = this.checkOIDExists(newOID, c);
            log.debug((Object)("  Created " + count + " new objects; object now exists? " + exists));
        }
        return count == 1;
    }

    @Override
    public BasicInfoObjectDescription getInfoObjectDescription(String oid) throws BaseLayerException {
        return this.getInfoObjectDescription(oid, true, true, true);
    }

    @Override
    public BasicInfoObjectDescription getInfoObjectDescription(String oid, boolean includeProperties, boolean includeReferences, boolean includeReferred) throws BaseLayerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get info object with properties: " + includeProperties + ", with outgoing references " + includeReferences + ", with incoming references: " + includeReferred));
        }
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            if (!this.checkOIDExists(oid, c)) {
                throw new ObjectNotFoundException("Object does not exist.", oid);
            }
            BasicInfoObjectDescription iod = new BasicInfoObjectDescription();
            iod.setObjectID(oid);
            if (includeProperties) {
                log.debug((Object)"Retrieving properties.");
                Map<String, BasicPropertyDescription> properties = this.retrieveObjectProperties(oid, c);
                iod.setProperties(properties);
                log.debug((Object)"Setting name.");
                BasicPropertyDescription pd = properties.get("contentmanagement:ObjectName");
                if (pd != null) {
                    iod.setName(pd.getValue());
                }
                log.debug((Object)"Setting object type.");
                pd = properties.get("contentmanagement:ObjectType");
                if (pd != null) {
                    iod.setType(pd.getValue());
                }
                log.debug((Object)"Setting last modified.");
                pd = properties.get("contentmanagement:ObjectLastModificationMillis");
                if (pd != null) {
                    iod.setLastUpdate(Long.parseLong(pd.getValue()));
                }
            } else {
                iod.setProperties(EMPTY_PROPERTY_MAP);
                log.debug((Object)"Setting name.");
                BasicPropertyDescription pd = this.getProperty(oid, "contentmanagement:ObjectName", c);
                if (pd != null) {
                    iod.setName(pd.getValue());
                }
                log.debug((Object)"Setting object type.");
                pd = this.getProperty(oid, "contentmanagement:ObjectType", c);
                if (pd != null) {
                    iod.setType(pd.getValue());
                }
                log.debug((Object)"Setting last modified.");
                pd = this.getProperty(oid, "contentmanagement:ObjectLastModificationMillis", c);
                if (pd != null) {
                    iod.setLastUpdate(Long.parseLong(pd.getValue()));
                }
            }
            if (includeReferences || includeReferred) {
                log.debug((Object)"Adding references.");
                LinkedList<BasicReferenceDescription> references = new LinkedList<BasicReferenceDescription>();
                if (includeReferences) {
                    references.addAll(this.retrieveReferencesOrderedByPosition(oid, "*", "*", c));
                }
                if (includeReferred) {
                    references.addAll(this.retrieveReferred(oid, "*", "*", c));
                }
                iod.setReferences(references);
            } else {
                iod.setReferences(EMPTY_REFERENCE_COLLECTION);
            }
            c.commit();
            c.close();
            log.debug((Object)"Returning object.");
            BasicInfoObjectDescription basicInfoObjectDescription = iod;
            return basicInfoObjectDescription;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public boolean existsInfoObject(String oid) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(2);
            boolean bl = this.checkOIDExists(oid, c);
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private boolean removeReferenceAndPropagate(BasicReferenceDescription rd, Connection c) throws SQLException, BaseLayerException {
        boolean result = this.removeReference(rd, c);
        if (!result) {
            return false;
        }
        if ("no-delete-propagate".equals(rd.getPropagationRule())) {
            return result;
        }
        if ("delete-source-if-single-apperance".equals(rd.getPropagationRule())) {
            this.deleteIfNoAppearanceOfSourceInThisRole(rd, c);
            return result;
        }
        if ("delete-target-if-single-apperance".equals(rd.getPropagationRule())) {
            this.deleteIfNoAppearanceOfTargetInThisRole(rd, c);
            return result;
        }
        if ("delete-source-propagate".equals(rd.getPropagationRule())) {
            this.removeInfoObjectAndPropagate(rd.getSourceOID(), c);
            return result;
        }
        if ("delete-target-propagate".equals(rd.getPropagationRule())) {
            this.removeInfoObjectAndPropagate(rd.getTargetOID(), c);
            return result;
        }
        log.warn((Object)"Unknown propagation rule - no defined handling of propagation rule. Treating as no propagation.");
        return result;
    }

    private boolean deleteIfNoAppearanceOfSourceInThisRole(BasicReferenceDescription rd, Connection c) throws SQLException, BaseLayerException {
        PreparedStatement ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ?");
        ps.setString(1, rd.getSourceOID());
        ps.setString(2, rd.getRole());
        ResultSet rs = ps.executeQuery();
        boolean noAppearance = !rs.next();
        rs.close();
        ps.close();
        if (noAppearance) {
            return this.removeInfoObjectAndPropagate(rd.getSourceOID(), c);
        }
        return false;
    }

    private boolean deleteIfNoAppearanceOfTargetInThisRole(BasicReferenceDescription rd, Connection c) throws SQLException, BaseLayerException {
        PreparedStatement ps = c.prepareStatement("SELECT Reference_Target FROM Object_Reference WHERE Reference_Target = ? AND Reference_Role = ?");
        ps.setString(1, rd.getTargetOID());
        ps.setString(2, rd.getRole());
        ResultSet rs = ps.executeQuery();
        boolean noAppearance = !rs.next();
        rs.close();
        ps.close();
        if (noAppearance) {
            return this.removeInfoObjectAndPropagate(rd.getTargetOID(), c);
        }
        return false;
    }

    private boolean removeInfoObjectAndPropagate(String oid, Connection c) throws SQLException, BaseLayerException {
        boolean result;
        List<BasicReferenceDescription> references = this.retrieveReferences(oid, "*", "*", c);
        references.addAll(this.retrieveReferred(oid, "*", "*", c));
        Iterator<BasicReferenceDescription> refIt = references.iterator();
        while (refIt.hasNext()) {
            this.removeReferenceAndPropagate(refIt.next(), c);
        }
        this.unlinkAllRawContentFor(oid, c);
        this.unsetProperty(oid, "*", c);
        PreparedStatement ps = c.prepareStatement("DELETE FROM Info_Object WHERE Info_Object_ID = ?");
        ps.setString(1, oid);
        ps.executeUpdate();
        boolean bl = result = ps.getUpdateCount() == 1;
        if (this.performAdditionalChecks && ps.getUpdateCount() > 1) {
            log.warn((Object)("Deletion of object with id '" + oid + "' caused " + ps.getUpdateCount() + " > 1 updates on database!"));
        }
        ps.close();
        return result;
    }

    @Override
    public boolean removeInfoObject(String oid) throws BaseLayerException {
        boolean result = false;
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            log.debug((Object)("Starting recursive deletion of object " + oid));
            result = this.removeInfoObjectAndPropagate(oid, c);
            log.debug((Object)"Relationship and properties are gone, now handling unlinked raw content.");
            this.deleteUnlinkedRawContent(c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
        log.debug((Object)("Operation modifed state: " + result));
        return result;
    }

    @Override
    public boolean removeAllRawContentOf(String oid, BasicStorageHints hints) throws BaseLayerException {
        boolean result = false;
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            result = this.unlinkAllRawContentFor(oid, c);
            this.deleteUnlinkedRawContent(c);
            this.notifyUpdate(oid, hints.getHintValue("initiated-by", null), c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
        return result;
    }

    private boolean unlinkAllRawContentFor(String oid, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("UPDATE Link_Table SET Object_ID = NULL  WHERE Object_ID = ?");
        ps.setString(1, oid);
        ps.executeUpdate();
        boolean result = ps.getUpdateCount() > 0;
        ps.close();
        return result;
    }

    private boolean deleteUnlinkedRawContent() throws BaseLayerException {
        boolean result = false;
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            result = this.deleteUnlinkedRawContent(c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
        return result;
    }

    private boolean deleteUnlinkedRawContent(Connection c) throws SQLException, BaseLayerException {
        log.debug((Object)"Cleaning up unlinked raw content...");
        boolean result = false;
        if (c.getTransactionIsolation() == 0) {
            log.trace((Object)"Setting transaction isolation to SERIALIZABLE");
            c.setTransactionIsolation(8);
        }
        List<RawContentLocation> locations = this.retrieveObjectContentLocations(UNLINKED_RAW_CONTENT, c);
        for (RawContentLocation location : locations) {
            RawFileContentManager manager = StorageManager.getManagerForDataProvider(location.getDataprovider());
            if (manager != null) {
                log.trace((Object)("Going to delete Data provider: " + location.getDataprovider() + " Content ID: " + location.getContentID()));
                result = manager.deleteBinaryContent(location, new BasicStorageHints()) | result;
            } else {
                log.warn((Object)("Unlinked raw content cannot be deleted because data provider is unknown. Data provider: " + location.getDataprovider() + " Content ID: " + location.getContentID()));
            }
            log.debug((Object)"Removing link location...");
            this.removeLinkContentLocation(location, c);
            log.debug((Object)"done.");
        }
        log.debug((Object)"Done.");
        return result;
    }

    @Override
    public void addReference(String sourceoid, String targetoid, String role, String secondaryRole, long position, String propagationRule) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            boolean success = this.addReference(sourceoid, targetoid, role, secondaryRole, position, propagationRule, c);
            if (!success) {
                c.rollback();
                c.close();
                throw new ValueNotValidException("Could not add reference successfully.", sourceoid + " -> " + targetoid, "contentmanagement:reference");
            }
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)"Error executing the update query", (Throwable)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private boolean addReference(String sourceoid, String targetoid, String role, String secondaryRole, long position, String propagationRule, Connection c) throws SQLException, BaseLayerException {
        this.ensureRoleNotAnyRole(role);
        if (this.performAdditionalChecks) {
            if (!this.checkOIDExists(sourceoid, c)) {
                throw new ObjectNotFoundException("Source object does not exist. (sourceoid: " + sourceoid + ")", sourceoid);
            }
            if (!this.checkOIDExists(targetoid, c)) {
                throw new ObjectNotFoundException("Target object does not exist. (targetoid: " + targetoid + ")", targetoid);
            }
            if (this.checkReferenceExists(sourceoid, targetoid, c)) {
                throw new DuplicateIDException("Reference from (sourceoid: " + sourceoid + ") to (targetoid: " + targetoid + "), already exists.", sourceoid + " -> " + targetoid);
            }
        }
        PreparedStatement ps = c.prepareStatement("INSERT INTO Object_Reference (Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation) VALUES (?,?,?,?,?,?)");
        ps.setString(1, sourceoid);
        ps.setString(2, targetoid);
        ps.setString(3, role);
        ps.setString(4, secondaryRole);
        ps.setLong(5, position);
        ps.setString(6, propagationRule);
        this.logStatement(ps);
        int count = ps.executeUpdate();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " row(s) affected."));
        }
        this.notifyUpdate(sourceoid, null, c);
        this.notifyUpdate(targetoid, null, c);
        return count == 1;
    }

    private void logStatement(Statement s) {
        if (log.isDebugEnabled()) {
            if (s instanceof DelegatingStatement) {
                s = ((DelegatingStatement)s).getInnermostDelegate();
            }
            log.debug((Object)("Executing SQL statement: " + s.toString()));
        }
    }

    @Override
    public boolean removeReference(String sourceoid, String targetoid, String role, String secondaryRole) throws BaseLayerException {
        boolean result = false;
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            result = this.removeReferenceAndPropagate(this.getReference(sourceoid, targetoid, role, secondaryRole, c), c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
        return result;
    }

    private boolean removeReference(String sourceoid, String targetoid, String role, String secondaryRole, Connection c) throws SQLException, BaseLayerException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("DELETE FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("DELETE FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ? AND Reference_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
            ps.setString(3, role);
        } else {
            ps = c.prepareStatement("DELETE FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ? AND Reference_Role = ? AND Reference_Secondary_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
            ps.setString(3, role);
            ps.setString(4, secondaryRole);
        }
        this.notifyUpdate(sourceoid, null, c);
        this.notifyUpdate(targetoid, null, c);
        this.logStatement(ps);
        ps.executeUpdate();
        boolean result = ps.getUpdateCount() > 0;
        ps.close();
        return result;
    }

    private boolean removeReference(BasicReferenceDescription rd, Connection c) throws SQLException, BaseLayerException {
        String secondaryRole;
        String sourceOID = rd.getSourceOID();
        String targetOID = rd.getTargetOID();
        String role = rd.getRole();
        if (role == null) {
            role = "*";
        }
        if ((secondaryRole = rd.getSecondaryRole()) == null) {
            secondaryRole = "*";
        }
        return this.removeReference(sourceOID, targetOID, role, secondaryRole, c);
    }

    private List<BasicReferenceDescription> retrieveReferences(String sourceoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ?");
            ps.setString(1, sourceoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ? AND Reference_Secondary_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        LinkedList<BasicReferenceDescription> refDescList = new LinkedList<BasicReferenceDescription>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            refDescList.add(new BasicReferenceDescription(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6)));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (refDescList.size() - initialSize) + " entries to list."));
        }
        return refDescList;
    }

    private long countReferences(String oid, boolean isSource, String role, String secondaryRole, Connection c) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT COUNT(Reference_Source) FROM Object_Reference WHERE " + (isSource ? REFERENCE_SOURCE_ID_COLUMN : REFERENCE_TARGET_ID_COLUMN) + " = ?");
            ps.setString(1, oid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT COUNT(Reference_Source) FROM Object_Reference WHERE " + (isSource ? REFERENCE_SOURCE_ID_COLUMN : REFERENCE_TARGET_ID_COLUMN) + " = ? AND " + REFERENCE_ROLE_COLUMN + " = ?");
            ps.setString(1, oid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT COUNT(Reference_Source) FROM Object_Reference WHERE " + (isSource ? REFERENCE_SOURCE_ID_COLUMN : REFERENCE_TARGET_ID_COLUMN) + " = ? AND " + REFERENCE_ROLE_COLUMN + " = ? AND " + REFERENCE_SECONDARY_ROLE_COLUMN + " = ?");
            ps.setString(1, oid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        long result = (rs = ps.executeQuery()).next() ? rs.getLong(1) : 0L;
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)(result + " references found."));
        }
        return result;
    }

    @Override
    public long countReferences(String oid, boolean isSource, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            long result = this.countReferences(oid, isSource, role, secondaryRole, c);
            c.commit();
            c.close();
            long l = result;
            return l;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public List<BasicReferenceDescription> retrieveReferences(String sourceoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(sourceoid, c);
            List<BasicReferenceDescription> references = this.retrieveReferences(sourceoid, role, secondaryRole, c);
            c.commit();
            c.close();
            List<BasicReferenceDescription> list = references;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public BasicReferenceDescription getReference(String sourceoid, String targetoid) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(sourceoid, c);
            this.ensureOIDExists(targetoid, c);
            BasicReferenceDescription result = this.getReference(sourceoid, targetoid, "*", "*", c);
            c.commit();
            c.close();
            BasicReferenceDescription basicReferenceDescription = result;
            return basicReferenceDescription;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private BasicReferenceDescription getReference(String sourceoid, String targetoid, String role, String secondaryRole, Connection c) throws SQLException, ObjectNotFoundException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ? AND Reference_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
            ps.setString(3, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ? AND Reference_Role = ? AND Reference_Secondary_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, targetoid);
            ps.setString(3, role);
            ps.setString(4, secondaryRole);
        }
        this.logStatement(ps);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            throw new ObjectNotFoundException("Reference does not exist.", sourceoid + " -> " + targetoid);
        }
        BasicReferenceDescription result = new BasicReferenceDescription(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6));
        rs.close();
        ps.close();
        return result;
    }

    private List<BasicReferenceDescription> retrieveReferencesOrderedByPosition(String sourceoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            if (log.isWarnEnabled() && secondaryRole != null && !"*".equals(secondaryRole)) {
                log.warn((Object)("Role was ANY_ROLE, but secondary role=" + secondaryRole + " which will NOT be used in query!"));
            }
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? ORDER BY Reference_Role, Reference_Secondary_Role, Reference_Position ASC");
            ps.setString(1, sourceoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ? ORDER BY Reference_Secondary_Role, Reference_Position ASC");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ? AND Reference_Secondary_Role = ? ORDER BY Reference_Position ASC");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        LinkedList<BasicReferenceDescription> references = new LinkedList<BasicReferenceDescription>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            references.add(new BasicReferenceDescription(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6)));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (references.size() - initialSize) + " entries to list."));
        }
        return references;
    }

    @Override
    public List<BasicReferenceDescription> retrieveReferencesOrderedByPosition(String sourceoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(sourceoid, c);
            List<BasicReferenceDescription> references = this.retrieveReferencesOrderedByPosition(sourceoid, role, secondaryRole, c);
            c.commit();
            c.close();
            List<BasicReferenceDescription> list = references;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private List<BasicReferenceDescription> retrieveReferred(String targetoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Target = ? ORDER BY Reference_Position ASC");
            ps.setString(1, targetoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Target = ? AND Reference_Role = ? ORDER BY Reference_Position ASC");
            ps.setString(1, targetoid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Source, Reference_Target, Reference_Role, Reference_Secondary_Role, Reference_Position, Reference_Propagation FROM Object_Reference WHERE Reference_Target = ? AND Reference_Role = ?  AND Reference_Secondary_Role = ? ORDER BY Reference_Position ASC");
            ps.setString(1, targetoid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        LinkedList<BasicReferenceDescription> refDescList = new LinkedList<BasicReferenceDescription>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            refDescList.add(new BasicReferenceDescription(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getString(6)));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (refDescList.size() - initialSize) + " entries to list."));
        }
        return refDescList;
    }

    @Override
    public List<BasicReferenceDescription> retrieveReferred(String targetoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(targetoid, c);
            List<BasicReferenceDescription> refDescriptions = this.retrieveReferred(targetoid, role, secondaryRole, c);
            c.commit();
            c.close();
            List<BasicReferenceDescription> list = refDescriptions;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private List<String> retrieveReferredSourceOIDs(String targetoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Target = ?");
            ps.setString(1, targetoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Target = ? AND Reference_Role = ?");
            ps.setString(1, targetoid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Target = ? AND Reference_Role = ?  AND Reference_Secondary_Role = ?");
            ps.setString(1, targetoid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        ResultSet rs = ps.executeQuery();
        LinkedList<String> srcOIDs = new LinkedList<String>();
        while (rs.next()) {
            srcOIDs.add(rs.getString(1));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (srcOIDs.size() - initialSize) + " entries to list."));
        }
        return srcOIDs;
    }

    @Override
    public List<String> retrieveReferredSourceOIDs(String targetoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(targetoid, c);
            List<String> srcOIDs = this.retrieveReferredSourceOIDs(targetoid, role, secondaryRole, c);
            c.commit();
            c.close();
            List<String> list = srcOIDs;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private List<String> retrieveReferredTargetOIDs(String sourceoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps;
        if (role == null || "*".equals(role)) {
            ps = c.prepareStatement("SELECT Reference_Target FROM Object_Reference WHERE Reference_Source = ?");
            ps.setString(1, sourceoid);
        } else if (secondaryRole == null || "*".equals(secondaryRole)) {
            ps = c.prepareStatement("SELECT Reference_Target FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
        } else {
            ps = c.prepareStatement("SELECT Reference_Target FROM Object_Reference WHERE Reference_Source = ? AND Reference_Role = ?  AND Reference_Secondary_Role = ?");
            ps.setString(1, sourceoid);
            ps.setString(2, role);
            ps.setString(3, secondaryRole);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        ResultSet rs = ps.executeQuery();
        LinkedList<String> trgOIDs = new LinkedList<String>();
        while (rs.next()) {
            trgOIDs.add(rs.getString(1));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (trgOIDs.size() - initialSize) + " entries to list."));
        }
        return trgOIDs;
    }

    @Override
    public List<String> retrieveReferredTargetOIDs(String sourceoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(sourceoid, c);
            List<String> trgOids = this.retrieveReferredTargetOIDs(sourceoid, role, secondaryRole, c);
            c.commit();
            c.close();
            List<String> list = trgOids;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private Map<String, BasicPropertyDescription> retrieveObjectProperties(String oid, Connection c) throws SQLException, BaseLayerException {
        this.ensureOIDExists(oid, c);
        PreparedStatement ps = c.prepareStatement("SELECT Property_Object_ID, Property_Name, Property_Type, Property_Value FROM Storage_Property WHERE Property_Object_ID = ?");
        ps.setString(1, oid);
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        LinkedHashMap<String, BasicPropertyDescription> properties = new LinkedHashMap<String, BasicPropertyDescription>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String propName = rs.getString(2);
            properties.put(propName, new BasicPropertyDescription(rs.getString(1), propName, rs.getString(3), rs.getString(4)));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (properties.size() - initialSize) + " entries to list."));
        }
        return properties;
    }

    @Override
    public Map<String, BasicPropertyDescription> retrieveObjectProperties(String oid) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            Map<String, BasicPropertyDescription> properties = this.retrieveObjectProperties(oid, c);
            c.commit();
            c.close();
            Map<String, BasicPropertyDescription> map = properties;
            return map;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public List<String> retrieveOIDByProperty(String name, String value) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            List<String> oids = this.retrieveOIDByProperty(name, value, c);
            c.commit();
            c.close();
            List<String> list = oids;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private List<String> retrieveOIDByProperty(String name, String value, Connection c) throws BaseLayerException, SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Property_Object_ID FROM Storage_Property WHERE Property_Name = ? AND Property_Value = ?");
        ps.setString(1, name);
        ps.setString(2, value);
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        ResultSet rs = ps.executeQuery();
        LinkedList<String> oids = new LinkedList<String>();
        while (rs.next()) {
            oids.add(rs.getString(1));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (oids.size() - initialSize) + " entries to list."));
        }
        return oids;
    }

    @Override
    public void setProperty(String oid, String name, String type, String value) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            boolean success = this.setProperty(oid, name, type, value, c);
            if (!success) {
                c.rollback();
                c.close();
                throw new ValueNotValidException("Could not add property successfully.", oid + "." + name, "contentmanagement:property-name");
            }
            this.notifyUpdate(oid, null, c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private boolean setProperty(String oid, String name, String type, String value, Connection c) throws SQLException, BaseLayerException {
        PreparedStatement ps;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting property '" + name + "' of object '" + oid + "' to value '" + value + "' of type '" + type + "'."));
        }
        this.ensurePropertyContainsNoIllegalCharacters(oid, name, type, value);
        if (this.checkPropertyExists(oid, name, c)) {
            log.debug((Object)"  updating existing property.");
            ps = c.prepareStatement("UPDATE Storage_Property SET Property_Type = ? , Property_Value = ?  WHERE Property_Object_ID = ? AND Property_Name = ?");
            ps.setString(1, type);
            ps.setString(2, value);
            ps.setString(3, oid);
            ps.setString(4, name);
        } else {
            log.debug((Object)"  inserting new property.");
            ps = c.prepareStatement("INSERT INTO Storage_Property (Property_Object_ID, Property_Name, Property_Type, Property_Value) VALUES (?,?,?,?)");
            ps.setString(1, oid);
            ps.setString(2, name);
            ps.setString(3, type);
            ps.setString(4, value);
        }
        this.logStatement(ps);
        int count = ps.executeUpdate();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " row(s) affected."));
        }
        return count == 1;
    }

    private void ensurePropertyContainsNoIllegalCharacters(String oid, String propertyName, String propertyType, String propertyValue) throws BaseLayerException {
        if (propertyName == null) {
            throw new ValueNotValidException("Property name may not be empty.", propertyName, "contentmanagement:property-name");
        }
        if (propertyName.equals("contentmanagement:ObjectName")) {
            for (int i = 0; i < PROHIBITED_NAME_PATTERN.length; ++i) {
                Matcher m = PROHIBITED_NAME_PATTERN[i].matcher(propertyValue);
                if (!m.matches()) continue;
                String illegalMatch = m.group();
                log.warn((Object)("Illegal name pattern found in property '" + oid + "/" + propertyName + " = " + propertyValue + "': '" + illegalMatch + "'"));
                throw new ValueNotValidException("Object name may not contain '" + illegalMatch + "'", propertyValue, "contentmanagement:ObjectName");
            }
        }
    }

    @Override
    public BasicPropertyDescription getProperty(String oid, String name) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            BasicPropertyDescription pd = this.getProperty(oid, name, c);
            if (pd == null) {
                throw new ObjectNotFoundException("Property does not exist.", oid + "." + name);
            }
            c.commit();
            c.close();
            BasicPropertyDescription basicPropertyDescription = pd;
            return basicPropertyDescription;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private BasicPropertyDescription getProperty(String oid, String name, Connection c) throws SQLException, ObjectNotFoundException {
        PreparedStatement ps = c.prepareStatement("SELECT Property_Object_ID, Property_Name, Property_Type, Property_Value FROM Storage_Property WHERE Property_Object_ID = ? AND Property_Name = ?");
        ps.setString(1, oid);
        ps.setString(2, name);
        this.logStatement(ps);
        ResultSet rs = ps.executeQuery();
        BasicPropertyDescription pd = rs.next() ? new BasicPropertyDescription(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4)) : null;
        rs.close();
        ps.close();
        return pd;
    }

    @Override
    public boolean hasProperty(String oid, String name) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            BasicPropertyDescription pd = this.getProperty(oid, name, c);
            c.commit();
            c.close();
            boolean bl = pd != null;
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public boolean existsReference(String sourceoid, String targetoid, String role, String secondaryRole) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(sourceoid, c);
            this.ensureOIDExists(targetoid, c);
            boolean exists = this.existsReference(sourceoid, targetoid, role, secondaryRole);
            c.commit();
            c.close();
            boolean bl = exists;
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public boolean unsetProperty(String oid, String name) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            boolean result = this.unsetProperty(oid, name, c);
            c.commit();
            c.close();
            boolean bl = result;
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private boolean unsetProperty(String oid, String name, Connection c) throws SQLException {
        PreparedStatement ps;
        if ("*".equals(name)) {
            ps = c.prepareStatement("DELETE FROM Storage_Property WHERE Property_Object_ID = ?");
            ps.setString(1, oid);
        } else {
            ps = c.prepareStatement("DELETE FROM Storage_Property WHERE Property_Object_ID = ? AND Property_Name = ?");
            ps.setString(1, oid);
            ps.setString(2, name);
        }
        this.logStatement(ps);
        int count = ps.executeUpdate();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " row(s) affected."));
        }
        return count > 0;
    }

    @Override
    public boolean handles(String dataprovider) {
        if (dataprovider == null) {
            return false;
        }
        return dataprovider.startsWith("jdbc");
    }

    public boolean isPerformAdditionalChecks() {
        return this.performAdditionalChecks;
    }

    public void setPerformAdditionalChecks(boolean performAdditionalChecks) {
        this.performAdditionalChecks = performAdditionalChecks;
    }

    private boolean checkOIDExists(String oid, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Info_Object_ID FROM Info_Object WHERE Info_Object_ID = ?");
        ps.setString(1, oid);
        ResultSet rs = ps.executeQuery();
        boolean exists = rs.next();
        rs.close();
        ps.close();
        return exists;
    }

    private void ensureOIDExists(String oid, Connection c) throws SQLException, ObjectNotFoundException {
        if (this.performAdditionalChecks && !this.checkOIDExists(oid, c)) {
            throw new ObjectNotFoundException("Object does not exist. (oid: " + oid + ")", "" + oid);
        }
    }

    private void ensureOIDNotExists(String oid, Connection c) throws SQLException, DuplicateIDException {
        if (this.performAdditionalChecks && this.checkOIDExists(oid, c)) {
            throw new DuplicateIDException("Duplicate ID, object already exists. (oid: " + oid + ")", "" + oid);
        }
    }

    private boolean checkReferenceExists(String sourceoid, String targetoid, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ?");
        ps.setString(1, sourceoid);
        ps.setString(2, targetoid);
        ResultSet rs = ps.executeQuery();
        boolean exists = rs.next();
        rs.close();
        ps.close();
        return exists;
    }

    private boolean checkReferenceExists(String sourceoid, String targetoid, String role, String secondaryRole, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Reference_Source FROM Object_Reference WHERE Reference_Source = ? AND Reference_Target = ? AND Reference_Role = ? AND Reference_Secondary_Role = ?");
        ps.setString(1, sourceoid);
        ps.setString(2, targetoid);
        ps.setString(3, role);
        ps.setString(4, secondaryRole);
        ResultSet rs = ps.executeQuery();
        boolean exists = rs.next();
        rs.close();
        ps.close();
        return exists;
    }

    private void ensureReferenceExists(String sourceoid, String targetoid, Connection c) throws SQLException, ObjectNotFoundException {
        if (this.performAdditionalChecks && !this.checkReferenceExists(sourceoid, targetoid, c)) {
            throw new ObjectNotFoundException("Reference does not exist.", sourceoid + " -> " + targetoid);
        }
    }

    private void ensureReferenceNotExists(String sourceoid, String targetoid, Connection c) throws SQLException, DuplicateIDException {
        if (this.performAdditionalChecks && this.checkReferenceExists(sourceoid, targetoid, c)) {
            throw new DuplicateIDException("Duplicate ID, reference already exists.", sourceoid + " -> " + targetoid);
        }
    }

    private void ensureRoleNotAnyRole(String role) throws ValueNotValidException {
        if (this.performAdditionalChecks && (role == null || "*".equalsIgnoreCase(role))) {
            throw new ValueNotValidException("The specified role is not allowed in this context.", role, "contentmanagement:reference-role");
        }
    }

    private boolean checkPropertyExists(String oid, String name, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("SELECT Property_Object_ID FROM Storage_Property WHERE Property_Object_ID = ? AND Property_Name = ?");
        ps.setString(1, oid);
        ps.setString(2, name);
        ResultSet rs = ps.executeQuery();
        boolean exists = rs.next();
        rs.close();
        ps.close();
        return exists;
    }

    private void ensurePropertyExists(String oid, String name, Connection c) throws SQLException, ObjectNotFoundException {
        if (this.performAdditionalChecks && !this.checkPropertyExists(oid, name, c)) {
            throw new ObjectNotFoundException("Property does not exist.", oid + "." + name);
        }
    }

    private void ensurePropertyNotExists(String oid, String name, Connection c) throws SQLException, DuplicateIDException {
        if (this.performAdditionalChecks && this.checkPropertyExists(oid, name, c)) {
            throw new DuplicateIDException("Property already exists.", oid + "." + name);
        }
    }

    @Override
    public void addLinkContentLocation(String oid, RawContentLocation location) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            this.addLinkContentLocation(oid, location, c);
            this.notifyUpdate(oid, null, c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private void addLinkContentLocation(String oid, RawContentLocation location, Connection c) throws SQLException, ValueNotValidException {
        PreparedStatement ps = c.prepareStatement("INSERT INTO Link_Table (Object_ID, Content_ID, Data_Provider) VALUES (?,?,?)");
        ps.setString(1, oid);
        ps.setString(2, location.getContentID());
        ps.setString(3, location.getDataprovider());
        this.logStatement(ps);
        int count = ps.executeUpdate();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " row(s) affected."));
        }
        if (count != 1) {
            c.rollback();
            c.close();
            log.error((Object)("Could not add location successfully: " + location.getContentID() + "@" + location.getDataprovider()));
            throw new ValueNotValidException("Could not add location successfully.", location.getContentID() + "@" + location.getDataprovider(), "contentmanagement:location");
        }
    }

    @Override
    public void updateLinkContentLocations(String oid, RawContentLocation newestLocation) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            this.removeLinkContentLocation(newestLocation, c);
            this.unlinkAllRawContentFor(oid, c);
            this.addLinkContentLocation(oid, newestLocation, c);
            this.notifyUpdate(oid, null, c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    private void notifyUpdate(String oid, String modifier, Connection c) throws SQLException, BaseLayerException {
        log.debug((Object)"Setting date of last modification of content.");
        if (this.checkOIDExists(oid, c)) {
            this.setProperty(oid, "contentmanagement:ObjectLastModificationMillis", "contentmanagement:TimeInMilliseconds", "" + System.currentTimeMillis(), c);
        } else {
            log.warn((Object)("Notify for OID " + oid + ", which does not exist."));
        }
        if (modifier == null) {
            this.unsetProperty(oid, "contentmanagement:ObjectLastModifiedBy", c);
        } else {
            this.setProperty(oid, "contentmanagement:ObjectLastModifiedBy", "X.509.DistinguishedName", modifier, c);
        }
    }

    @Override
    public boolean removeLinkContentLocation(RawContentLocation location) throws BaseLayerException {
        boolean result = false;
        Connection c = this.getConnection();
        try {
            c.setReadOnly(false);
            c.setTransactionIsolation(8);
            result = this.removeLinkContentLocation(location, c);
            c.commit();
            c.close();
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
        return result;
    }

    private boolean removeLinkContentLocation(RawContentLocation location, Connection c) throws SQLException {
        PreparedStatement ps = c.prepareStatement("DELETE FROM Link_Table WHERE Content_ID = ? AND Data_Provider = ?");
        ps.setString(1, location.getContentID());
        ps.setString(2, location.getDataprovider());
        ps.executeUpdate();
        boolean result = ps.getUpdateCount() > 0;
        ps.close();
        return result;
    }

    private List<RawContentLocation> retrieveObjectContentLocations(String oid, Connection c) throws SQLException {
        PreparedStatement ps;
        if (oid == UNLINKED_RAW_CONTENT) {
            ps = c.prepareStatement("SELECT Content_ID, Data_Provider FROM Link_Table WHERE Object_ID IS NULL");
        } else {
            ps = c.prepareStatement("SELECT Content_ID, Data_Provider FROM Link_Table WHERE Object_ID = ?");
            ps.setString(1, oid);
        }
        int initialSize = 0;
        if (log.isDebugEnabled()) {
            this.logStatement(ps);
        }
        LinkedList<RawContentLocation> locations = new LinkedList<RawContentLocation>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            locations.add(new RawContentLocation(rs.getString(1), rs.getString(2)));
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + (locations.size() - initialSize) + " entries to list."));
        }
        return locations;
    }

    @Override
    public List<RawContentLocation> retrieveObjectContentLocations(String oid) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            List<RawContentLocation> locations = this.retrieveObjectContentLocations(oid, c);
            c.commit();
            c.close();
            List<RawContentLocation> list = locations;
            return list;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public boolean hasRawContent(String oid) throws BaseLayerException {
        Connection c = this.getConnection();
        try {
            c.setReadOnly(true);
            c.setTransactionIsolation(8);
            this.ensureOIDExists(oid, c);
            PreparedStatement ps = c.prepareStatement("SELECT Object_ID FROM Link_Table WHERE Object_ID = ?");
            ps.setString(1, oid);
            ResultSet rs = ps.executeQuery();
            boolean hasRawContent = rs.next();
            rs.close();
            c.commit();
            c.close();
            boolean bl = hasRawContent;
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)sqle);
            throw new BaseLayerException("Error while accessing database.", sqle);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public void ensureResponsibleFor(RawContentLocation rcl) throws ValueNotValidException {
        if (!rcl.getDataprovider().equals(this.dataProvider)) {
            throw new ValueNotValidException("Not responsible for this data location.", rcl.getDataprovider(), "contentmanagement:location");
        }
    }

    @Override
    public String getDataProvider() {
        return this.dataProvider;
    }

    private boolean doesTableExist(String tablename) throws BaseLayerException {
        Connection c = this.getConnection();
        boolean exists = this.doesTableExist(tablename, c);
        this.releaseConnection(c);
        return exists;
    }

    private boolean doesTableExist(String tablename, Connection c) {
        boolean exists = false;
        if (this.trustDatabaseMetadata) {
            try {
                ResultSet rs = c.getMetaData().getTables(c.getCatalog(), null, tablename, null);
                if (rs.next()) {
                    log.info((Object)"here------------------------");
                    String tn = rs.getString("TABLE_NAME");
                    if (tablename.equalsIgnoreCase(tn)) {
                        exists = true;
                    }
                }
                rs.close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"Cannot retrieve database metadata for checking existence of table.");
            }
        } else {
            exists = true;
        }
        if (this.performAdditionalChecks || !this.trustDatabaseMetadata) {
            Statement s = null;
            try {
                log.debug((Object)"Trying to test existence of table directly");
                s = c.createStatement();
                s.executeQuery("SELECT * FROM " + tablename + " WHERE 1=2");
                exists = exists;
            }
            catch (SQLException sqle) {
                log.debug((Object)"There was an exception, thus the table does not exist.");
                exists = false;
                try {
                    c.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return exists;
    }

    public String getNativeType(int javaSQLType) {
        String dbDataType;
        if (this.typeMappingTable == null) {
            log.error((Object)"Type mapping may have not been initialized or updated correctly!");
        }
        if ((dbDataType = this.typeMappingTable.get(new Integer(javaSQLType))) == null) {
            log.info((Object)("No type mapping found for java.sql.Types type with integer number " + javaSQLType));
        }
        return dbDataType;
    }

    private void initializeNativeTypeMapping(Connection conn) throws BaseLayerException {
        try {
            this.typeMappingTable = new HashMap<Integer, String>(this.userDefinedTypeMapping);
            ResultSet res = conn.getMetaData().getTypeInfo();
            while (res.next()) {
                String dbType;
                Integer javaType;
                block10: {
                    javaType = new Integer(res.getInt("DATA_TYPE"));
                    if (this.typeMappingTable.get(javaType) != null || GenericJDBCDatabase.isBlacklistedDatatype(dbType = res.getString("TYPE_NAME"), conn.getMetaData().getDatabaseProductName(), conn.getMetaData().getDatabaseProductVersion())) continue;
                    String defaultPrecisionString = this.defaultPrecisionMapping.get(dbType);
                    if (defaultPrecisionString != null && !res.getBoolean("FIXED_PREC_SCALE")) {
                        block11: {
                            int defaultPrecision;
                            int precision = res.getInt("PRECISION");
                            int separator = defaultPrecisionString.indexOf(44);
                            if (separator == -1) {
                                separator = defaultPrecisionString.length();
                            }
                            String substring = defaultPrecisionString.substring(0, separator);
                            try {
                                defaultPrecision = Integer.parseInt(substring);
                            }
                            catch (NumberFormatException nfe) {
                                break block10;
                            }
                            dbType = defaultPrecision > precision ? dbType + "(" + precision : dbType + "(" + defaultPrecision;
                            int radixPrecision = res.getInt("NUM_PREC_RADIX");
                            if (!res.wasNull() && separator != defaultPrecisionString.length()) {
                                int defaultRadixPrecision;
                                substring = defaultPrecisionString.substring(separator);
                                try {
                                    defaultRadixPrecision = Integer.parseInt(substring);
                                }
                                catch (NumberFormatException nfe) {
                                    break block11;
                                }
                                dbType = defaultRadixPrecision > radixPrecision ? dbType + "," + radixPrecision : dbType + "," + defaultRadixPrecision;
                            }
                        }
                        dbType = dbType + ")";
                    }
                }
                this.typeMappingTable.put(javaType, dbType);
            }
            res.close();
            conn.commit();
        }
        catch (SQLException sqle) {
            log.error((Object)"Could not retrieve mapping information.", (Throwable)sqle);
            log.debug((Object)sqle);
            throw new BaseLayerException("Could not retrive required type-mapping information for database.");
        }
    }

    public static boolean isBlacklistedDatatype(String dbDataType, String databaseProductName, String databaseProductVersion) {
        return dbDataType.equalsIgnoreCase("NVARCHAR") && (databaseProductName.equalsIgnoreCase("Cloudscape") || databaseProductName.equalsIgnoreCase("Derby"));
    }

    public static String getExpliciteMapping(int javaSQLType) {
        return null;
    }

    @Override
    public boolean supportsAppending() {
        return false;
    }

    @Override
    public RawContentLocation makePermanentLocation(RawContentLocation currentLocation, BasicStorageHints hints) throws ValueNotValidException {
        if (BaseLayerUtils.containsDownloadCredentials(hints)) {
            throw new ValueNotValidException("Hints for username and/or password are not allowed in this context.", "permanent location", "contentmanagement:location");
        }
        return currentLocation;
    }

    public static GenericJDBCDatabase getManagerInstance(String[] params, String managerName) throws BaseLayerException {
        if (params.length < 3) {
            throw new BaseLayerException("Missing parameters to instantiate JDBC Connection. Required parameters are: Connection name, driver name, and driver URL");
        }
        if (params.length > 3) {
            return new GenericJDBCDatabase(params[0], params[1], params[2], params[3]);
        }
        return new GenericJDBCDatabase(params[0], params[1], params[2]);
    }

    @Override
    public String getUniqueStorageLocationIDFor(String objectID) {
        return objectID;
    }

    protected static class GenericConnectionAliveTester {
        private final String[] testStatements;

        protected GenericConnectionAliveTester() {
            this.testStatements = null;
        }

        protected GenericConnectionAliveTester(String[] testStatements) {
            this.testStatements = testStatements;
        }

        public boolean isAlive(Connection c) {
            try {
                if (c.isClosed()) {
                    return false;
                }
                if (this.testStatements == null) {
                    c.createStatement().close();
                } else {
                    for (int i = 0; i < this.testStatements.length; ++i) {
                        PreparedStatement ps = c.prepareStatement(this.testStatements[i]);
                        ps.execute();
                        ps.close();
                    }
                }
                return true;
            }
            catch (SQLException sqle) {
                log.info((Object)"Tested connection is not alive.");
                log.debug((Object)sqle);
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DATABASE_PRODUCT {
        MYSQL,
        POSTGRESQL,
        DERBY,
        CLOUDSCAPE,
        UNKNOWN;

    }
}

