/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.util.logging;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.gcube.contentmanagement.util.configuration.BasicConfigurationConstantsNames;
import org.gcube.contentmanagement.util.configuration.Configuration;
import org.gcube.contentmanagement.util.configuration.ConfigurationConstantsNames;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConfigurator {
    private static final String GENERAL_LOG_PATTERN = "%p %t %c - %m%n";
    private static final String CONSOLE_LAYOUT = "%d{ISO8601} %-5p %c{2} [%t,%M:%L] %m%n";
    private static Logger generalLogger = Logger.getLogger(LoggingConfigurator.class);
    private Map<Category, RollingFileAppender> appendersByCategory = new HashMap<Category, RollingFileAppender>();
    private static Map<String, Category> classToCategoryMapping = new HashMap<String, Category>();
    private static Map<String, LoggingConfigurator> configurators = new HashMap<String, LoggingConfigurator>();
    private HashMap<Class<?>, Logger> loggers = new HashMap();
    private String contextID;
    private File basedir;

    public static LoggingConfigurator getConfigurator(String contextID) {
        if (contextID == null) {
            throw new IllegalArgumentException("taskid is null");
        }
        if (!configurators.containsKey(contextID)) {
            configurators.put(contextID, new LoggingConfigurator(contextID));
        }
        return configurators.get(contextID);
    }

    private LoggingConfigurator(String contextID) {
        this.contextID = contextID;
        File basedir = new File(Configuration.getConfiguration((String)contextID).getProperty((ConfigurationConstantsNames)BasicConfigurationConstantsNames.LOGGING_DIR));
        try {
            for (Category category : Category.values()) {
                this.createAppender(category, basedir);
            }
        }
        catch (IOException e) {
            generalLogger.warn((Object)"could not create appenders", (Throwable)e);
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Configuration.getConfiguration();
        LoggingConfigurator logcfg = LoggingConfigurator.getConfigurator(Configuration.getContextID());
        return logcfg.getTaskLogger(clazz);
    }

    public Logger getTaskLogger(Class<?> clazz) {
        if (!this.loggers.containsKey(clazz)) {
            Logger l = Logger.getLogger((String)(clazz.getCanonicalName() + "_" + this.contextID));
            for (String packagePrefix : classToCategoryMapping.keySet()) {
                Category category;
                if (!l.getName().startsWith(packagePrefix) || !this.appendersByCategory.containsKey((Object)(category = classToCategoryMapping.get(packagePrefix)))) continue;
                l.addAppender((Appender)this.appendersByCategory.get((Object)category));
                System.out.println("added " + this.appendersByCategory.get((Object)category) + " to " + l.getName());
                l.setLevel(Level.DEBUG);
            }
            this.loggers.put(clazz, l);
            return l;
        }
        return this.loggers.get(clazz);
    }

    public void createAppender(Category category, File basedir) throws IOException {
        RollingFileAppender app = new RollingFileAppender((Layout)new PatternLayout(GENERAL_LOG_PATTERN), new File(basedir, category.name()).getAbsolutePath());
        app.activateOptions();
        this.appendersByCategory.put(category, app);
    }

    static {
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.client", Category.TASK);
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.datamodel", Category.TASK);
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.importing", Category.TASK);
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.language", Category.TASK);
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.ais", Category.TASK);
        classToCategoryMapping.put("org.gcube.contentmanagement.util", Category.UTIL);
        classToCategoryMapping.put("org.gcube.contentmanagement.archiveimport.library.language.functions.string.Print", Category.SCRIPT);
        classToCategoryMapping.put("org.gcube.contentmanagement.util.remotefile.general", Category.NETWORK);
        classToCategoryMapping.put("org.gcube.contentmanagement.util.remotefile.caching", Category.NETWORK);
        classToCategoryMapping.put("org.gcube.contentmanagement.util.remotefile.protocols", Category.NETWORK);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        TASK,
        UTIL,
        NETWORK,
        SCRIPT;

    }
}

