/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.vti;

import java.awt.geom.Point2D;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIColumnsBuilder;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.Bathymetry;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.FAOAreaExtractor;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.FishingHoursCalculator;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.SurfaceTemperatureExtractor;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.VTIClassificator;
import org.gcube.contentmanagement.timeseries.geotools.vti.connectors.VTIDateFormatConverter;

public class VTIDataExtender {
    ConnectionsManager connectionsManager;
    Bathymetry bathymetryObj;
    private String bathymetryFile;
    private String geoserverURL;
    private VTIColumnsBuilder columnProvider;
    private float status;
    private int chunkSize = 1000;
    private static String buildTempTable = "create table  %1$s (%2$s) WITH ( OIDS=FALSE ); ";
    private static String addColumn = "alter table %1$s add %2$s %3$s;";
    private static String dropColumn = "alter table %1$s drop %2$s;";
    private static String getAllCoordinates = "select %1$s,%2$s, %3$s from %4$s;";
    private static String getInfoOrdered = "select %1$s,%2$s, %3$s from %4$s order by %2$s, %3$s;";
    private static String tempValuesInsert = "INSERT INTO %1$s (%2$s) VALUES %3$s";
    private static String timeseriesValuesUpdate = "UPDATE %1$s SET %2$s=%3$s WHERE %4$s=%5$s";
    private static String tempValuesUpdate = "UPDATE %1$s SET %2$s = %3$s.%2$s FROM %3$s WHERE %1$s.%4$s = %3$s.%4$s";
    private static String tempTableDrop = "drop table %1$s";
    String[] currentKeys;
    Point2D.Double[] currentPoints;
    String[] currentStrings;
    Timestamp[] currentDates;
    Tuple<String>[] currentCouples;

    public VTIDataExtender(TSGeoToolsConfiguration configuration) throws Exception {
        String configPath = configuration.getConfigPath();
        if (!configPath.endsWith("/")) {
            configPath = configPath + "/";
        }
        AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
        long t00 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace((Object)"DataExtender-> initializing objects");
        this.bathymetryFile = configPath + "gebco_08.nc";
        Bathymetry.initInstance(this.bathymetryFile);
        long t01 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace((Object)("DataExtender-> initialized in " + (t01 - t00) + "ms"));
        AnalysisLogger.getLogger().trace((Object)"DataExtender-> initializing connections");
        this.connectionsManager = new ConnectionsManager(configPath);
        EngineConfiguration tscfg = null;
        EngineConfiguration geocfg = null;
        if (configuration.getTimeSeriesDatabase() != null) {
            tscfg = new EngineConfiguration();
            tscfg.setConfigPath(configPath);
            tscfg.setDatabaseUserName(configuration.getTimeSeriesUserName());
            tscfg.setDatabasePassword(configuration.getTimeSeriesPassword());
            tscfg.setDatabaseURL(configuration.getTimeSeriesDatabase());
        }
        if (configuration.getGeoServerDatabase() != null) {
            geocfg = new EngineConfiguration();
            geocfg.setConfigPath(configPath);
            geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
            geocfg.setDatabasePassword(configuration.getGeoServerPassword());
            geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
        }
        this.connectionsManager.initTimeSeriesConnection(tscfg);
        AnalysisLogger.getLogger().trace((Object)"EffortAggregator-> connected to Time Series");
        this.connectionsManager.initGeoserverConnection(geocfg);
        AnalysisLogger.getLogger().trace((Object)"EffortAggregator-> connected to Geo Server");
        this.columnProvider = new VTIColumnsBuilder();
        long t02 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace((Object)("DataExtender-> connections initialized in " + (t02 - t01) + "ms"));
    }

    public void initConnections(EngineConfiguration configuration) throws Exception {
        String configPath = configuration.getConfigPath();
        if (!configPath.endsWith("/")) {
            configPath = configPath + "/";
        }
        this.connectionsManager = new ConnectionsManager(configPath);
        this.connectionsManager.initTimeSeriesConnection(configuration);
        AnalysisLogger.getLogger().trace((Object)"DataExtender-> connected to Database ");
    }

    public void shutDownConnections() throws Exception {
        this.connectionsManager.shutdownAll();
    }

    public void shutDown() throws Exception {
        this.connectionsManager.shutdownAll();
        if (this.bathymetryObj != null) {
            Bathymetry.close();
        }
    }

    public List<Tuple<String>> getColumnsAType(DataExtenderFunctionalities functionality) {
        return this.columnProvider.getColumnInfo(functionality);
    }

    public void extendTable(String tableName, List<Tuple<String>> newColumns, String tableKey, String tableKeyType, String firstDimension, String secondDimension, DataExtenderFunctionalities functionality) throws Exception {
        this.extendTable(tableName, newColumns, tableKey, tableKeyType, firstDimension, secondDimension, functionality, false);
    }

    public void extendTable(String tableName, String tableKey, String tableKeyType, String firstDimension, String secondDimension, DataExtenderFunctionalities functionality) throws Exception {
        List<Tuple<String>> newColumns = this.columnProvider.getColumnInfo(functionality);
        this.extendTable(tableName, newColumns, tableKey, tableKeyType, firstDimension, secondDimension, functionality, false);
    }

    public void extendTable(String tableName, List<Tuple<String>> newColumns, String tableKey, String tableKeyType, String firstDimension, DataExtenderFunctionalities functionality) throws Exception {
        this.extendTable(tableName, newColumns, tableKey, tableKeyType, firstDimension, null, functionality, false);
    }

    public void extendTable(String tableName, String tableKey, String tableKeyType, String firstDimension, DataExtenderFunctionalities functionality) throws Exception {
        List<Tuple<String>> newColumns = this.columnProvider.getColumnInfo(functionality);
        this.extendTable(tableName, newColumns, tableKey, tableKeyType, firstDimension, null, functionality, false);
    }

    private void recreateColumn(String tableName, String columnName, String columnType) {
        AnalysisLogger.getLogger().trace((Object)("extendTable->Dropping column " + columnName + " type " + columnType));
        try {
            this.connectionsManager.TimeSeriesUpdate(String.format(dropColumn, tableName, columnName));
        }
        catch (Exception e0) {
            AnalysisLogger.getLogger().trace((Object)"extendTable->Impossible to drop column");
        }
        AnalysisLogger.getLogger().trace((Object)("extendTable->Adding column " + columnName + " type " + columnType));
        try {
            String alterTableQuery = String.format(addColumn, tableName, columnName, columnType);
            this.connectionsManager.TimeSeriesUpdate(alterTableQuery);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace((Object)("extendTable->Column added yet - or error " + e.getMessage()));
        }
    }

    private String map2String(HashMap<String, List<String>> map) {
        int numOfElements = map.size();
        StringBuffer allChunkBuffer = new StringBuffer();
        int counter = 0;
        for (String key : map.keySet()) {
            List<String> values = map.get(key);
            int valuesize = values.size();
            StringBuffer valuesString = new StringBuffer();
            for (int j = 0; j < valuesize; ++j) {
                String value = values.get(j);
                valuesString.append("'" + value + "'");
                if (j >= valuesize - 1) continue;
                valuesString.append(",");
            }
            allChunkBuffer.append("(" + key + "," + valuesString + ")");
            if (counter < numOfElements - 1) {
                allChunkBuffer.append(",");
            }
            ++counter;
        }
        return allChunkBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extendTable(String tableName, List<Tuple<String>> newColumns, String tableKey, String tableKeyType, String firstDimension, String secondDimension, DataExtenderFunctionalities functionality, boolean ordered) throws Exception {
        this.status = 0.0f;
        long t00 = System.currentTimeMillis();
        StringBuffer columnsDefinitions = new StringBuffer();
        StringBuffer columnsNames = new StringBuffer();
        int ncols = newColumns.size();
        int k = 0;
        for (Tuple<String> column : newColumns) {
            String columnName = column.getElements().get(0);
            String columnType = column.getElements().get(1);
            columnsDefinitions.append(columnName + " " + columnType);
            columnsNames.append(columnName);
            if (k < ncols - 1) {
                columnsDefinitions.append(",");
                columnsNames.append(",");
            }
            ++k;
        }
        AnalysisLogger.getLogger().trace((Object)"extendTable->Column added");
        String tempTableName = ("temp_" + UUID.randomUUID()).replace("-", "_");
        try {
            String tempTableQuery = String.format(buildTempTable, tempTableName, tableKey + " " + tableKeyType + "," + columnsDefinitions);
            this.connectionsManager.TimeSeriesUpdate(tempTableQuery);
            AnalysisLogger.getLogger().trace((Object)("extendTable->Temporary table created " + tempTableQuery));
            if (secondDimension == null) {
                secondDimension = firstDimension;
            }
            AnalysisLogger.getLogger().trace((Object)"extendTable->Getting All Coordinates ... ");
            List<Object> allInfo = null;
            allInfo = ordered ? this.connectionsManager.TimeSeriesQuery(String.format(getInfoOrdered, tableKey, firstDimension, secondDimension, tableName)) : this.connectionsManager.TimeSeriesQuery(String.format(getAllCoordinates, tableKey, firstDimension, secondDimension, tableName));
            AnalysisLogger.getLogger().trace((Object)"extendTable->All Coordinates Got... ");
            int coordinatesNumber = allInfo.size();
            int numberOfChunks = coordinatesNumber / this.chunkSize;
            if (coordinatesNumber % this.chunkSize != 0) {
                ++numberOfChunks;
            }
            AnalysisLogger.getLogger().trace((Object)"extendTable->Processing");
            for (int i = 0; i < numberOfChunks; ++i) {
                float s = (float)((int)((float)i * 100.0f / (float)numberOfChunks * 100.0f)) / 100.0f;
                this.status = s == 100.0f ? 99.0f : s;
                AnalysisLogger.getLogger().trace((Object)("extendTable->Status " + this.status + "%"));
                int startIndex = i * this.chunkSize;
                int maxIndex = Math.min(startIndex + this.chunkSize, coordinatesNumber);
                long t0 = System.currentTimeMillis();
                HashMap<String, List<String>> map = this.transformData(allInfo, startIndex, maxIndex, functionality);
                long t1 = System.currentTimeMillis();
                AnalysisLogger.getLogger().trace((Object)("extendTable->Updating Time Series with the results for chunk " + i + " elapsed " + (t1 - t0) + "ms"));
                String allChunkBuffer = this.map2String(map);
                AnalysisLogger.getLogger().trace((Object)("extendTable->Inserting Chunk " + i));
                String insertionQuery = String.format(tempValuesInsert, tempTableName, tableKey + "," + columnsNames, allChunkBuffer);
                AnalysisLogger.getLogger().trace((Object)"extendTable->");
                this.connectionsManager.TimeSeriesUpdate(insertionQuery);
            }
            AnalysisLogger.getLogger().trace((Object)"extendTable->Updating Original Table");
            for (Tuple<String> column : newColumns) {
                String columnName = column.getElements().get(0);
                String columnType = column.getElements().get(1);
                this.recreateColumn(tableName, columnName, columnType);
                AnalysisLogger.getLogger().trace((Object)(tableName + "," + column.getElements().get(0) + "," + tempTableName + "," + tableKey));
                String originalTableUpdateQuery = String.format(tempValuesUpdate, tableName, column.getElements().get(0), tempTableName, tableKey);
                this.connectionsManager.TimeSeriesUpdate(originalTableUpdateQuery);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                AnalysisLogger.getLogger().trace((Object)"extendTable->Deleting Temporary Table");
                try {
                    this.connectionsManager.TimeSeriesUpdate(String.format(tempTableDrop, tempTableName));
                }
                catch (Exception e1) {
                    AnalysisLogger.getLogger().trace((Object)"extendTable->Could not drop Temporary Table");
                }
                this.status = 100.0f;
                long t01 = System.currentTimeMillis();
                AnalysisLogger.getLogger().trace((Object)("extendTable->Process Finished in " + (t01 - t00) / 60000L + "min"));
                throw throwable;
            }
        }
        AnalysisLogger.getLogger().trace((Object)"extendTable->Deleting Temporary Table");
        try {
            this.connectionsManager.TimeSeriesUpdate(String.format(tempTableDrop, tempTableName));
        }
        catch (Exception e1) {
            AnalysisLogger.getLogger().trace((Object)"extendTable->Could not drop Temporary Table");
        }
        this.status = 100.0f;
        long t01 = System.currentTimeMillis();
        AnalysisLogger.getLogger().trace((Object)("extendTable->Process Finished in " + (t01 - t00) / 60000L + "min"));
    }

    private void extractPoints(List<Object> coordinates, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        this.currentKeys = new String[size];
        this.currentPoints = new Point2D.Double[size];
        int k = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Object[] record = (Object[])coordinates.get(i);
            String key = "" + record[0];
            String x = "" + record[1];
            String y = "" + record[2];
            this.currentKeys[k] = key;
            this.currentPoints[k] = new Point2D.Double(Double.parseDouble(x), Double.parseDouble(y));
            ++k;
        }
    }

    private void extractDatesStrings(List<Object> coordinates, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        this.currentKeys = new String[size];
        this.currentStrings = new String[size];
        this.currentDates = new Timestamp[size];
        int k = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Object[] record = (Object[])coordinates.get(i);
            String key = "" + record[0];
            String f = "" + record[1];
            this.currentKeys[k] = key;
            this.currentStrings[k] = f;
            this.currentDates[k] = (Timestamp)record[2];
            ++k;
        }
    }

    private void extractStrings(List<Object> coordinates, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        this.currentKeys = new String[size];
        this.currentStrings = new String[size];
        int k = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Object[] record = (Object[])coordinates.get(i);
            String key = "" + record[0];
            String f = "" + record[1];
            this.currentKeys[k] = key;
            this.currentStrings[k] = f;
            ++k;
        }
    }

    private void extractStringCouples(List<Object> coordinates, int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        this.currentKeys = new String[size];
        this.currentCouples = new Tuple[size];
        int k = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Object[] record = (Object[])coordinates.get(i);
            String key = "" + record[0];
            String e1 = "" + record[1];
            String e2 = "" + record[2];
            this.currentKeys[k] = key;
            this.currentCouples[k] = new Tuple<String>(e1, e2);
            ++k;
        }
    }

    private HashMap<String, List<String>> transformData(List<Object> coordinates, int startIndex, int endIndex, DataExtenderFunctionalities functionality) throws Exception {
        HashMap<String, List<String>> coordinatesMap = new HashMap<String, List<String>>();
        AnalysisLogger.getLogger().trace((Object)("\ttransformData->Analysis of the function " + (Object)((Object)functionality) + " indexes " + startIndex + " - " + endIndex));
        switch (functionality) {
            case bathymetry: {
                this.extractPoints(coordinates, startIndex, endIndex);
                this.bathymetryObj = new Bathymetry(this.bathymetryFile);
                short[] bathymetries = this.bathymetryObj.compute(this.currentPoints);
                int i = 0;
                for (short bath : bathymetries) {
                    ArrayList<String> baths = new ArrayList<String>();
                    baths.add("" + bath);
                    coordinatesMap.put(this.currentKeys[i], baths);
                    ++i;
                }
                break;
            }
            case fao_areas: {
                this.extractPoints(coordinates, startIndex, endIndex);
                FAOAreaExtractor faoareaextractor = new FAOAreaExtractor(this.geoserverURL, this.connectionsManager);
                Tuple<String>[] faotuples = faoareaextractor.getAreas(this.currentPoints);
                int i = 0;
                for (Tuple<String> singleSet : faotuples) {
                    ArrayList<String> singleList = singleSet.getElements();
                    coordinatesMap.put(this.currentKeys[i], singleList);
                    ++i;
                }
                break;
            }
            case sst: {
                this.extractPoints(coordinates, startIndex, endIndex);
                SurfaceTemperatureExtractor sstObj = new SurfaceTemperatureExtractor();
                float[] temps = sstObj.getSST(this.currentPoints);
                int i = 0;
                for (float temp : temps) {
                    ArrayList<String> tempList = new ArrayList<String>();
                    tempList.add("" + temp);
                    coordinatesMap.put(this.currentKeys[i], tempList);
                    ++i;
                }
                break;
            }
            case vti_dates: {
                this.extractStrings(coordinates, startIndex, endIndex);
                for (int j = 0; j < this.currentStrings.length; ++j) {
                    ArrayList<String> tempvtidatesList = new ArrayList<String>();
                    tempvtidatesList.add(VTIDateFormatConverter.convert2VTIFormat(this.currentStrings[j]));
                    coordinatesMap.put(this.currentKeys[j], tempvtidatesList);
                }
                break;
            }
            case fishing_hours: {
                this.extractDatesStrings(coordinates, startIndex, endIndex);
                double[] hours = FishingHoursCalculator.calculateFishingHours(this.currentStrings, this.currentDates);
                for (int j = 0; j < this.currentStrings.length; ++j) {
                    ArrayList<String> tempvtidatesList = new ArrayList<String>();
                    tempvtidatesList.add("" + hours[j]);
                    coordinatesMap.put(this.currentKeys[j], tempvtidatesList);
                }
                break;
            }
            case classify: {
                this.extractStringCouples(coordinates, startIndex, endIndex);
                Tuple<Integer>[] classifications = VTIClassificator.classify(this.currentCouples);
                for (int j = 0; j < this.currentCouples.length; ++j) {
                    ArrayList<String> tempvticlassificationList = new ArrayList<String>();
                    tempvticlassificationList.add("" + classifications[j].getElements().get(0));
                    tempvticlassificationList.add("" + classifications[j].getElements().get(1));
                    coordinatesMap.put(this.currentKeys[j], tempvticlassificationList);
                }
                break;
            }
        }
        return coordinatesMap;
    }

    public double getStatus() {
        return this.status;
    }

    public void setStatus(float status) {
        this.status = status;
    }

    public void setGeoserverURL(String url) {
        this.geoserverURL = url;
    }

    public String setGeoserverURL() {
        return this.geoserverURL;
    }

    public static enum DataExtenderFunctionalities {
        bathymetry,
        fao_areas,
        sst,
        vti_dates,
        fishing_hours,
        classify;

    }
}

