/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.gisconnectors;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.engine.MakeStyle;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;

public class GISOperations {
    GeoCaller geoCaller;
    private static final String crs = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    public static String DEFAULTSTYLE = "Species_prob";
    public static String TEMPLATEGROUP = "groupTemplate";

    public String getCurrentGeoServer() {
        if (this.geoCaller != null) {
            return this.geoCaller.getCurrentWmsGeoserver();
        }
        return "";
    }

    public static String createFulfilGeometriesStatement(String tableName) {
        String creationStatement = "UPDATE " + tableName + " SET the_geom = new_all_world.the_geom FROM new_all_world WHERE " + tableName + ".csquarecode = new_all_world.csquarecode;";
        return creationStatement;
    }

    public static String createLayerTableStatement(String tableName, String featureName, featuresTypes type) {
        String creationStatement = "create table " + tableName + "(gid serial, csquarecode character varying(30), the_geom geometry, " + featureName + " " + (Object)((Object)type) + ", details character varying) WITH ( OIDS=FALSE ); ";
        return creationStatement;
    }

    public GeoCaller getGeoCaller(GISInformation gisInfo) {
        try {
            if (this.geoCaller == null) {
                this.geoCaller = new GeoCaller(gisInfo.getGeoNetworkUrl(), gisInfo.getGeoNetworkUserName(), gisInfo.getGeoNetworkPwd(), gisInfo.getGisUrl(), gisInfo.getGisUserName(), gisInfo.getGisPwd(), GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
                return this.geoCaller;
            }
            return this.geoCaller;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean generateStyle(GISInformation gisInfo, GISStyleInformation styleInformation) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        String style = "";
        if (styleInformation.getScaleType() == GISStyleInformation.Scales.logarithm) {
            AnalysisLogger.getLogger().trace((Object)"log scale");
            style = styleInformation.getValuesType() == Integer.class ? MakeStyle.createStyleLog((String)styleInformation.getStyleName(), (String)styleInformation.getStyleAttribute(), (int)styleInformation.getNumberOfClasses(), (Color)styleInformation.getGradientBase(), (Color)styleInformation.getGradientMax(), (Class)styleInformation.getValuesType(), (Object)styleInformation.getMax().intValue(), (Object)styleInformation.getMin().intValue()) : MakeStyle.createStyleLog((String)styleInformation.getStyleName(), (String)styleInformation.getStyleAttribute(), (int)styleInformation.getNumberOfClasses(), (Color)styleInformation.getGradientBase(), (Color)styleInformation.getGradientMax(), (Class)styleInformation.getValuesType(), (Object)styleInformation.getMax(), (Object)styleInformation.getMin());
        } else {
            AnalysisLogger.getLogger().trace((Object)"linear scale");
            if (styleInformation.getValuesType() == Integer.class) {
                AnalysisLogger.getLogger().trace((Object)"integer management");
                style = MakeStyle.createStyle((String)styleInformation.getStyleName(), (String)styleInformation.getStyleAttribute(), (int)styleInformation.getNumberOfClasses(), (Color)styleInformation.getGradientBase(), (Color)styleInformation.getGradientMax(), (Class)styleInformation.getValuesType(), (Object)styleInformation.getMax().intValue(), (Object)styleInformation.getMin().intValue());
            } else {
                AnalysisLogger.getLogger().trace((Object)"other num type management");
                style = MakeStyle.createStyle((String)styleInformation.getStyleName(), (String)styleInformation.getStyleAttribute(), (int)styleInformation.getNumberOfClasses(), (Color)styleInformation.getGradientBase(), (Color)styleInformation.getGradientMax(), (Class)styleInformation.getValuesType(), (Object)styleInformation.getMax(), (Object)styleInformation.getMin());
            }
        }
        boolean toReturn = false;
        AnalysisLogger.getLogger().trace((Object)"sending request to geoServer");
        toReturn = caller.sendStyleSDL(style);
        AnalysisLogger.getLogger().trace((Object)("sent request to geoServer " + toReturn));
        return toReturn;
    }

    public boolean deleteStyle(GISInformation gisInfo, String styleName) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        caller.deleteStyleSDL(styleName, true);
        return true;
    }

    public boolean deleteLayer(GISInformation gisInfo, String layerName) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        caller.deleteLayer(layerName);
        return true;
    }

    public boolean deleteGroup(GISInformation gisInfo, String groupName) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        caller.deleteLayersGroup(groupName);
        return true;
    }

    public boolean createLayers(GISInformation gisInfo) throws Exception {
        List<GISLayerInformation> gisLayers = gisInfo.getLayers();
        for (GISLayerInformation layerInfo : gisLayers) {
            boolean created = this.createLayer(gisInfo, layerInfo);
            if (created) continue;
            return false;
        }
        return true;
    }

    private boolean createLayer(GISInformation gisInfo, GISLayerInformation layerInformation) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        AnalysisLogger.getLogger().trace((Object)("Current Geoserver in use: " + caller.getCurrentWmsGeoserver()));
        FeatureTypeRest featureTypeRest = new FeatureTypeRest();
        featureTypeRest.setDatastore(gisInfo.getGisDataStore());
        featureTypeRest.setEnabled(true);
        featureTypeRest.setLatLonBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
        featureTypeRest.setNativeBoundingBox(new BoundsRest(-180.0, 180.0, -85.5, 90.0, "EPSG:4326"));
        featureTypeRest.setName(layerInformation.getLayerName());
        featureTypeRest.setNativeName(layerInformation.getLayerName());
        featureTypeRest.setProjectionPolicy("FORCE_DECLARED");
        featureTypeRest.setSrs("EPSG:4326");
        featureTypeRest.setNativeCRS(crs);
        if (layerInformation.getLayerTitle() != null && layerInformation.getLayerTitle().length() > 0) {
            featureTypeRest.setTitle(layerInformation.getLayerTitle());
        } else {
            featureTypeRest.setTitle(layerInformation.getLayerName());
        }
        featureTypeRest.setWorkspace(gisInfo.getGisWorkspace());
        boolean addFeature = false;
        try {
            addFeature = caller.addFeatureType(featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)"ERROR IN adding feature");
        }
        if (addFeature) {
            boolean setLayerValue = caller.setLayer(featureTypeRest, layerInformation.getDefaultStyle(), gisInfo.getStylesNames(layerInformation.getLayerName()));
            return setLayerValue;
        }
        return false;
    }

    public boolean createNewGroupOnGeoServer(GISInformation gisInfo) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        GroupRest gtemp = null;
        try {
            gtemp = caller.getLayerGroup(gisInfo.getGroup().getTemplateGroupName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        GroupRest g = new GroupRest();
        g.setBounds(gtemp.getBounds());
        int nlayers = gisInfo.getLayers().size();
        for (int i = 0; i < nlayers; ++i) {
            String layerName = gisInfo.getLayers().get(i).getLayerName();
            g.addLayer(layerName);
            List<GISStyleInformation> styles = gisInfo.getStyles().get(layerName);
            for (GISStyleInformation style : styles) {
                AnalysisLogger.getLogger().trace((Object)("adding style " + style.getStyleName() + " to layer " + layerName));
                g.addStyle(layerName, style.getStyleName());
            }
        }
        g.setName(gisInfo.getGroup().getGroupName());
        boolean toReturn = caller.addLayersGroup(g, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS);
        return toReturn;
    }

    public boolean createGroupOnGeoServer(GISInformation gisInfo) throws Exception {
        GeoCaller caller = this.getGeoCaller(gisInfo);
        AnalysisLogger.getLogger().trace((Object)("Current Geoserver in use: " + caller.getCurrentWmsGeoserver()));
        GroupRest g = null;
        try {
            g = caller.getLayerGroup(gisInfo.getGroup().getTemplateGroupName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        int nlayers = gisInfo.getLayers().size();
        for (int i = 0; i < nlayers; ++i) {
            String layerName = gisInfo.getLayers().get(i).getLayerName();
            g.addLayer(layerName);
            List<GISStyleInformation> styles = gisInfo.getStyles().get(layerName);
            for (GISStyleInformation style : styles) {
                AnalysisLogger.getLogger().trace((Object)("adding style " + style.getStyleName() + " to layer " + layerName));
                g.addStyle(layerName, style.getStyleName());
            }
        }
        g.setName(gisInfo.getGroup().getGroupName());
        boolean toReturn = caller.addLayersGroup(g, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS);
        return toReturn;
    }

    public boolean generateGisMap(GISInformation gisInfo) {
        return this.generateGisMap(gisInfo, false);
    }

    public boolean generateGisMap(GISInformation gisInfo, boolean ignoreStylesFailure) {
        AnalysisLogger.getLogger().trace((Object)"GenerateGisMap-> generating Styles ... ");
        for (List<GISStyleInformation> styles : gisInfo.getStyles().values()) {
            for (GISStyleInformation style : styles) {
                if (style.getStyleName().equals(DEFAULTSTYLE)) continue;
                try {
                    AnalysisLogger.getLogger().trace((Object)("GenerateGisMap-> generating Style " + style.getStyleName() + " with " + style.getNumberOfClasses() + " classes "));
                    this.generateStyle(gisInfo, style);
                    AnalysisLogger.getLogger().trace((Object)"GenerateGisMap<- OK");
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().trace((Object)("GenerateGisMap<-KO - Impossible to generate Style " + style.getStyleName() + " maybe yet existing " + e.getMessage()));
                    if (ignoreStylesFailure) continue;
                    return false;
                }
            }
        }
        AnalysisLogger.getLogger().trace((Object)"GenerateGisMap-> generating Layers ... ");
        try {
            this.createLayers(gisInfo);
            AnalysisLogger.getLogger().trace((Object)"GenerateGisMap<- OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().trace((Object)"GenerateGisMap<-KO - Error in creating layers maybe yet existing");
        }
        boolean returning = true;
        return returning;
    }

    public static void main(String[] args) {
        AnalysisLogger.setLogger((String)"./cfg/ALog.properties");
        String testTable = "labalistesstellatus20111124164310556";
        String testTableTitle = "abalistesstellatus Title";
        GISInformation gisInfo = new GISInformation();
        gisInfo.setGisDataStore("aquamapsdb");
        gisInfo.setGisPwd("gcube@geo2010");
        gisInfo.setGisWorkspace("aquamaps");
        gisInfo.setGisUrl("http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver");
        gisInfo.setGisUserName("admin");
        GISLayerInformation gisLayer1 = new GISLayerInformation();
        gisLayer1 = new GISLayerInformation();
        gisLayer1.setDefaultStyle("Species_prob");
        gisLayer1.setLayerName(testTable);
        gisLayer1.setLayerTitle(testTableTitle);
        GISGroupInformation gisGroup = new GISGroupInformation();
        gisGroup.setGroupName("testGroupJP51");
        gisGroup.setTemplateGroupName(TEMPLATEGROUP);
        gisGroup.setTemplateGroup(true);
        GISStyleInformation style = new GISStyleInformation();
        style.setStyleName(DEFAULTSTYLE);
        GISStyleInformation newstyle = new GISStyleInformation();
        newstyle.setStyleName("newstylejptest" + UUID.randomUUID());
        Color c1 = Color.green;
        Color c2 = Color.blue;
        newstyle.setGradientBase(c1);
        newstyle.setGradientMax(c2);
        newstyle.setMax(1.0);
        newstyle.setMin(0.0);
        newstyle.setNumberOfClasses(4);
        newstyle.setScaleType(GISStyleInformation.Scales.linear);
        newstyle.setStyleAttribute("probability");
        newstyle.setValuesType(Double.class);
        gisInfo.addLayer(gisLayer1);
        gisInfo.setGroup(gisGroup);
        gisInfo.addStyle(gisLayer1.getLayerName(), style);
        GISOperations operations = new GISOperations();
        operations.generateGisMap(gisInfo, true);
    }

    public static enum featuresTypes {
        integer,
        real;

    }
}

