/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.tools;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISGroupInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISLayerSaver;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISStyleInformation;
import org.gcube.contentmanagement.timeseries.geotools.representations.GISLayer;
import org.hibernate.SessionFactory;

public class CreateLayerFromProbability {
    private static String probabilityquery = "select %2$s,%3$s from %1$s";
    ConnectionsManager connectionsManager;

    public static void main(String[] args) throws Exception {
        CreateLayerFromProbability creatorProb = new CreateLayerFromProbability();
        String geoserverURL = "jdbc:postgresql://geoserver-dev.d4science-ii.research-infrastructures.eu/aquamapsdb";
        String geoserverUser = "postgres";
        String geoserverPwd = "d4science2";
        String originURL = "jdbc:postgresql://localhost/testdb";
        String originUser = "gcube";
        String originPwd = "d4science2";
        String configPath = "./cfg/";
        String tableName = "hspec_nn_baskingshark_random_best2";
        String csquareColumn = "csquarecode";
        String probabilityColumn = "probability";
        String speciesID = "Fis-22747";
        creatorProb.init(configPath, geoserverURL, originURL, geoserverUser, geoserverPwd, originUser, originPwd);
        creatorProb.produceLayer(tableName, speciesID, csquareColumn, probabilityColumn);
    }

    public static void main1(String[] args) {
        double[] subs = MathFunctions.logSubdivision((double)0.0, (double)1.0, (int)5);
        for (int i = 0; i < subs.length; ++i) {
            System.out.print(subs[i] + " ");
        }
    }

    public void init(String configPath, String geoserverDB, String originDBURL, String geoserverUser, String geoserverPwd, String originUser, String originPwd) throws Exception {
        TSGeoToolsConfiguration configuration = new TSGeoToolsConfiguration();
        configuration.setConfigPath(configPath);
        configuration.setGeoServerDatabase(geoserverDB);
        configuration.setGeoServerUserName(geoserverUser);
        configuration.setGeoServerPassword(geoserverPwd);
        configuration.setAquamapsDatabase(originDBURL);
        configuration.setAquamapsUserName(originUser);
        configuration.setAquamapsPassword(originPwd);
        AnalysisLogger.setLogger((String)(configPath + "ALog.properties"));
        AnalysisLogger.getLogger().debug((Object)"CreateLayerFromProbability -> initializing connections");
        this.connectionsManager = new ConnectionsManager(configPath);
        EngineConfiguration geocfg = new EngineConfiguration();
        geocfg.setConfigPath(configPath);
        geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
        geocfg.setDatabasePassword(configuration.getGeoServerPassword());
        geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
        EngineConfiguration destGeocfg = new EngineConfiguration();
        destGeocfg.setConfigPath(configPath);
        destGeocfg.setDatabaseUserName(configuration.getAquamapsUserName());
        destGeocfg.setDatabasePassword(configuration.getAquamapsPassword());
        destGeocfg.setDatabaseURL(configuration.getAquamapsDatabase());
        this.connectionsManager.initGeoserverConnection(geocfg);
        this.connectionsManager.initAquamapsConnection(destGeocfg);
    }

    public void produceLayer(String tableName, String speciesID, String csquareColumn, String probabilityColumn) throws Exception {
        GISLayerSaver gislayersav = new GISLayerSaver(this.connectionsManager);
        GISLayer layer = new GISLayer(tableName);
        layer.setValuesColumnName("probability");
        layer.setMin(0.0);
        layer.setMax(1.0);
        layer.setPreferredStyleName("Species_prob");
        List rows = DatabaseFactory.executeSQLQuery((String)String.format(probabilityquery, tableName, csquareColumn, probabilityColumn), (SessionFactory)this.connectionsManager.getAquamapsConnection());
        for (Object row : rows) {
            Object[] information = (Object[])row;
            ArrayList<String> csquares = new ArrayList<String>();
            csquares.add("" + information[0]);
            double informationd = 0.0;
            if (information[1] != null) {
                informationd = Double.parseDouble("" + information[1]);
            }
            layer.appendListofSquares(csquares, informationd, "");
        }
        gislayersav.createLayerOnDB(layer, GISOperations.featuresTypes.real);
    }

    public String generatePointGisMap(String destinationTable, String mapName, GISInformation gisInfo, String stylename) throws Exception {
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->creating layer");
        GISStyleInformation style = new GISStyleInformation();
        style.setStyleName(stylename);
        GISLayerInformation gisLayer1 = new GISLayerInformation();
        gisLayer1.setDefaultStyle(style.getStyleName());
        gisLayer1.setLayerName(destinationTable);
        gisLayer1.setLayerTitle(mapName);
        gisInfo.addLayer(gisLayer1);
        gisInfo.addStyle(gisLayer1.getLayerName(), style);
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->adding layers - done!");
        String groupName = destinationTable.replace("-", "");
        GISOperations gisOperations = new GISOperations();
        GISGroupInformation gisGroup = new GISGroupInformation();
        gisGroup.setGroupName(groupName);
        gisGroup.setTemplateGroupName(GISOperations.TEMPLATEGROUP);
        gisGroup.setTemplateGroup(true);
        gisInfo.setGroup(gisGroup);
        boolean generated = gisOperations.generateGisMap(gisInfo, true);
        if (!generated) {
            throw new Exception("Impossible to create layer on Geonetwork");
        }
        ArrayList<String> layersList = new ArrayList<String>();
        layersList.add(destinationTable);
        boolean urlcoherence = true;
        if (!urlcoherence) {
            return null;
        }
        AnalysisLogger.getLogger().trace((Object)"generateXYMaps->GIS Layer created!");
        return destinationTable;
    }
}

