/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.calls.curation;

import java.rmi.Remote;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.stubs.ApplyRulesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckDimensionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckRulesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckTypeChangeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.EditColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EditDimensionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetDataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ModifyEntryByIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ModifyEntryByValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryValueWithIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetColumnAsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetCurationProperties;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetLabelRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CurationManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimensionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.RuleItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.RulesArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.SelectQuery;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.oasis.wsrf.lifetime.Destroy;

public class CurationServiceCall {
    private CurationManagerPortType curationManagerPT;

    public CurationServiceCall(EndpointReferenceType epr, GCUBEScope scope, GCUBESecurityManager securityManager) throws Exception {
        this.curationManagerPT = (CurationManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)new CurationManagerServiceAddressingLocator().getCurationManagerPortTypePort(epr), (GCUBEScope)scope, (int)120000, (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
    }

    public void editDimension(String dimensionId, String fieldId, String keyId) throws Exception {
        this.curationManagerPT.editDimension(new EditDimensionRequest(dimensionId, fieldId, keyId));
    }

    public void editColumn(String fieldId, DataType newType) throws Exception {
        this.curationManagerPT.editColumn(new EditColumnRequest(fieldId, newType));
    }

    public void editRules(String fieldId) throws Exception {
        this.curationManagerPT.editRules(fieldId);
    }

    public long getElementCount() throws Exception {
        return this.curationManagerPT.count(new VOID());
    }

    public String getDataAsJson(SelectQuery query, boolean onlyErrors) throws Exception {
        int tries = 0;
        while (true) {
            try {
                return this.curationManagerPT.getDataAsJson(new GetDataAsJsonRequest(onlyErrors, query));
            }
            catch (Exception e) {
                Exception exception = e;
                if (++tries < 3) continue;
                throw exception;
            }
            break;
        }
    }

    public long getErrorCount() throws Exception {
        return this.curationManagerPT.errorCount(new VOID());
    }

    public ColumnDefinition[] getDimensions() throws Exception {
        return this.curationManagerPT.getDimensions(new VOID()).getColumnDefinition();
    }

    public long checkForDimension(String dimensionId, String fieldId, String keyId) throws Exception {
        return this.curationManagerPT.checkDimension(new CheckDimensionRequest(dimensionId, fieldId, keyId));
    }

    public long checkForRules(String fieldId, FilterCondition[] filters) throws Exception {
        return this.curationManagerPT.checkRules(new CheckRulesRequest(fieldId, filters));
    }

    public long checkForTypeChange(String fieldId, DataType type) throws Exception {
        return this.curationManagerPT.checkTypeChange(new CheckTypeChangeRequest(fieldId, type));
    }

    public void setLabel(String fieldId, String newLabel) throws Exception {
        this.curationManagerPT.setLabelName(new SetLabelRequest(fieldId, newLabel));
    }

    public void saveColumnDefinition() throws Exception {
        this.curationManagerPT.saveColumnDefinition(new VOID());
    }

    public void closeEdit() throws Exception {
        this.curationManagerPT.closeEditing(new VOID());
    }

    public void removeAllErrors() throws Exception {
        this.curationManagerPT.removeAllErrors(new VOID());
    }

    public void removeError(long rowId) throws Exception {
        this.curationManagerPT.removeSingleError(rowId);
    }

    public boolean isInEditMode() throws Exception {
        return this.curationManagerPT.isInEditMode(new VOID());
    }

    public void destroy() throws Exception {
        this.curationManagerPT.destroy(new Destroy());
    }

    public Status isUnderInitialization() throws Exception {
        return this.curationManagerPT.isUnderInitialization(new VOID());
    }

    public GuessDimension[] guessDimension(String fieldId) throws Exception {
        GuessDimensionArray dimArray = this.curationManagerPT.guessDimension(fieldId);
        if (dimArray != null && dimArray.getGuessDimension() != null) {
            return dimArray.getGuessDimension();
        }
        return new GuessDimension[0];
    }

    public Status getInitializeEditingState() throws Exception {
        return this.curationManagerPT.initializeEditingState(new VOID());
    }

    public void setColumnAsAttribute(String fieldId) throws Exception {
        this.curationManagerPT.setColumnAs(new SetColumnAsRequest(EntryType.Attribute, fieldId));
    }

    public void setColumnAsUndefined(String fieldId) throws Exception {
        this.curationManagerPT.setColumnAs(new SetColumnAsRequest(EntryType.Undefined, fieldId));
    }

    public void setColumnAsValue(String fieldId) throws Exception {
        this.curationManagerPT.setColumnAs(new SetColumnAsRequest(EntryType.Value, fieldId));
    }

    public ColumnDefinition getColumnInEditMode() throws Exception {
        return this.curationManagerPT.columnInEditMode(new VOID());
    }

    public void removeColumn(String fieldId) throws Exception {
        this.curationManagerPT.removeColumn(fieldId);
    }

    public void replaceEntryId(String oldId, String newId, String fieldId) throws Exception {
        this.curationManagerPT.replaceEntryId(new ReplaceEntryIdRequest(fieldId, newId, oldId));
    }

    public void replaceEntryValue(String oldValue, String newValue, String fieldId) throws Exception {
        this.curationManagerPT.replaceEntryValue(new ReplaceEntryValueRequest(fieldId, newValue, oldValue));
    }

    public void modifyEntryByValue(String fieldId, String newValue, long rowId) throws Exception {
        this.curationManagerPT.modifyEntryByValue(new ModifyEntryByValueRequest(fieldId, newValue, rowId));
    }

    public void modifyEntryById(String fieldId, String newId, long rowId) throws Exception {
        this.curationManagerPT.modifyEntryById(new ModifyEntryByIdRequest(fieldId, newId, rowId));
    }

    public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception {
        this.curationManagerPT.replaceEntryValueWithId(new ReplaceEntryValueWithIdRequest(fieldId, newId, oldValue));
    }

    public String getPossibleValuesAsJSon(String word) throws Exception {
        return this.curationManagerPT.getPossibleValues(word);
    }

    public ErrorPair[] getDistinctErrors() throws Exception {
        return this.curationManagerPT.getDistinctErrors(new VOID()).getErrorPairs();
    }

    public void setProperties(String description, String publisher, String rights, String title) throws Exception {
        this.curationManagerPT.setProperties(new SetCurationProperties(description, publisher, rights, title));
    }

    public void applyRules(String fieldId, RuleItem[] ruleItems) throws Exception {
        this.curationManagerPT.applyRules(new ApplyRulesRequest(fieldId, new RulesArray(ruleItems)));
    }

    public RuleItem[] getApplyedRules(String fieldId) throws Exception {
        RulesArray items = this.curationManagerPT.getApplyedRules(fieldId);
        if (items == null || items.getItems() == null) {
            return new RuleItem[0];
        }
        return items.getItems();
    }

    public RuleItem[] getApplyableRules(String fieldId) throws Exception {
        RulesArray items = this.curationManagerPT.getApplyableRules(fieldId);
        if (items == null || items.getItems() == null) {
            return new RuleItem[0];
        }
        return items.getItems();
    }

    public void removeApplyedRules(String fieldId) throws Exception {
        this.curationManagerPT.removeApplyedRules(fieldId);
    }
}

