package org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

import com.thoughtworks.xstream.XStream;

@TableRootDefinition
public class CLManagerWrapper {

	private static GCUBELog logger = new GCUBELog(CLManagerWrapper.class);
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String[] superUsers;
	
	@FieldDefinition(precision={60}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
	private String codelistId;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private GCUBEScope scope;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private Status status= Status.Initializing;
	
	@FieldDefinition(precision={60})
	private String parentId;

	@FieldDefinition(precision={60}, specifications={Specification.NOT_NULL})
	private String creator;
	
	
	@SuppressWarnings("unused")
	private CLManagerWrapper(){}	
	
	public CLManagerWrapper(String codelistId, String creator,
			GCUBEScope scope, String ... superUsers) {
		super();
		this.superUsers = superUsers;
		this.codelistId = codelistId;
		this.scope = scope;
		this.creator = creator;
	}

	/**
	 * @return the superUsers
	 */
	public String[] getSuperUsers() {
		return superUsers;
	}

	/**
	 * @return the creator
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @param superUsers the superUsers to set
	 */
	public void setSuperUsers(String[] superUsers) {
		this.superUsers = superUsers;
	}

	/**
	 * @return the codelistId
	 */
	public String getCodelistId() {
		return codelistId;
	}

	/**
	 * @param codelistId the codelistId to set
	 */
	public void setCodelistId(String codelistId) {
		this.codelistId = codelistId;
	}

	/**
	 * @return the scope
	 */
	public GCUBEScope getScope() {
		return scope;
	}

	/**
	 * @param scope the scope to set
	 */
	public void setScope(GCUBEScope scope) {
		this.scope = scope;
	}

	/**
	 * @return the status
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(Status status) {
		this.status = status;
	}

	/**
	 * @return the parentId
	 */
	public String getParentId() {
		return parentId;
	}

	public String getDataAsJson(Select selectQuery) throws Exception {
		selectQuery.setTables(new Table(this.getCodelist().getRelatedTableName()));
		return selectQuery.getResultAsJSon(true);
	}
	
	public CodeList getCodelist() throws Exception{
		return ObjectPersistency.get(CodeList.class).getByKey(this.getCodelistId());
	}
	
	public CodelistColumnsDefinitionArray getColumnsDefinition() throws Exception{
		List<CodelistColumnDefinition> columnDefintionArray= new ArrayList<CodelistColumnDefinition>();
		TableField[] returnList = this.getCodelist().getLabelFieldMapping().values().toArray(new TableField[0]);
		Arrays.sort(returnList);
		for (TableField field : returnList)
			columnDefintionArray.add(new CodelistColumnDefinition(CodelistColumnType.fromString(field.getColumnReference().getType().toString()), Util.mapSqlToJava(field.getDataType()), field.getId(), field.getFieldName(), field.getColumnReference().getCodelistReferenceId()));
		return new CodelistColumnsDefinitionArray(columnDefintionArray.toArray(new CodelistColumnDefinition[columnDefintionArray.size()]));	
			
	}
	
	/**
	 * @param parentId the parentId to set
	 */
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}
	
	public synchronized boolean remove(){
		try {
			ObjectPersistency.get(CLManagerWrapper.class).deleteByKey(this.getCodelistId());
			getCodelist().remove();
		} catch (Exception e) {
			return false;
		}
		return true;
	}
	
	public static Iterator<CLManagerWrapper> getAll() throws Exception{
		return ObjectPersistency.get(CLManagerWrapper.class).getAll().iterator();
	}

	public synchronized boolean store(){
		try{
			ObjectPersistency<CLManagerWrapper> op =ObjectPersistency.get(CLManagerWrapper.class);
			if (!op.existsKey(this.getCodelistId()))
				op.insert(this);
			else op.update(this);
		}catch (Exception e) {
			logger.error("error storing codelist wrapper on DB",e);
			return false;
		}
		return true;
	}

	public static CLManagerWrapper get(String key) throws Exception{
		return ObjectPersistency.get(CLManagerWrapper.class).getByKey(key);
	}

	public static Iterator<CLManagerWrapper> getByScope(GCUBEScope scope) throws Exception{
		return  ObjectPersistency.get(CLManagerWrapper.class).getObjectByField("scope", new XStream().toXML(scope)).iterator();
	}

	
	
}
