package org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing;

import java.util.HashMap;

import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimensionArray;

@TableRootDefinition
public class GuessingObject {
	
	@FieldDefinition
	private HashMap<String, GuessDimensionArray> guessingMap = null;
	@FieldDefinition(specifications={Specification.PRIMARY_KEY}, precision={50})
	private String id;
	
	
	@SuppressWarnings("unused")
	private GuessingObject(){}
	
	public GuessingObject(String relatedResourceId){
		this.id = relatedResourceId;
	}
	
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @return the guessingMap
	 */
	public HashMap<String, GuessDimensionArray> getGuessingMap() {
		return guessingMap;
	}

	/**
	 * @param guessingMap the guessingMap to set
	 */
	public void setGuessingMap(HashMap<String, GuessDimensionArray> guessingMap) {
		this.guessingMap = guessingMap;
	}
	
	
}
