package org.gcube.contentmanagement.timeseriesservice.impl.importer;

import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizedImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetProgressResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResourceHome;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Export;
import org.globus.wsrf.ResourceException;

public class ImportManager {

	private GCUBELog logger= new GCUBELog(ImportManager.class);
	
	private ImportResource getResource() throws ResourceException{
		ImportResourceHome home=(ImportResourceHome) ImportContext.getPortTypeContext().getWSHome();
		return (ImportResource) home.find();
	}
	
	
	/**
	 * performs the import operation
	 * 
	 * @param importLocator the RSLocator 
	 * @return VOID
	 * @throws GCUBEFault 
	 * 
	 */
	public VOID importOperation(ImportRequest request) throws GCUBEFault{
		try{
			getResource().getImporterReference().storeData(request);
		}catch(Exception e){
			logger.error("error importing data",e);	
			throw new GCUBEFault(e,"error importing data");
		}
		return new VOID();
	}
	
	/**
	 * performs the import operation
	 * 
	 * @param importLocator the RSLocator 
	 * @return VOID
	 * @throws GCUBEFault 
	 * 
	 */
	public VOID denormalizedImportOperation(DenormalizedImportRequest request) throws GCUBEFault{
		try{
			getResource().getImporterReference().storeDenormalizedData(request);
		}catch(Exception e){
			logger.error("error importing data",e);	
			throw new GCUBEFault(e,"error importing data");
		}
		return new VOID();
	}
	
	/**
	 * 
	 * @return
	 * @throws GCUBEFault
	 */
	public Status getImportState(VOID request) throws GCUBEFault{
		try{
			return getResource().getImporterReference().getStatus();
		}catch(Exception e){
			logger.error("error importing data");	
			throw new GCUBEFault(e,"error importing data");
		}
	}
	
	
	/**
	 * 
	 * @param limit
	 * @return
	 * @throws GCUBEFault
	 */
	public String getDataAsJson(Limit limit) throws GCUBEFault{
		try{
			return getResource().getDataAsJson(limit);
		}catch(Exception e){
			logger.error("error getting data",e);	
			throw new GCUBEFault(e,"error getting data");
		}
	}
	
	
	/**
	 * 
	 * @param request
	 * @return
	 * @throws GCUBEFault
	 */
	public ColumnDefinitionArray getColumnsDefinition(VOID request) throws GCUBEFault{
		logger.debug("the caller scope "+ServiceContext.getContext().getScope());
		try{
			return new ColumnDefinitionArray(getResource().getImporterReference().getColumnsDefinition());
		}catch(Exception e){
			logger.error("error columns definition",e);	
			throw new GCUBEFault(e,"error getting columns definition");
		}
	}
	
	/**
	 * 
	 * @param request
	 * @return
	 * @throws GCUBEFault
	 */
	public GetProgressResponse getProgress(VOID request) throws GCUBEFault{
		try{
			return new GetProgressResponse(getResource().getImporterReference().getImportProgress(), getResource().getImporterReference().getExstimatedLines());
		}catch(Exception e){
			logger.error("error getting data");	
			throw new GCUBEFault(e,"error calculating progress");
		}
	}
	
	/**
	 * 
	 * @param request
	 * @return
	 * @throws GCUBEFault
	 */
	public String exportAsCsv(ExportRequest request) throws GCUBEFault{
		try{
			return Export.asCsv(request, getResource().getImporterReference().getColumnsDefinition(), getResource().getTable());
		}catch(Exception e){
			logger.error("error performing export in csv",e);
			throw new GCUBEFault(e);
		}
	}
	
		
}
