package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender.DataExtenderFunctionalities;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.AddFAOAreasRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class AddFAOAreas extends Operation {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6868708330903612012L;

	private static GCUBELog logger= new GCUBELog(Enrichment.class);
	
	public AddFAOAreas() {
		super();
		this.type= OperationType.AddFAOAreas;
		this.viewName="afa"+uuidGen.nextUUID().replaceAll("-", "");
	}

	private String messageIdColumn;
	private String xDimColumn;
	private String yDimColumn;
		
	@Override
	public void setParameters(Object... parameters) throws Exception {
		AddFAOAreasRequest request = (AddFAOAreasRequest) parameters[0];
		this.messageIdColumn = request.getMessageIdColumn();
		this.xDimColumn = request.getXDimColumn();
		this.yDimColumn = request.getYDimColumn();
	}

	@Override
	protected void initialize(String previuosTableName,
			ColumnDefinition[] previousTableDefinition, DBSession session)
			throws Exception {
		try {
			logger.trace("initializing add fao areas");
		
			Select select = DBSession.getImplementation(Select.class);
			select.setTables(new Table(previuosTableName));
			this.setColumnDefinition(previousTableDefinition);
			this.createTable(select, session, true);
			
			List<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
			newColumnDefinition.addAll(Arrays.asList(previousTableDefinition));
			
			this.viewTable.initializeFieldMapping();
			
			String tablePrimaryKeyType =this.viewTable.getFieldsMapping().get(messageIdColumn).getType().getListSqlTypes().get(0);
			
			VTIDataExtender extender = ServiceContext.getContext().getVtiDataExtender();
						
			extender.extendTable(this.viewName, this.messageIdColumn,tablePrimaryKeyType, xDimColumn, yDimColumn, DataExtenderFunctionalities.fao_areas);
			
			List<Tuple<String>> couples = extender.getColumnsAType(DataExtenderFunctionalities.fao_areas);
			for (Tuple<String> couple: couples){
				logger.trace("enrichment found "+couple.getElements().get(0));
				DataType valueType = Util.mapSqlToJava(Type.parseType(couple.getElements().get(1), 50, 10, 5).getType());
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, couple.getElements().get(0), null, couple.getElements().get(0), valueType));
			}
			
						
			this.viewTable.initializeFieldMapping();
			this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[newColumnDefinition.size()]));
			setCount(this.viewTable.getCount());
			setHistoryItem(new TSHistoryItem("unknown","add fao areas applied",new Date(),OperationType.AddFAOAreas));

			logger.trace("add fao areas finished");
		}catch (Exception e) {
			logger.error("error adding fao areas",e);
			throw e;
		}
	}

}
