package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class ColumnChange extends Operation {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4477370022652327533L;
	
	private static transient GCUBELog logger= new GCUBELog(ColumnChange.class);
	
	private String fieldId; 
	private String keyId;
	private String keyName;
	private String codeFieldIdInDim;
	
	public ColumnChange() throws Exception{
		super();
		this.type= OperationType.ColumnChange;
		this.viewName="cc"+uuidGen.nextUUID().replaceAll("-", "");
	}		
	
	@Override
	public void setParameters(Object... parameters) throws Exception {
		this.fieldId= (String) parameters[0];
		this.keyId= (String) parameters[1];
	}

	@Override
	protected void initialize(String previuosTableName,
			ColumnDefinition[] previousTableDefinition, DBSession session)
			throws Exception {
		
		logger.trace("initializing the columnChange with fieldID "+this.fieldId+" and keyId "+this.keyId);
		ColumnDefinition def = getColumnDefinitionReference(this.fieldId, previousTableDefinition);
		Dimension dimension= def.getDimension();
		if (dimension==null) throw new Exception("the selected field is not a dimension");
		
		SimpleTable previousTable = new SimpleTable(previuosTableName);
		this.createTable(previuosTableName, session);
		
		//retrieve the reference table name
		CodeList codelist = CodeList.get(dimension.getId());
		SimpleTable dimensionTable=codelist.getTable();
		keyName = codelist.getLabelFieldMapping().get(keyId).getFieldName();
		codeFieldIdInDim = codelist.getCodeColumnId();
		//check if the alter column is needed
		DataType keyDataType;
		Type newKeyType= dimensionTable.getFieldsMapping().get(this.keyId);
		Type actualColumnType= previousTable.getFieldsMapping().get(this.fieldId); 
		if(newKeyType.getType()!= actualColumnType.getType() || !Arrays.equals(newKeyType.getPrecisionArray(), actualColumnType.getPrecisionArray())){
			ModifyColumnType modifyColumn= DBSession.getImplementation(ModifyColumnType.class);
			modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
			modifyColumn.setNewType(newKeyType);
			modifyColumn.setTable(this.viewTable);
			modifyColumn.execute(session);
			keyDataType= Util.mapSqlToJava(newKeyType.getType()); 
		}else keyDataType= Util.mapSqlToJava(actualColumnType.getType());  
		
		String query = insert(previousTableDefinition, previuosTableName, dimensionTable.getTableName(), session);
						
		setHistoryItem(new TSHistoryItem(query,"changed column type of "+def.getLabel(),new Date(),OperationType.ColumnChange));
		this.setNewColumnDefintion(previousTableDefinition, keyDataType);
	}
		
	private String insert(ColumnDefinition[] previousTableDefinition, String previuosTableName, String dimensiontableName, DBSession session) throws Exception{
		InsertFromSelect insert = DBSession.getImplementation(InsertFromSelect.class);
		insert.setTable(this.viewTable);
		//preparing the select
		final String previusTableAlias = "prev";
		final String dimensionTableAlias = "dim";
		Select select = DBSession.getImplementation(Select.class);
		select.setTables(new SimpleTable(previuosTableName,previusTableAlias), new SimpleTable(dimensiontableName, dimensionTableAlias));
		List<Attribute> listAttributes= new ArrayList<Attribute>();
		//retrieving attributes
		String relatedDimensionIdField=null;
		//logger.trace("preparing query for insert");
		for(ColumnDefinition def: previousTableDefinition){
			//logger.trace("field id in codeList is "+def.getId());
			if(def.getId().equals(this.fieldId)){
				listAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(this.fieldId), new SimpleAttribute(this.keyId, dimensionTableAlias)));
				relatedDimensionIdField = def.getDimensionRelatedFieldId();
			}else listAttributes.add(new SimpleAttribute(def.getId(), previusTableAlias));
			if(def.getColumnType()==EntryType.Dimension)
				listAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(), previusTableAlias));
		}
		if (relatedDimensionIdField==null) throw new Exception("error retrieving the associated fieldId");
		select.setAttributes(listAttributes.toArray(new Attribute[listAttributes.size()]));
	
		select.setFilter(new OperatorCondition<SimpleAttribute, SimpleAttribute>(new SimpleAttribute(relatedDimensionIdField, previusTableAlias), new SimpleAttribute(this.codeFieldIdInDim, dimensionTableAlias),"="));
		
		logger.trace("subquery is "+select.getExpression());
		
		insert.setSubQuery(select);
		insert.execute(session);
		return insert.getExpression();
	}

	private void setNewColumnDefintion(ColumnDefinition[] previousTableDefinition, DataType keyDataType) throws Exception{
		ColumnDefinition[] newColumnDefintion=previousTableDefinition;
		ColumnDefinition def = getColumnDefinitionReference(this.fieldId, newColumnDefintion);
		def.setKey(new Key(this.keyId, keyName,  keyDataType));
		this.setColumnDefinition(newColumnDefintion);
	}
	
}
