package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.io.Serializable;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Order.OrderType;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.DropTable;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state.TimeSeriesResource;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;


@SuppressWarnings("serial")
public abstract class Operation implements Serializable{
	
	protected ColumnDefinition[] columnDefinition=null;
	
	protected static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
	
	private static GCUBELog logger= new GCUBELog(Operation.class);
	
	private TSHistoryItem historyItem;
	
	protected long extimatedCount;
	
	protected CurrentState currentState= CurrentState.Closed;
	
	protected OperationType type= OperationType.None;
		
	protected String viewName;
	
	protected SimpleTable viewTable= null;
	
	public abstract void setParameters(Object... parameters) throws Exception;
	
	protected abstract void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception;
	
	public String getDataAsJSon(Limit limit, Order order) throws Exception {
		Select selectQuery=DBSession.getImplementation(Select.class);
		selectQuery.setTables(new Table(this.viewName));
		selectQuery.setLimit(new org.gcube.common.dbinterface.Limit(limit.getLowerLimit(), limit.getUpperLimit()));
		if (order!=null){
			OrderType orderType=order.getOrder().getValue().equals("Ascending")?OrderType.ASC:OrderType.DESC;
			selectQuery.setOrders(new org.gcube.common.dbinterface.Order(orderType,new SimpleAttribute(order.getField())));
		}
		logger.trace("operation query: "+selectQuery.getExpression());
		return selectQuery.getResultAsJSon(true);	
	}

	protected long count;
	
	protected static TimeSeriesResource getResource(String resourceId) throws Exception{
		return (TimeSeriesResource) TimeSeriesContext.getPortTypeContext().getWSHome().find(TimeSeriesContext.getPortTypeContext().makeKey(resourceId)); 
	}
	
	public synchronized void apply(final String previuosTableName, final ColumnDefinition[] previousTableDefinition) throws Exception{
		setCurrentState(CurrentState.InProgress);
		new Thread(){
			public void run(){
				DBSession session= null;
				try{
					session= DBSession.connect();
					initialize(previuosTableName, cloneColumnDefinition(previousTableDefinition), session);
					setCurrentState(CurrentState.Closed);
				}catch (Throwable e){
					setCurrentState(CurrentState.Error);
					logger.error("an error occurred initializing the request operation",e);
					try{discard();}catch(Exception e1){logger.error("error occurred discarding after an error");}
				}finally{
					if (session!=null)
						session.release();
				}
			}
		}.start();
	}
	
	public long getCount() {
		return count;
	}

	public void setCount(long count) {
		this.count = count;
	}

	public String getViewName() {
		return viewName;
	}

	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	public OperationType getType() {
		return type;
	}

	public void setType(OperationType _type) {
		this.type = _type;
	}

	public CurrentState getCurrentState() {
		return currentState;
	}

	public void setCurrentState(CurrentState currentState) {
		this.currentState = currentState;
	}
	
	public ColumnDefinition[] getColumnDefinition(){
		return columnDefinition;
	}
	
	public void setColumnDefinition(ColumnDefinition[] columnDefintion){
		this.columnDefinition= columnDefintion;
	}

		
	public synchronized void discard() throws Exception {
		DBSession session=DBSession.connect();
		DropTable drop= DBSession.getImplementation(DropTable.class);
		drop.setTableName(this.viewName);
		try{
			drop.execute(session);
		}catch (Exception e) {
			throw e;	
		}finally{
			session.release();
		}
	}
	
	protected void createTable(Select query,  DBSession session, boolean data) throws Exception{
		CreateTableFromSelect createQuery= DBSession.getImplementation(CreateTableFromSelect.class);
		createQuery.setSelect(query);
		createQuery.setTableName(this.viewName);
		if (!data)createQuery.setWithoutData();
		logger.debug("create query:"+createQuery.getExpression());
		this.viewTable=createQuery.execute(session);
		createIndexesOnTable(session);
	}
	
	protected void createTable(String previousTableName, DBSession session) throws Exception{
		CreateTableLike createTable= DBSession.getImplementation(CreateTableLike.class);
		createTable.setTableLike(new SimpleTable(previousTableName));
		createTable.setTableName(this.viewName);
		this.viewTable= createTable.execute(session);
	}
	
	
	private void createIndexesOnTable(DBSession session) throws Exception {
		for (ColumnDefinition def:getColumnDefinition())
			if(!def.getId().contains(Denormalization.PIVOT_PREFIX))
				if (def.getColumnType()== EntryType.Dimension)
					Utility.createIndexOnField(this.viewTable, def.getId()+CurationResource.ID_COLUMN_SUFFIX, false);
	}	
	
	/**
	 * 
	 * @param fieldId
	 * @return
	 * @throws Exception
	 */
	public static ColumnDefinition getColumnDefinitionReference(String fieldId, ColumnDefinition[] columnsDefintion) throws Exception{
		for (ColumnDefinition def: columnsDefintion)
			if (def.getId().compareTo(fieldId)==0)
				return def;
		throw new Exception("fieldId "+fieldId+" not found in Operation");	
	}

	public TSHistoryItem getHistoryItem() {
		return historyItem;
	}

	public void setHistoryItem(TSHistoryItem historyItem) {
		this.historyItem = historyItem;
	}
	
	private ColumnDefinition[] cloneColumnDefinition(ColumnDefinition[] def){
		ColumnDefinition[] newDef = new ColumnDefinition[def.length];
		for (int i =0 ; i<def.length; i++ )
			newDef[i] = new ColumnDefinition(def[i].getColumnType(), def[i].getDimension(), def[i].getDimensionRelatedFieldId(), def[i].getId(), def[i].getKey(), def[i].getLabel(), def[i].getValueType());
		return newDef;
	}
}
