package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVWriter;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.timeseriesservice.calls.RSWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;


public class Export {
	
	public static GCUBELog logger= new GCUBELog(Export.class);
	
	public static String asCsv(final ExportRequest req, ColumnDefinition[] definitionsArray, SimpleTable table) throws Exception{
    	logger.debug("export as csv method with delimiter "+req.getDelimiter()+" ");
    	    	    	
    	final List<SimpleAttribute> fieldsNameInDb=new ArrayList<SimpleAttribute>(definitionsArray.length);
    	final List<String> fieldsName= new ArrayList<String>();
    	for (int i=0; i<definitionsArray.length; i++){
    		ColumnDefinition columnDefinition= definitionsArray[i]; 
    		if (req.getFieldsMask()[i]){
    			fieldsName.add(columnDefinition.getLabel());
    			fieldsNameInDb.add(new SimpleAttribute(columnDefinition.getId()));
    		}
    	}
    	
    	final File file= File.createTempFile("tsExport",".csv");
    	
    	DBSession session=null;
    	final CSVWriter csvWriter;
    	final ResultSet selectQueryRS;
    	final OutputStreamWriter osw;
    	try{
    		FileOutputStream fos= new FileOutputStream(file);
    		osw = new OutputStreamWriter(fos, req.getEncoding());
    		csvWriter= new CSVWriter(osw,req.getDelimiter().charAt(0));
    		session = DBSession.connect();
    		Select selectQuery= DBSession.getImplementation(Select.class);
    		selectQuery.setAttributes(fieldsNameInDb.toArray(new Attribute[0]));
    		selectQuery.setTables(table);
    		selectQueryRS = selectQuery.getResults(session);
   		
    	}catch (Exception e) {
			logger.error("error exporting the file",e);
    		throw e;
		}finally {
			if (session!=null) session.release();
		}

    	logger.debug("initializing the stream");
    	final RSWrapper rsWrapper= new RSWrapper(ServiceContext.getContext().getScope());
    	logger.debug("entering in the thread");
    	new Thread(){
    		public void run(){
    			try{
    				
    				if (req.isHasHeader())
    	    			csvWriter.writeLine(fieldsName);
    	    		while (selectQueryRS.next()){
    	    			List<String> rowString= new ArrayList<String>();
    	    			for (SimpleAttribute fieldAttribute : fieldsNameInDb){
    	    				String value = selectQueryRS.getString(fieldAttribute.getAttributeName()); 
    	    				rowString.add(value==null?"":value);
    	    			}
    	    			try{
    	    				csvWriter.writeLine(rowString);
    	    			}catch(Exception e){logger.error("error writing into outputStream ",e);}
    	    		}
    	    		try {
    	    			osw.close();
    	    		} catch (Exception e) {
    	    			logger.error("error closing the stream",e);
    	    		}
    				/*
    				File zipFile= File.createTempFile("exportCSVZip", ".zip"); 
    				FileOutputStream outputZip= new FileOutputStream(zipFile);
    				Util.getZip( outputZip, "export",new FileInputStream(file));
    				outputZip.close();
    				*/
    	    		logger.trace(file.getAbsolutePath());
    	    		rsWrapper.add(file);
    	    		rsWrapper.close();
    				//zipFile.delete();
    				logger.debug("export finished");
    			} catch (Exception e) {
    				logger.error("error filling the RS thread ",e);
    			}
    		}
    	}.start();
 	
    	
    	return rsWrapper.getLocator().toString();
    }
	
	
	/**
	 *
	 * allows to export a codelist, delimiter and encoding are fixed (, as delimiter and utf-8 as encoding)
	 * 
	 * @param definitionsArray
	 * @param table
	 * @param codelistName
	 * @return
	 * @throws Exception
	 */
	public static String codeListAsCsv(SimpleTable table, String codelistName, final boolean header ) throws Exception{
   	final File file= File.createTempFile("tsExport",".csv");
    	
    	DBSession session=null;
    	final CSVWriter csvWriter;
    	final ResultSet selectQueryRS;
    	final OutputStreamWriter osw;
    	try{
    		FileOutputStream fos= new FileOutputStream(file);
    		osw = new OutputStreamWriter(fos, "utf-8");
    		csvWriter= new CSVWriter(osw,',');
    		session = DBSession.connect();
    		Select selectQuery= DBSession.getImplementation(Select.class);
    		selectQuery.setTables(table);
    		selectQueryRS = selectQuery.getResults(session);
   		
    	}catch (Exception e) {
			logger.error("error exporting the file",e);
    		throw e;
		}finally {
			if (session!=null) session.release();
		}

    	logger.debug("initializing the stream");
    	final RSWrapper rsWrapper= new RSWrapper(ServiceContext.getContext().getScope());
    	logger.debug("entering in the thread");
    	new Thread(){
    		public void run(){
    			try{
    				if (header) {
    					List<String> columnsName = new ArrayList<String>();
    					for (int i =1; i<= selectQueryRS.getMetaData().getColumnCount(); i++ )
    						columnsName.add(selectQueryRS.getMetaData().getColumnName(i));
    					csvWriter.writeLine(columnsName);
    				}
    	    		while (selectQueryRS.next()){
    	    			List<String> rowString= new ArrayList<String>();
    	    			for (int i =1; i<= selectQueryRS.getMetaData().getColumnCount(); i++ ){
    	    				String value =selectQueryRS.getString(i); 
    	    				rowString.add(value==null?"":value);
    	    			}
    	    			try{
    	    				csvWriter.writeLine(rowString);
    	    			}catch(Exception e){
    	    				logger.error("error writing into outputStream ",e);
    	    			}
    	    		}
    	    		try {
    	    			osw.close();
    	    		} catch (Exception e) {
    	    			logger.error("error closing the stream",e);
    	    		}
    				logger.trace(file.getAbsolutePath());
    	    		rsWrapper.add(file);
    	    		rsWrapper.close();
    				logger.debug(" codelist export finished");
    			} catch (Exception e) {
    				logger.error("error filling the RS thread ",e);
    			}
    		}
    	}.start();
 	
    	
    	return rsWrapper.getLocator().toString();
    }

	
}
