/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;

@TableRootDefinition
public class Curation {
    @FieldDefinition(specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY}, precision={50})
    private String id;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String title;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String creator;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
    private String sourceId;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String sourceName;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Timestamp date;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={10})
    private int length;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
    private String type;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String publisher;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String rights;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String scope;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private HashMap<String, ArrayList<Rule>> fieldRulesMapping = new HashMap();

    public Curation(String id) {
        this.id = id;
    }

    private Curation() {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Timestamp getDate() {
        return this.date;
    }

    public void setDate(Timestamp date) {
        this.date = date;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<String, ArrayList<Rule>> getFieldRulesMapping() {
        return this.fieldRulesMapping;
    }

    public void addRuleToField(String fieldId, Rule rule) {
        if (this.getFieldRulesMapping().get(fieldId) == null) {
            ArrayList<Rule> singletonArray = new ArrayList<Rule>();
            singletonArray.add(rule);
            this.getFieldRulesMapping().put(fieldId, singletonArray);
        } else {
            this.getFieldRulesMapping().get(fieldId).add(rule);
        }
    }

    public void removeAllRulesForField(String fieldId) {
        this.getFieldRulesMapping().remove(fieldId);
    }

    public void store() throws Exception {
        ObjectPersistency persistency = ObjectPersistency.get(Curation.class);
        if (!persistency.existsKey((Object)this.id)) {
            persistency.insert((Object)this);
        } else {
            persistency.update((Object)this);
        }
    }

    public static Curation getCurationItem(String id) throws Exception {
        return (Curation)ObjectPersistency.get(Curation.class).getByKey((Object)id);
    }
}

