/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation.rules;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;

@TableRootDefinition
public class Rule
extends ObjectStateControl
implements Serializable {
    private static final long serialVersionUID = -146515956046723087L;
    private static transient GCUBELog logger = new GCUBELog(Rule.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;
    @FieldDefinition(precision={80}, specifications={Specification.NOT_NULL})
    private String name;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String humanReadable;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private FilterCondition filter;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Type.Types type;

    private Rule() {
    }

    public Rule(String name, String description, String humanReadable, FilterCondition filter, Type.Types type) {
        this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        this.name = name;
        this.description = description;
        this.humanReadable = humanReadable;
        this.filter = filter;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public Type.Types getType() {
        return this.type;
    }

    public FilterCondition getFilter() {
        return this.filter;
    }

    public boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(Rule.class);
            if (!op.existsKey((Object)this.getId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Iterator<Rule> getAll() throws Exception {
        return ObjectPersistency.get(Rule.class).getAll().iterator();
    }

    public static Iterator<Rule> getByType(Type.Types type) throws Exception {
        return ObjectPersistency.get(Rule.class).getObjectByField("type", (Object)type.toString()).iterator();
    }

    public static Rule get(String id) throws Exception {
        return (Rule)ObjectPersistency.get(Rule.class).getByKey((Object)id);
    }

    public static void destroy(String id) throws Exception {
        ObjectPersistency.get(Rule.class).deleteByKey((Object)id);
    }
}

