/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation.state;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.NOTCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.DropTable;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Selection;
import org.gcube.common.dbinterface.queries.Update;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableFromSubselect;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.Curation;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing.GuessingObject;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing.GuessingPrefetcher;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.ColumnEditor;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.DimensionEditor;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.Edit;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.RuleEditor;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistory;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.FilterExplorer;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Constants;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ValueNotCompatibleFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimensionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.RuleItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class CurationResource
extends GCUBEWSResource {
    public static final String ID_COLUMN_SUFFIX = "_id";
    private CurationHistory history;
    protected static final String RP_ID = "Id";
    protected static final String RP_SOURCEID = "SourceId";
    protected static final String RP_SOURCENAME = "SourceName";
    protected static final String RP_TITLE = "Title";
    protected static String[] RPNames = new String[]{"Id", "Title", "SourceId", "SourceName"};
    private Edit fieldEditor = null;
    private int totalLine;
    private Map<String, int[]> fieldLenght;
    private ColumnDefinition[] columnDefinition;
    private Status underCreationState;
    private SimpleTable table;

    public String[] getPropertyNames() {
        return RPNames;
    }

    protected void initialise(Object ... initParameters) throws Exception {
        this.setUnderCreationState(Status.Open);
        this.setId((String)initParameters[0]);
        this.setSourceId((String)initParameters[4]);
        this.setSourceName(this.getImportResource().getImporterReference().getTitle());
        this.setTitle((String)initParameters[1]);
        this.logger.info((Object)("starting resource intialization " + this.getId()));
        this.setTotalLine(this.getImportResource().getImporterReference().getTotalLines());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        final DBSession session = DBSession.connect();
        new Thread(new GuessingPrefetcher(this.getImportResource().getTable().getTableName(), this.getId(), this.getImportResource().getImporterReference().getColumnsDefinition())).start();
        Curation curation = new Curation(this.getId());
        curation.setTitle(this.getTitle());
        curation.setDescription((String)initParameters[2]);
        curation.setCreator((String)initParameters[3]);
        curation.setSourceId(this.getSourceId());
        curation.setSourceName(this.getSourceName());
        curation.setDate(new Timestamp(System.currentTimeMillis()));
        curation.setLength(this.getImportResource().getImporterReference().getTotalLines());
        curation.setType(this.getImportResource().getImporterReference().getType());
        curation.setPublisher(this.getImportResource().getImporterReference().getPublisher());
        curation.setRights(this.getImportResource().getImporterReference().getRights());
        curation.setScope(ServiceContext.getContext().getScope().toString());
        curation.store();
        CreateTableLike createLike = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
        createLike.setTableLike(this.getImportResource().getTable());
        createLike.setTableName(Constants.getCurationTable(this.getId()));
        this.logger.trace((Object)createLike.getExpression());
        this.table = createLike.execute(session);
        this.history = new CurationHistory(this.getId(), this.getSourceId(), this.getSourceName(), now, (String)initParameters[3]);
        this.history.store();
        this.columnDefinition = this.getImportResource().getImporterReference().getColumnsDefinition();
        this.setFieldLenght(this.getImportResource().getFieldLenght());
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
                        insert.setTable(CurationResource.this.table);
                        Select subquery = (Select)DBSession.getImplementation(Select.class);
                        subquery.setTables(new Table[]{CurationResource.this.getImportResource().getTable()});
                        insert.setSubQuery(subquery);
                        CurationResource.this.logger.trace((Object)insert.getExpression());
                        insert.execute(session);
                        CurationResource.this.setUnderCreationState("Close");
                    }
                    catch (Exception e) {
                        CurationResource.this.logger.error((Object)"error creating curation ", (Throwable)e);
                        CurationResource.this.setUnderCreationState("Error");
                        CurationResource.this.remove();
                        session.release();
                    }
                }
                finally {
                    session.release();
                }
            }
        }.start();
        this.logger.info((Object)("finished initialialization for the resource " + this.getId()));
    }

    public ImportResource getImportResource() throws NoSuchResourceException, ResourceException {
        ImportResource resource = (ImportResource)ImportContext.getPortTypeContext().getWSHome().find((ResourceKey)ImportContext.getPortTypeContext().makeKey(this.getSourceId()));
        return resource;
    }

    public void editDimension(String fieldId, String codelistId, String keyId) throws Exception {
        this.logger.trace((Object)("entering in edit mode with dimId " + codelistId + " fieldId " + fieldId + " keyId " + keyId));
        if (this.fieldEditor != null) {
            this.fieldEditor.dismiss();
        }
        this.fieldEditor = new DimensionEditor(this.getId(), fieldId, codelistId, keyId, this.getTable(), this.fieldLenght.get(fieldId), this.totalLine, this.checkDimension(codelistId, fieldId, keyId) == 0L);
        new Thread(){

            @Override
            public void run() {
                try {
                    CurationResource.this.fieldEditor.initialize();
                }
                catch (Exception e) {
                    CurationResource.this.fieldEditor.setIsUnderInitialization("Error");
                    CurationResource.this.fieldEditor.dismiss();
                    CurationResource.this.fieldEditor = null;
                }
            }
        }.start();
    }

    public void editRules(String fieldId) throws Exception {
        this.logger.trace((Object)("entering in rule edit mode with  fieldId " + fieldId));
        if (this.fieldEditor != null) {
            this.fieldEditor.dismiss();
        }
        this.fieldEditor = new RuleEditor(this.getId(), fieldId, this.getTable(), this.fieldLenght.get(fieldId), false, (List<Rule>)Curation.getCurationItem(this.getId()).getFieldRulesMapping().get(fieldId), this.getColumnDefinition(), new String[0]);
        new Thread(){

            @Override
            public void run() {
                try {
                    CurationResource.this.fieldEditor.initialize();
                }
                catch (Exception e) {
                    CurationResource.this.fieldEditor.setIsUnderInitialization("Error");
                    CurationResource.this.fieldEditor.dismiss();
                    CurationResource.this.fieldEditor = null;
                }
            }
        }.start();
    }

    public void editColumn(String fieldId, Type type) throws Exception {
        this.logger.trace((Object)("entering in column edit mode with fieldId " + fieldId + " type " + type.getType().toString()));
        if (this.fieldEditor != null) {
            this.fieldEditor.dismiss();
        }
        this.logger.debug((Object)("the fieldLength for the field is " + this.fieldLenght.get(fieldId)));
        this.fieldEditor = new ColumnEditor(this.getId(), fieldId, this.getTable(), this.fieldLenght.get(fieldId), false, type, new String[0]);
        new Thread(){

            @Override
            public void run() {
                try {
                    CurationResource.this.fieldEditor.initialize();
                }
                catch (Exception e) {
                    CurationResource.this.fieldEditor.setIsUnderInitialization("Error");
                    CurationResource.this.fieldEditor.dismiss();
                    CurationResource.this.fieldEditor = null;
                }
            }
        }.start();
    }

    public long getCount(boolean onlyErrors) throws Exception {
        this.logger.info((Object)("is under editing?" + (this.getFieldEditor() != null)));
        if (onlyErrors) {
            if (this.isUnderEdit()) {
                return this.fieldEditor.errorCount();
            }
            throw new GCUBEFault(new String[]{"edit not ready"});
        }
        if (this.isUnderEdit()) {
            return this.fieldEditor.totalCount();
        }
        this.table.initializeCount();
        return this.table.getCount();
    }

    public String getDataAsJson(Select query, boolean onlyErrors) throws Exception {
        if (this.fieldEditor == null) {
            query.setTables(new Table[]{this.getTable()});
            return query.getResultAsJSon(true, new boolean[0]);
        }
        return this.fieldEditor.getResultAsJson(query, onlyErrors);
    }

    public String getId() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_ID).get(0);
    }

    public String getSourceId() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_SOURCEID).get(0);
    }

    public String getSourceName() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_SOURCENAME).get(0);
    }

    public String getTitle() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_TITLE).get(0);
    }

    public synchronized void setTitle(String title) throws ResourceException {
        this.getResourcePropertySet().get(RP_TITLE).clear();
        this.getResourcePropertySet().get(RP_TITLE).add((Object)title);
    }

    public synchronized void setId(String id) throws ResourceException {
        this.getResourcePropertySet().get(RP_ID).clear();
        this.getResourcePropertySet().get(RP_ID).add((Object)id);
    }

    public synchronized void setSourceId(String sourceId) throws ResourceException {
        this.getResourcePropertySet().get(RP_SOURCEID).clear();
        this.getResourcePropertySet().get(RP_SOURCEID).add((Object)sourceId);
    }

    public synchronized void setSourceName(String sourceName) throws ResourceException {
        this.getResourcePropertySet().get(RP_SOURCENAME).clear();
        this.getResourcePropertySet().get(RP_SOURCENAME).add((Object)sourceName);
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public boolean isUnderEdit() {
        return this.fieldEditor != null;
    }

    public Edit getFieldEditor() {
        return this.fieldEditor;
    }

    public void setFieldEditor(Edit fieldEditor) {
        this.fieldEditor = fieldEditor;
    }

    public ColumnDefinition[] getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(ColumnDefinition[] columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void saveColumnDefinition() throws Exception {
        if (this.getFieldEditor() != null) {
            this.getFieldEditor().save();
            ColumnDefinition oldColumnDefinition = Operation.getColumnDefinitionReference(this.fieldEditor.getFieldId(), this.columnDefinition);
            this.logger.debug((Object)("the fieldLength for field " + this.getFieldEditor().getFieldId() + " is " + this.getFieldEditor().getFieldLength()));
            this.fieldLenght.put(this.getFieldEditor().getFieldId(), this.getFieldEditor().getFieldLength());
            this.setColumnDefinitionReference(this.getFieldEditor().getFieldId(), this.fieldEditor.getTemporaryColumnDefinition(oldColumnDefinition));
            for (CurationHistoryItem item : this.fieldEditor.getHistoryItems()) {
                this.history.addItem(item);
            }
        } else {
            throw new GCUBEFault(new String[]{"the service is not in edit mode"});
        }
        this.closeEditing();
    }

    private ColumnDefinition getColumnDefinitionReference(String fieldId) throws Exception {
        ColumnDefinition[] columnDefinitionArray = this.columnDefinition;
        int n = this.columnDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition def = columnDefinitionArray[n2];
            if (def.getId().compareTo(fieldId) == 0) {
                return def;
            }
            ++n2;
        }
        throw new Exception("fieldId not found");
    }

    private void setColumnDefinitionReference(String fieldId, ColumnDefinition columnDefintion) throws Exception {
        int i = 0;
        while (i < this.columnDefinition.length) {
            if (this.columnDefinition[i].getId().compareTo(fieldId) == 0) {
                this.columnDefinition[i] = columnDefintion;
                return;
            }
            ++i;
        }
        throw new Exception("fieldId not found");
    }

    public GuessDimensionArray guess(String fieldId) throws Exception {
        try {
            GuessDimensionArray toReturn = GuessingPrefetcher.getGuessing(this.getId(), fieldId);
            if (toReturn != null) {
                return toReturn;
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("guesser prefetching not ready for id " + this.getId()), (Throwable)e);
        }
        this.logger.trace((Object)("guesser prefetching not ready for id " + this.getId()));
        return GuessingPrefetcher.guess(this.table.getTableName(), fieldId);
    }

    public void setLabel(String fieldId, String label) throws Exception {
        ColumnDefinition ref = this.getColumnDefinitionReference(fieldId);
        ref.setLabel(label);
    }

    public void remove() {
        try {
            if (this.fieldEditor != null) {
                this.fieldEditor.dismiss();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error dismissing fieldEditor", (Throwable)e);
        }
        try {
            DBSession session = DBSession.connect();
            DropTable dropTable = (DropTable)DBSession.getImplementation(DropTable.class);
            dropTable.setTableName(this.getTable().getTableName());
            dropTable.execute(session);
            session.release();
        }
        catch (Exception e) {
            this.logger.error((Object)"error deleting table", (Throwable)e);
        }
        try {
            ObjectPersistency.get(Curation.class).deleteByKey((Object)this.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)"error deleting entry in curation table", (Throwable)e);
        }
        try {
            ObjectPersistency.get(GuessingObject.class).deleteByKey((Object)this.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)"error deleting guessing entry in curation table", (Throwable)e);
        }
    }

    public Status getUnderCreationState() {
        return this.underCreationState;
    }

    public void setUnderCreationState(Status underCreationState) {
        this.underCreationState = underCreationState;
    }

    public void setUnderCreationState(String underCreationState) {
        this.underCreationState = Status.fromString((String)underCreationState);
    }

    public Map<String, int[]> getFieldLenght() {
        return this.fieldLenght;
    }

    public void setFieldLenght(Map<String, int[]> fieldLenght) {
        this.fieldLenght = fieldLenght;
    }

    public Status getInitializeEditingState() throws Exception {
        if (this.fieldEditor != null) {
            return this.fieldEditor.getIsUnderInitialization();
        }
        throw new Exception("you are not in edit mode");
    }

    protected void onRemove() throws ResourceException {
        this.remove();
        super.onRemove();
    }

    public void setColumn(EntryType columnType, String fieldId) throws Exception {
        ColumnDefinition def = this.getColumnDefinitionReference(fieldId);
        def.setDimension(null);
        def.setColumnType(columnType);
        def.setKey(null);
        if (columnType == EntryType.Undefined) {
            if (((Type)this.table.getFieldsMapping().get(fieldId)).getType() != Util.mapJavaToSql(DataType.Text)) {
                this.modifyColumnType(fieldId, DataType.Text, this.getFieldLenght().get(fieldId));
                def.setValueType(DataType.Text);
            }
            this.logger.debug((Object)"setColumnAs: changing nothing in the data type");
        }
        this.history.addItem(new CurationHistoryItem("", "saved column " + this.getColumnDefinitionReference(fieldId).getLabel() + " to type " + columnType.toString(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.COLUMN_TYPE_SET));
    }

    public void replaceById(String oldId, String newId, String fieldId) throws Exception {
        if (this.fieldEditor == null) {
            block11: {
                if (this.getColumnDefinitionReference(fieldId).getColumnType() != EntryType.Dimension) {
                    this.logger.error((Object)"replaceById error: the field MUST be a dimension");
                    throw new Exception("replaceById error: the field MUST be a dimension");
                }
                this.logger.debug((Object)"replacing a Id in a column currently not under editing");
                DBSession session = DBSession.connect();
                try {
                    CodeList codelist = CodeList.get((String)this.getColumnDefinitionReference(fieldId).getDimension().getId());
                    String dimTableName = codelist.getTable().getTableName();
                    String codeField = codelist.getCodeColumnId();
                    Type codeType = (Type)codelist.getTable().getFieldsMapping().get(codeField);
                    CastObject idCast = Utility.getCast((String)newId, (Type)codeType);
                    Select retrieveIdQuery = (Select)DBSession.getImplementation(Select.class);
                    SimpleTable dimensionTable = new SimpleTable(dimTableName);
                    retrieveIdQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.getColumnDefinitionReference(fieldId).getKey().getName())});
                    retrieveIdQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(codeField), (Object)idCast, "="));
                    retrieveIdQuery.setTables(new Table[]{dimensionTable});
                    ResultSet retrieveIdQueryRes = retrieveIdQuery.getResults(session, new boolean[0]);
                    if (retrieveIdQueryRes.next()) {
                        String newValue = retrieveIdQueryRes.getString(0);
                        Type fieldType = (Type)this.getTable().getFieldsMapping().get(fieldId);
                        if (newValue.length() > this.fieldLenght.get(fieldId)[0]) {
                            this.modifyColumnType(fieldId, Util.mapSqlToJava(fieldType.getType()), newValue.length());
                            int precisionFloat = 0;
                            if (newValue.contains(".")) {
                                precisionFloat = newValue.split("\\.")[1].length();
                            }
                            this.fieldLenght.put(fieldId, new int[]{newValue.length(), precisionFloat});
                        }
                        Update updateQuery = (Update)DBSession.getImplementation(Update.class);
                        updateQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(String.valueOf(fieldId) + ID_COLUMN_SUFFIX), (Object)new Long(oldId), "="));
                        CastObject cast = Utility.getCast((String)newValue, (Type)fieldType);
                        updateQuery.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "="), new OperatorCondition((Object)new SimpleAttribute(String.valueOf(fieldId) + ID_COLUMN_SUFFIX), (Object)idCast, "=")});
                        updateQuery.setTable((Table)this.table);
                        updateQuery.execute(session);
                        break block11;
                    }
                    throw new ValueNotCompatibleFault();
                }
                finally {
                    session.release();
                }
            }
            this.history.addItem(new CurationHistoryItem("", "replaced value where id was " + oldId + " in field  " + this.getColumnDefinitionReference(fieldId).getLabel(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REPLACE_BY_ID));
        } else {
            if (this.fieldEditor.getFieldId().compareTo(fieldId) != 0) {
                this.fieldEditor.replaceDistinctIds(fieldId, oldId, newId, this.getColumnDefinitionReference(fieldId).getKey().getName());
            } else {
                this.fieldEditor.replaceIds(fieldId, oldId, newId);
            }
            ((LinkedList)this.fieldEditor.getHistoryItems()).add(new CurationHistoryItem("", "replaced value where id was " + oldId + " in field  " + this.getColumnDefinitionReference(fieldId).getLabel(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REPLACE_BY_ID));
        }
    }

    public void replaceByValue(String oldValue, String newValue, String fieldId) throws Exception {
        if (this.fieldEditor == null) {
            if (this.getColumnDefinitionReference(fieldId).getColumnType() == EntryType.Dimension) {
                this.logger.error((Object)"A dimension field is not modifiable by value");
                throw new Exception("A dimension field is not modifiable by value");
            }
            DBSession session = DBSession.connect();
            this.logger.info((Object)"modifying a column currently not under editing");
            Type fieldType = (Type)this.getTable().getFieldsMapping().get(fieldId);
            if (newValue.length() > this.fieldLenght.get(fieldId)[0] || ImportUtil.getAfterDotLength((String)newValue) > this.fieldLenght.get(fieldId)[1]) {
                int valueLength = this.fieldLenght.get(fieldId)[0];
                if (newValue.toString().length() > this.fieldLenght.get(fieldId)[0]) {
                    valueLength = newValue.toString().length();
                }
                int precisionFloat = this.fieldLenght.get(fieldId)[1];
                if (ImportUtil.getAfterDotLength((String)newValue.toString()) > this.fieldLenght.get(fieldId)[1]) {
                    precisionFloat = ImportUtil.getAfterDotLength((String)newValue.toString());
                }
                this.fieldLenght.put(fieldId, new int[]{valueLength, precisionFloat});
                this.modifyColumnType(fieldId, Util.mapSqlToJava(fieldType.getType()), this.fieldLenght.get(fieldId));
            }
            Update updateQuery = (Update)DBSession.getImplementation(Update.class);
            CastObject oldValueCast = Utility.getCast((String)oldValue, (Type)fieldType);
            updateQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)oldValueCast, "="));
            CastObject newValueCast = Utility.getCast((String)newValue, (Type)fieldType);
            updateQuery.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)newValueCast, "=")});
            updateQuery.setTable((Table)this.table);
            updateQuery.execute(session);
            session.release();
            this.history.addItem(new CurationHistoryItem("", "replaced value where value was " + oldValue + " with " + newValue + " in field  " + this.getColumnDefinitionReference(fieldId).getLabel(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REPLACE_BY_VALUE));
        } else {
            this.fieldEditor.replaceDistinctValue(fieldId, newValue, oldValue);
            ((LinkedList)this.fieldEditor.getHistoryItems()).add(new CurationHistoryItem("", "replaced value where value was " + oldValue + " with " + newValue + " in field  " + this.getColumnDefinitionReference(fieldId).getLabel(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REPLACE_BY_VALUE));
        }
    }

    public ColumnDefinition columnInEditMode() throws Exception {
        if (this.fieldEditor == null) {
            throw new Exception("the service is not in edit mode");
        }
        ColumnDefinition def = this.getColumnDefinitionReference(this.getFieldEditor().getFieldId());
        return this.fieldEditor.getTemporaryColumnDefinition(def);
    }

    public long getTotalLine() {
        return this.totalLine;
    }

    public void setTotalLine(int totalLine) {
        this.totalLine = totalLine;
    }

    public void removeColumn(String fieldId) throws Exception {
        String fieldLabel;
        if (this.fieldEditor != null) {
            throw new Exception("a column cannot be removed in edit mode");
        }
        DBSession session = DBSession.connect();
        try {
            try {
                fieldLabel = this.getColumnDefinitionReference(fieldId).getLabel();
                Utility.dropColumn((String)fieldId, (Table)this.table).execute(session);
                if (this.getColumnDefinitionReference(fieldId).getColumnType().equals((Object)EntryType.Dimension)) {
                    Utility.dropColumn((String)(String.valueOf(fieldId) + ID_COLUMN_SUFFIX), (Table)this.table).execute(session);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("the fieldId " + fieldId + " does not exist in the table"));
                throw new Exception("the fieldId " + fieldId + " does not exist in the table", e);
            }
        }
        finally {
            session.release();
        }
        ArrayList<ColumnDefinition> newColumnDefinitionArray = new ArrayList<ColumnDefinition>(this.getColumnDefinition().length - 1);
        ColumnDefinition[] columnDefinitionArray = this.getColumnDefinition();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            if (columnDefinition.getId().compareTo(fieldId) != 0) {
                newColumnDefinitionArray.add(columnDefinition);
            }
            ++n2;
        }
        this.setColumnDefinition(newColumnDefinitionArray.toArray(new ColumnDefinition[this.getColumnDefinition().length - 1]));
        Curation cur = Curation.getCurationItem(this.getId());
        cur.removeAllRulesForField(fieldId);
        cur.store();
        this.history.addItem(new CurationHistoryItem("", "removed column " + fieldLabel, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REMOVE_COLUMN));
    }

    public long checkDimension(String dimensionId, String fieldId, String keyId) throws Exception {
        DBSession session = DBSession.connect();
        try {
            CodeList codelist = CodeList.get((String)dimensionId);
            SimpleTable dimensionTable = codelist.getTable();
            String curationTableAlias = "curtab";
            String dimensionTableAlias = "dimtab";
            String countAlias = "count";
            Select goodCellsCount = (Select)DBSession.getImplementation(Select.class);
            goodCellsCount.setAttributes(new Attribute[]{new AssignedAttribute(new SimpleAttribute("count"), (Object)new AggregatedAttribute(keyId, AggregationFunctions.COUNT)), new SimpleAttribute(keyId)});
            goodCellsCount.setTables(new Table[]{dimensionTable});
            goodCellsCount.setGroups(new SimpleAttribute[]{new SimpleAttribute(keyId)});
            Select totalCorrectCount = (Select)DBSession.getImplementation(Select.class);
            totalCorrectCount.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            CastObject fieldCastToString = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(fieldId, "curtab"));
            CastObject dimCastToString = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(keyId, "dimtab"));
            totalCorrectCount.setFilter((Condition)new ANDCondition(new Condition[]{new OperatorCondition((Object)fieldCastToString, (Object)dimCastToString, "="), new OperatorCondition((Object)new SimpleAttribute("count", "dimtab"), (Object)1, "=")}));
            totalCorrectCount.setTables(new Table[]{new Table(this.table.getTableName(), "curtab"), new TableFromSubselect("dimtab", (Selection)goodCellsCount)});
            this.logger.trace((Object)totalCorrectCount.getExpression());
            ResultSet totalCorrectRes = totalCorrectCount.getResults(session, new boolean[0]);
            totalCorrectRes.next();
            long size = this.getCount(false) - totalCorrectRes.getLong(1);
            this.logger.debug((Object)("the dimension check count is " + size));
            long l = size;
            return l;
        }
        finally {
            session.release();
        }
    }

    public long checkRules(String fieldId, FilterCondition[] filters) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            String TABLE_ALIAS = "tableAlias";
            select.setTables(new Table[]{new Table(this.table.getTableName(), "tableAlias")});
            Condition[] conditions = new Condition[filters.length];
            int i = 0;
            while (i < filters.length) {
                conditions[i] = FilterExplorer.getCondition(filters[i], this.getColumnDefinition(), "tableAlias", fieldId);
                ++i;
            }
            select.setFilter((Condition)new NOTCondition((Condition)new ANDCondition(conditions)));
            ResultSet result = select.getResults(session, new boolean[0]);
            result.next();
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public long checkTypeChange(String fieldId, Type newType) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            select.setTables(new Table[]{this.table});
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(fieldId), (Type)newType);
            cast.setUseCastFunction(true);
            OperatorCondition cond = new OperatorCondition((Object)cast, null, " IS ");
            select.setFilter((Condition)cond);
            this.logger.debug((Object)("checking query is " + select.getExpression()));
            ResultSet result = select.getResults(session, new boolean[0]);
            result.next();
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public void closeEditing() throws Exception {
        this.logger.debug((Object)"closing the edit mode");
        if (this.fieldEditor != null) {
            this.fieldEditor.dismiss();
            this.fieldEditor = null;
            this.store();
        }
    }

    public void modifyEntryValue(String fieldId, String newValue, long rowId) throws Exception {
        if (this.fieldEditor == null) {
            if (this.getColumnDefinitionReference(fieldId).getColumnType() == EntryType.Dimension) {
                this.logger.error((Object)"A dimension field is not modifiable by value");
                throw new Exception("A dimension field is not modifiable by value");
            }
            this.logger.info((Object)"modifying a column currently not under editing using modifyEntryValue");
            DBSession session = DBSession.connect();
            Iterator<Rule> ruleIt = this.applyedRules(fieldId);
            Select select = (Select)DBSession.getImplementation(Select.class);
            ArrayList<Object> conditions = new ArrayList<Object>();
            CastObject valueCast = Utility.getCast((String)newValue.toString(), (Type)((Type)this.table.getFieldsMapping().get(fieldId)));
            conditions.add(new OperatorCondition((Object)valueCast, null, " IS NOT "));
            while (ruleIt.hasNext()) {
                Rule rule = ruleIt.next();
                conditions.add(FilterExplorer.getConditionUsingValue(rule.getFilter(), valueCast));
            }
            select.setAttributes(new Attribute[]{new BooleanAttribute("field", (Condition)new ANDCondition(conditions.toArray(new Condition[conditions.size()])))});
            this.logger.debug((Object)("checking the new value: " + select.getExpression()));
            if (conditions.size() > 0) {
                ResultSet rs = select.getResults(session, new boolean[0]);
                rs.next();
                if (!rs.getBoolean(1)) {
                    this.logger.warn((Object)("the new value " + newValue + " is not compatible with the applyed rules"));
                    throw new ValueNotCompatibleFault();
                }
            }
            Type fieldType = (Type)this.getTable().getFieldsMapping().get(fieldId);
            if (newValue.length() > this.fieldLenght.get(fieldId)[0] || ImportUtil.getAfterDotLength((String)newValue) > this.fieldLenght.get(fieldId)[1]) {
                int valueLength = this.fieldLenght.get(fieldId)[0];
                if (newValue.toString().length() > this.fieldLenght.get(fieldId)[0]) {
                    valueLength = newValue.length();
                }
                int precisionFloat = this.fieldLenght.get(fieldId)[1];
                if (ImportUtil.getAfterDotLength((String)newValue) > this.fieldLenght.get(fieldId)[1]) {
                    precisionFloat = ImportUtil.getAfterDotLength((String)newValue);
                }
                this.fieldLenght.put(fieldId, new int[]{valueLength, precisionFloat});
                this.modifyColumnType(fieldId, Util.mapSqlToJava(fieldType.getType()), this.fieldLenght.get(fieldId));
                this.logger.trace((Object)("the new precision for " + fieldId + " is " + valueLength + "," + precisionFloat));
            }
            Update updateQuery = (Update)DBSession.getImplementation(Update.class);
            updateQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute("ID"), (Object)new Long(rowId), "="));
            CastObject cast = Utility.getCast((String)newValue, (Type)fieldType);
            updateQuery.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "=")});
            updateQuery.setTable((Table)this.table);
            this.logger.debug((Object)("update query is " + updateQuery.getExpression()));
            updateQuery.execute(session);
            session.release();
            this.history.addItem(new CurationHistoryItem("", "modified value of field " + this.getColumnDefinitionReference(fieldId).getLabel() + " where row id is " + rowId + " with " + newValue, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.MODIFY_VALUE));
        } else {
            this.fieldEditor.replaceValue((int)rowId, newValue);
        }
    }

    public String getPossibleValues(String word) throws Exception {
        if (!this.isUnderEdit()) {
            throw new Exception("service not in edit mode");
        }
        return this.fieldEditor.getPossibleValues(word);
    }

    public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception {
        if (this.fieldEditor == null) {
            if (this.getColumnDefinitionReference(fieldId).getColumnType() != EntryType.Dimension) {
                this.logger.error((Object)"It MUST be a dimension field");
                throw new Exception("It MUST be a dimension field");
            }
            this.logger.info((Object)"modifying a dimension column currently not under editing");
            CodeList codelist = CodeList.get((String)this.getColumnDefinitionReference(fieldId).getDimension().getId());
            String dimTableName = codelist.getTable().getTableName();
            String codeField = codelist.getCodeColumnId();
            Type codeType = (Type)codelist.getTable().getFieldsMapping().get(codeField);
            DBSession session = DBSession.connect();
            Select retrieveValueQuery = (Select)DBSession.getImplementation(Select.class);
            CastObject idCast = Utility.getCast((String)newId, (Type)codeType);
            retrieveValueQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.getColumnDefinitionReference(fieldId).getKey().getId())});
            retrieveValueQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(codeField), (Object)idCast, "="));
            retrieveValueQuery.setTables(new Table[]{new Table(dimTableName)});
            ResultSet retrieveValueRes = retrieveValueQuery.getResults(session, new boolean[0]);
            if (!retrieveValueRes.next()) {
                session.release();
                throw new ValueNotCompatibleFault();
            }
            String newValue = retrieveValueRes.getString(1);
            Type fieldType = (Type)this.getTable().getFieldsMapping().get(fieldId);
            Update updateQuery = (Update)DBSession.getImplementation(Update.class);
            updateQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute("ID"), (Object)new Long(rowId), "="));
            CastObject cast = Utility.getCast((String)newValue, (Type)fieldType);
            updateQuery.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "="), new OperatorCondition((Object)new SimpleAttribute(String.valueOf(fieldId) + ID_COLUMN_SUFFIX), (Object)idCast, "=")});
            updateQuery.setTable((Table)this.table);
            updateQuery.execute(session);
            session.release();
            this.history.addItem(new CurationHistoryItem("", "modified reference ID of field " + this.getColumnDefinitionReference(fieldId).getLabel() + " where row id is " + rowId + " with " + newId, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.MODIFY_ID));
        } else {
            if (this.fieldEditor.getFieldId().compareTo(fieldId) == 0) {
                this.fieldEditor.modifyEntryId(fieldId, newId, rowId);
            } else {
                this.fieldEditor.modifyDistinctEntryId(fieldId, newId, rowId, this.getColumnDefinitionReference(fieldId).getDimension().getId(), this.getColumnDefinitionReference(fieldId).getKey().getName());
            }
            ((LinkedList)this.fieldEditor.getHistoryItems()).add(new CurationHistoryItem("", "modified reference ID of field " + this.getColumnDefinitionReference(fieldId).getLabel() + " where row id is " + rowId + " with " + newId, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.MODIFY_ID));
        }
    }

    public void removeAllErrors() throws Exception {
        if (!this.isUnderEdit()) {
            throw new GCUBEFault(new String[]{"the service is not in edit mode"});
        }
        this.fieldEditor.removeAllErrors();
        ((LinkedList)this.fieldEditor.getHistoryItems()).add(new CurationHistoryItem("", "removed all errors from field " + this.getColumnDefinitionReference(this.fieldEditor.getFieldId()).getLabel(), new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REMOVE_ALL_ERRORS));
    }

    public void removeError(long rowId) throws Exception {
        if (this.isUnderEdit()) {
            this.fieldEditor.removeSingleError(rowId);
            --this.totalLine;
        } else {
            throw new GCUBEFault(new String[]{"the service is not in edit mode"});
        }
        Curation curation = Curation.getCurationItem(this.getId());
        curation.setLength(this.totalLine);
        ((LinkedList)this.fieldEditor.getHistoryItems()).add(new CurationHistoryItem("", "removed error from field " + this.getColumnDefinitionReference(this.fieldEditor.getFieldId()).getLabel() + " where row ID is " + rowId, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.REMOVE_ERROR));
    }

    public CurationHistory getHistory() {
        return this.history;
    }

    public void setHistory(CurationHistory history) {
        this.history = history;
    }

    public void setTable(SimpleTable table) {
        this.table = table;
    }

    private void modifyColumnType(String fieldId, DataType dataType, int ... precision) throws Exception {
        ModifyColumnType modifyCol = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
        modifyCol.setTable((Table)this.table);
        modifyCol.setColumn(new SimpleAttribute(fieldId));
        this.logger.debug((Object)("the precision array in the field mapping for " + fieldId + " is " + ((Type)this.table.getFieldsMapping().get(fieldId)).getPrecisionArray()));
        Type.Types types = Util.mapJavaToSql(dataType);
        Type newType = types == Type.Types.FLOAT || types == Type.Types.TEXT || types == Type.Types.BOOLEAN || types == Type.Types.TIME || types == Type.Types.DATE ? new Type(Util.mapJavaToSql(dataType), new int[0]) : new Type(Util.mapJavaToSql(dataType), precision);
        modifyCol.setNewType(newType);
        modifyCol.setUseCast(((Type)this.table.getFieldsMapping().get(fieldId)).getType() != types);
        DBSession session = null;
        try {
            session = DBSession.connect();
            this.logger.debug((Object)("modifyColumnQuery: " + modifyCol.getExpression()));
            modifyCol.execute(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public void applyRules(RuleItem[] rules, String fieldId) throws Exception {
        Curation curation = Curation.getCurationItem(this.getId());
        RuleItem[] ruleItemArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            RuleItem rule = ruleItemArray[n2];
            curation.addRuleToField(fieldId, new Rule(rule.getName(), rule.getDescription(), FilterExplorer.generateRulesDescription(rule.getFilter()).toString(), rule.getFilter(), Util.mapJavaToSql(rule.getType())));
            ++n2;
        }
        curation.store();
    }

    public Iterator<Rule> applyedRules(String fieldID) throws Exception {
        Curation curation = Curation.getCurationItem(this.getId());
        if (curation.getFieldRulesMapping().get(fieldID) == null) {
            return new ArrayList().iterator();
        }
        return curation.getFieldRulesMapping().get(fieldID).iterator();
    }

    public Iterator<Rule> applyableRules(String fieldId) throws Exception {
        Type.Types type = Util.mapJavaToSql(this.getColumnDefinitionReference(fieldId).getValueType());
        return Rule.getByType(type);
    }

    public void removeAllRules(String fieldId) throws Exception {
        Curation curation = Curation.getCurationItem(this.getId());
        curation.getFieldRulesMapping().remove(fieldId);
        curation.store();
    }

    public void setProperties(String title, String description, String publisher, String rights) throws Exception {
        Curation curation = Curation.getCurationItem(this.getId());
        curation.setTitle(title);
        curation.setDescription(description);
        curation.setPublisher(publisher);
        curation.setRights(rights);
        curation.store();
    }
}

