/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.history;

import java.util.Date;
import java.util.LinkedList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;

@TableRootDefinition
public class CurationHistory {
    private static GCUBELog logger = new GCUBELog(CurationHistory.class);
    @FieldDefinition
    private LinkedList<CurationHistoryItem> items;
    private String query;
    @FieldDefinition(precision={200}, specifications={Specification.NOT_NULL})
    private String creator;
    @FieldDefinition(precision={200}, specifications={Specification.NOT_NULL})
    private String parentTitle;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String csvParentId;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private Date date;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;

    public CurationHistory(String id, String parentCSVId, String parentTitle, Date historyCreationDate, String creator) throws Exception {
        this.id = id;
        this.date = historyCreationDate;
        this.items = new LinkedList();
        this.csvParentId = parentCSVId;
        this.parentTitle = parentTitle;
        this.creator = creator;
        logger.trace((Object)"curation history created");
    }

    private CurationHistory() {
    }

    public String getQuery() {
        return this.query;
    }

    public Date getDate() {
        return this.date;
    }

    public String getCsvParentId() {
        return this.csvParentId;
    }

    public LinkedList<CurationHistoryItem> getItems() {
        return this.items;
    }

    protected void setItems(LinkedList<CurationHistoryItem> items) {
        this.items = items;
    }

    public String getParentTitle() {
        return this.parentTitle;
    }

    public void setParentTitle(String parentTitle) {
        this.parentTitle = parentTitle;
    }

    public String getId() {
        return this.id;
    }

    public void addItem(CurationHistoryItem item) throws Exception {
        this.getItems().add(item);
        this.store();
    }

    public static CurationHistory retrieveHistory(String id) throws Exception {
        return (CurationHistory)ObjectPersistency.get(CurationHistory.class).getByKey((Object)id);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void store() throws Exception {
        ObjectPersistency op = ObjectPersistency.get(CurationHistory.class);
        if (!op.existsKey((Object)this.getId())) {
            op.insert((Object)this);
        } else {
            op.update((Object)this);
        }
    }

    public void destroy() throws Exception {
        ObjectPersistency.get(CurationHistory.class).deleteByKey((Object)this.id);
    }
}

