/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.importer.state;

import java.util.Map;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.globus.wsrf.ResourceException;

public class ImportResource
extends GCUBEWSResource {
    protected static final String RP_ID = "Id";
    protected static String[] RPNames = new String[]{"Id"};
    private SimpleTable table;
    private Map<String, int[]> fieldLenght;
    private ImporterItem importer;
    private String[] tableDefinition;

    public String[] getPropertyNames() {
        return RPNames;
    }

    protected void initialise(Object ... initParameters) throws Exception {
        this.setId((String)initParameters[0]);
        this.importer = new ImporterItem((GCUBEWSResourceKey)this.getID(), this.getScope());
        this.importer.setId((String)initParameters[0]);
        this.importer.setTitle((String)initParameters[1]);
        this.importer.setCreator((String)initParameters[3]);
        this.importer.setDescription((String)initParameters[2]);
        this.importer.setPublisher((String)initParameters[4]);
        this.importer.setRights((String)initParameters[5]);
        this.importer.setSource((String)initParameters[6]);
        this.importer.setType((String)initParameters[7]);
        this.importer.setStatus(Status.Open);
        this.table = null;
    }

    public String getId() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_ID).get(0);
    }

    public synchronized void setId(String id) throws ResourceException {
        this.getResourcePropertySet().get(RP_ID).clear();
        this.getResourcePropertySet().get(RP_ID).add((Object)id);
    }

    public ImporterItem getImporterReference() throws ResourceException {
        if (this.importer == null) {
            try {
                this.importer = (ImporterItem)ObjectPersistency.get(ImporterItem.class).getByKey((Object)this.getId());
            }
            catch (Exception e) {
                this.logger.warn((Object)("error retriving importer for ts " + this.getId()));
            }
        }
        return this.importer;
    }

    protected void onRemove() throws ResourceException {
        this.remove();
        super.onRemove();
    }

    public void remove() throws ResourceException {
        try {
            ObjectPersistency.get(ImporterItem.class).deleteByKey((Object)this.getId());
        }
        catch (ObjectNotFoundException oe) {
            this.logger.warn((Object)"the entry is not in the db (it is already removed?)");
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot remove entry from DB", (Throwable)e);
            throw new ResourceException((Throwable)e);
        }
    }

    public String[] getTableDefinition() {
        return this.tableDefinition;
    }

    public void setTableDefinition(String[] columnDefinition) {
        this.tableDefinition = columnDefinition;
    }

    public String getDataAsJson(Limit limit) throws Exception {
        Select selectQuery = (Select)DBSession.getImplementation(Select.class);
        selectQuery.setTables(new Table[]{this.getTable()});
        selectQuery.setLimit(new org.gcube.common.dbinterface.Limit(limit.getLowerLimit(), limit.getUpperLimit()));
        this.logger.trace((Object)selectQuery.getExpression());
        return this.getImporterReference().getDataAsJson(selectQuery);
    }

    public Map<String, int[]> getFieldLenght() {
        return this.fieldLenght;
    }

    public void setFieldLenght(Map<String, int[]> fieldLenght) {
        this.fieldLenght = fieldLenght;
    }

    public SimpleTable getTable() throws Exception {
        return this.table;
    }

    public void setTable(SimpleTable table) {
        this.table = table;
    }
}

