/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class Denormalization
extends Operation {
    private static final long serialVersionUID = -6565554460286543527L;
    private static GCUBELog logger = new GCUBELog(Denormalization.class);
    private String fieldIdValue;
    private String fieldIdAttribute;
    protected static final String PIVOT_PREFIX = "pivot_";

    public Denormalization() {
        this.type = OperationType.Denormalization;
        this.viewName = "d" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        logger.trace((Object)("denormalization with values: fieldIdValue " + this.fieldIdValue + " , " + this.fieldIdAttribute));
        ArrayList<ColumnDefinition> denormColumnDefinition = new ArrayList<ColumnDefinition>();
        ArrayList<SimpleAttribute> groupingAttributes = new ArrayList<SimpleAttribute>();
        ColumnDefinition[] columnDefinitionArray = previousTableDefinition;
        int n = previousTableDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition def = columnDefinitionArray[n2];
            if (def.getId().compareTo(this.fieldIdAttribute) != 0 && def.getId().compareTo(this.fieldIdValue) != 0) {
                groupingAttributes.add(new SimpleAttribute(def.getId()));
                if (def.getColumnType() == EntryType.Dimension) {
                    groupingAttributes.add(new SimpleAttribute(String.valueOf(def.getId()) + "_id"));
                }
                denormColumnDefinition.add(def);
            }
            ++n2;
        }
        SimpleTable previousTable = new SimpleTable(previuosTableName);
        Select selectQuery = (Select)DBSession.getImplementation(Select.class);
        selectQuery.setTables(new Table[]{previousTable});
        selectQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.fieldIdAttribute)});
        selectQuery.setUseDistinct(true);
        selectQuery.setOrders(new Order[]{new Order(Order.OrderType.ASC, (Attribute)new SimpleAttribute(this.fieldIdAttribute))});
        ResultSet distinctFieldAttributeRes = selectQuery.getResults(session, new boolean[0]);
        logger.trace((Object)"took attributes from ts");
        ArrayList<AssignedAttribute> pivotAttributes = new ArrayList<AssignedAttribute>();
        int pivot_idx = 0;
        while (distinctFieldAttributeRes.next()) {
            String pivotName = PIVOT_PREFIX + pivot_idx;
            CastObject cast = Utility.getCast((String)distinctFieldAttributeRes.getString(1), (Type)((Type)previousTable.getFieldsMapping().get(this.fieldIdAttribute)));
            pivotAttributes.add(new AssignedAttribute(new SimpleAttribute(pivotName), (Object)new SimpleAttribute(" SUM(CASE WHEN " + this.fieldIdAttribute + "=" + cast.getCast() + " THEN " + this.fieldIdValue + " ELSE 0 END ) ")));
            denormColumnDefinition.add(new ColumnDefinition(EntryType.Value, null, null, pivotName, null, distinctFieldAttributeRes.getString(1), Denormalization.getColumnDefinitionReference(this.fieldIdValue, previousTableDefinition).getValueType()));
            logger.trace((Object)("added pivot " + pivotName));
            ++pivot_idx;
        }
        logger.trace((Object)"adding the attributes list");
        ArrayList attributes = new ArrayList();
        Collections.addAll(attributes, groupingAttributes.toArray(new Attribute[0]));
        Collections.addAll(attributes, pivotAttributes.toArray(new Attribute[0]));
        Select pivotingQuery = (Select)DBSession.getImplementation(Select.class);
        pivotingQuery.setAttributes(attributes.toArray(new Attribute[0]));
        pivotingQuery.setTables(new Table[]{previousTable});
        this.setColumnDefinition(denormColumnDefinition.toArray(new ColumnDefinition[0]));
        pivotingQuery.setGroups(groupingAttributes.toArray(new SimpleAttribute[0]));
        this.createTable(pivotingQuery, session, false);
        logger.trace((Object)("denormalization query is:" + pivotingQuery.getExpression()));
        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insert.setSubQuery(pivotingQuery);
        insert.setTable(this.viewTable);
        logger.trace((Object)("insert query is " + insert.getExpression()));
        insert.execute(session);
        this.viewTable.initializeCount();
        this.setCount(this.viewTable.getCount());
        this.setHistoryItem(new TSHistoryItem(pivotingQuery.toString(), "denormalization applied at attribute field " + Denormalization.getColumnDefinitionReference(this.fieldIdAttribute, previousTableDefinition).getLabel() + " with value field " + Denormalization.getColumnDefinitionReference(this.fieldIdValue, previousTableDefinition).getLabel(), new Date(), OperationType.Denormalization));
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        this.fieldIdAttribute = (String)parameters[0];
        this.fieldIdValue = (String)parameters[1];
    }
}

