/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListImport;
import org.gcube.contentmanagement.timeseriesservice.calls.RSWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLImportItemWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLImportedItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromCsvRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportFromSdmxRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.AccessFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ItemNotFoundFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.TrasmissionFault;

public class CodelistImportManager {
    private static GCUBELog logger = new GCUBELog(CodelistImportManager.class);

    public String importFromCsv(final ImportFromCsvRequest request) throws GCUBEFault {
        File file;
        try {
            file = RSWrapper.getStreamFromLocator((URI)new URI(request.getRsLocator()));
        }
        catch (Exception e) {
            throw new TrasmissionFault();
        }
        if (file == null) {
            logger.error((Object)"file not found");
            throw new TrasmissionFault();
        }
        try {
            final CodeListImport importer = new CodeListImport();
            importer.setDescription(request.getDescription());
            importer.setName(request.getName());
            importer.store();
            Thread importThread = new Thread(){

                @Override
                public void run() {
                    importer.importCSV(file, request.getEncoding(), request.isHasHeader(), request.getDelimiter().charAt(0), true);
                }
            };
            ServiceContext.getContext().useServiceCredentials(new Thread[]{importThread});
            importThread.start();
            new CLImportItemWrapper(request.getOwner(), importer.getId(), ServiceContext.getContext().getScope()).store();
            logger.debug((Object)"import finished");
            return importer.getId();
        }
        catch (Exception e) {
            logger.error((Object)"error importing from csv", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public String importFromSdmx(ImportFromSdmxRequest request) throws GCUBEFault {
        try {
            final CodeListImport importer = new CodeListImport();
            logger.trace((Object)("the importer has been stored?" + importer.store()));
            if (request.getSdmxUri() != null) {
                final URI uri = new URI(request.getSdmxUri());
                Thread importThread = new Thread(){

                    @Override
                    public void run() {
                        importer.importSDMX(uri);
                    }
                };
                ServiceContext.getContext().useServiceCredentials(new Thread[]{importThread});
                importThread.start();
            } else {
                final File sdmxFile = RSWrapper.getStreamFromLocator((URI)new URI(request.getRsLocator()));
                Thread importThread = new Thread(){

                    @Override
                    public void run() {
                        importer.importSDMX(sdmxFile);
                        sdmxFile.delete();
                    }
                };
                ServiceContext.getContext().useServiceCredentials(new Thread[]{importThread});
                importThread.start();
            }
            new CLImportItemWrapper(request.getOwner(), importer.getId(), ServiceContext.getContext().getScope()).store();
            logger.debug((Object)"import finished");
            return importer.getId();
        }
        catch (Exception e) {
            logger.error((Object)"error importing from sdmx", (Throwable)e);
            throw new GCUBEFault();
        }
    }

    public CLImportedItemsArray getImportedCodelists(String user) throws GCUBEFault {
        ArrayList<CLImportedItem> clItems = new ArrayList<CLImportedItem>();
        try {
            Iterator<CLImportItemWrapper> clImportWrapperIterator = CLImportItemWrapper.getByUser(user);
            while (clImportWrapperIterator.hasNext()) {
                CLImportItemWrapper wrapperItem = clImportWrapperIterator.next();
                if (!wrapperItem.getScope().equals((Object)ServiceContext.getContext().getScope())) continue;
                try {
                    CodeListImport item = wrapperItem.getCodelist();
                    clItems.add(new CLImportedItem(item.getAgencyId(), item.getProgress(), item.getLastUpdate(), item.getDescription(), item.getId(), item.getName(), wrapperItem.getOwner(), wrapperItem.getStatus(), item.getVersion()));
                }
                catch (ObjectNotFoundException e) {
                    logger.warn((Object)("object with id " + wrapperItem.getCodelistId() + " not found"));
                    wrapperItem.remove();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error getting imported items", (Throwable)e);
            throw new GCUBEFault(new String[]{"error retrieving codelist imported items"});
        }
        return new CLImportedItemsArray(clItems.toArray(new CLImportedItem[clItems.size()]));
    }

    public ImportStatusResponse getImportStatus(CodelistIdentifier ide) throws GCUBEFault {
        try {
            ImportStatusResponse status = new ImportStatusResponse();
            CLImportItemWrapper clImportWrapper = CLImportItemWrapper.get(ide.getId());
            if (!clImportWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !ide.getUser().equals(clImportWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListImport clImport = clImportWrapper.getCodelist();
            logger.debug((Object)(" status: " + clImport.getStatus() + " totalLine: " + clImport.getTotalLines() + "   linecount:" + clImport.getProgress()));
            switch (clImport.getStatus()) {
                case Initialized: {
                    status.setStatus(Status.Initializing);
                    break;
                }
                case InProgress: {
                    status.setStatus(Status.Open);
                    break;
                }
                case Complete: {
                    status.setStatus(Status.Close);
                    break;
                }
                case Failed: {
                    status.setStatus(Status.Error);
                    break;
                }
                default: {
                    status.setStatus(Status.Open);
                }
            }
            status.setTotalLine(clImport.getTotalLines());
            status.setLineCount(clImport.getProgress());
            return status;
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error retrieving import status", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public String getDataAsJson(DataAsJsonRequest request) throws GCUBEFault {
        try {
            CLImportItemWrapper clImportWrapper = CLImportItemWrapper.get(request.getIdentifier().getId());
            if (!clImportWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clImportWrapper.getOwner())) {
                throw new AccessFault();
            }
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setTables(new Table[]{new Table(clImportWrapper.getCodelist().getTableName())});
            selectQuery.setLimit(new Limit(request.getLimit().getLowerLimit(), request.getLimit().getUpperLimit()));
            return selectQuery.getResultAsJSon(true, new boolean[0]);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CodelistColumnsDefinitionArray getColumnsDefinition(CodelistIdentifier identifier) throws GCUBEFault {
        ArrayList<CodelistColumnDefinition> columnDefinitionList = new ArrayList<CodelistColumnDefinition>();
        try {
            CLImportItemWrapper clImportWrapper = CLImportItemWrapper.get(identifier.getId());
            if (!clImportWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clImportWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListImport clImport = clImportWrapper.getCodelist();
            Object[] returnList = clImport.getFieldsName().values().toArray(new TableField[0]);
            Arrays.sort(returnList);
            Object[] objectArray = returnList;
            int n = returnList.length;
            int n2 = 0;
            while (n2 < n) {
                Object cd = objectArray[n2];
                columnDefinitionList.add(new CodelistColumnDefinition(CodelistColumnType.fromString((String)cd.getColumnReference().getType().toString()), Util.mapSqlToJava(cd.getDataType()), cd.getId(), cd.getFieldName(), cd.getColumnReference().getCodelistReferenceId()));
                ++n2;
            }
            return new CodelistColumnsDefinitionArray(columnDefinitionList.toArray(new CodelistColumnDefinition[columnDefinitionList.size()]));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting column definition", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean remove(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLImportItemWrapper clImportWrapper = CLImportItemWrapper.get(identifier.getId());
            if (!clImportWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clImportWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clImportWrapper.remove();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error removing imported codelist", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CLImportedItem getCLImportItem(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLImportItemWrapper clImportWrapper = CLImportItemWrapper.get(identifier.getId());
            if (!clImportWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clImportWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListImport clImport = clImportWrapper.getCodelist();
            return new CLImportedItem(clImport.getAgencyId(), clImport.getProgress(), clImport.getLastUpdate(), clImport.getDescription(), clImport.getId(), clImport.getName(), clImportWrapper.getOwner(), clImportWrapper.getStatus(), clImport.getVersion());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)("error getting imported item with id " + identifier.getId()), (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }
}

