/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing.GuessingObject;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimensionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;

public class GuessingPrefetcher
implements Runnable {
    private static GCUBELog logger = new GCUBELog(GuessingPrefetcher.class);
    private String tableName;
    private ColumnDefinition[] columnDefintionArray;
    private String resourceId;

    public GuessingPrefetcher(String tableName, String resourceId, ColumnDefinition[] columnDefintionArray) {
        this.columnDefintionArray = columnDefintionArray;
        this.tableName = tableName;
        this.resourceId = resourceId;
    }

    @Override
    public void run() {
        GuessingObject go;
        ObjectPersistency persistentGuessing;
        try {
            persistentGuessing = ObjectPersistency.get(GuessingObject.class);
            go = new GuessingObject(this.resourceId);
            persistentGuessing.insert((Object)go);
        }
        catch (Exception e) {
            logger.error((Object)"error persisting the guess results", (Throwable)e);
            return;
        }
        HashMap<String, GuessDimensionArray> table = new HashMap<String, GuessDimensionArray>(this.columnDefintionArray.length);
        ColumnDefinition[] columnDefinitionArray = this.columnDefintionArray;
        int n = this.columnDefintionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition cd = columnDefinitionArray[n2];
            logger.trace((Object)("starting guessing for " + cd.getId()));
            try {
                GuessDimensionArray dimArray = GuessingPrefetcher.guess(this.tableName, cd.getId());
                table.put(cd.getId(), dimArray);
                go.setGuessingMap(table);
                persistentGuessing.update((Object)go);
            }
            catch (Exception e) {
                logger.warn((Object)("cannot calculate guess for field " + cd.getId()), (Throwable)e);
            }
            ++n2;
        }
    }

    public static GuessDimensionArray guess(String tableName, String fieldId) throws Exception {
        logger.trace((Object)"starting the guessing method");
        ServiceContext.getContext().getGuesser().runGuesser(tableName, fieldId);
        ArrayList results = ServiceContext.getContext().getGuesser().getClassification();
        logger.trace((Object)("initliazed LexicalEngine and get back " + results.size() + " results for " + fieldId));
        ArrayList<GuessDimension> guessDimlist = new ArrayList<GuessDimension>();
        for (SingleResult res : results) {
            logger.trace((Object)(String.valueOf(res.getColumn()) + " " + res.getCategory() + " " + res.getScore()));
            GuessDimension dim = new GuessDimension();
            SimpleTable dimTable = new SimpleTable(res.getTablename());
            Type type = (Type)dimTable.getFieldsMapping().get(res.getColumn());
            try {
                String fieldName = ((TableField)CodeList.get((String)res.getFamilyID()).getLabelFieldMapping().get(res.getColumn())).getFieldName();
                dim.setDimension(new Dimension(res.getFamilyID(), new Key[]{new Key(res.getColumn(), fieldName, Util.mapSqlToJava(type.getType()))}, res.getCategory()));
                dim.setPercentage(res.getScore());
                guessDimlist.add(dim);
            }
            catch (Exception e) {
                logger.warn((Object)("result " + res.getColumn() + " | " + res.getCategory() + " cannot be retreived"));
            }
        }
        return new GuessDimensionArray(guessDimlist.toArray(new GuessDimension[guessDimlist.size()]));
    }

    public static GuessDimensionArray getGuessing(String resourceId, String fieldId) throws Exception {
        return ((GuessingObject)ObjectPersistency.get(GuessingObject.class).getByKey((Object)resourceId)).getGuessingMap().get(fieldId);
    }

    public static void deliteGuessing(String resourceId) throws Exception {
        ObjectPersistency.get(GuessingObject.class).deleteByKey((Object)resourceId);
    }
}

