/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.Edit;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.InvalidValueException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;

public class ColumnEditor
extends Edit {
    private static transient GCUBELog logger = new GCUBELog(ColumnEditor.class);
    private static final long serialVersionUID = 4411160417374524492L;
    private Type type;

    public ColumnEditor(String resourceId, String fieldId, SimpleTable resourceTable, int[] fieldLength, boolean withoutError, Type type, String ... rowIdLabel) {
        super(resourceId, fieldId, resourceTable, fieldLength, withoutError, rowIdLabel);
        this.type = type;
        if (this.type.getType() == Type.Types.FLOAT) {
            this.type.setPrecision(new int[]{fieldLength[0] + fieldLength[1], fieldLength[1]});
        } else {
            this.type.setPrecision(fieldLength);
        }
        this.editorType = Edit.TYPE.Column;
    }

    @Override
    public long check() throws Exception {
        DBSession session = null;
        try {
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            select.setTables(new Table[]{this.resourceTable});
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.type);
            cast.setUseCastFunction(true);
            OperatorCondition cond = new OperatorCondition((Object)cast, null, " IS ");
            select.setFilter((Condition)cond);
            ResultSet result = select.getResults(session, new boolean[0]);
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public void internalInitialize(DBSession session) throws Exception {
        CreateTableFromSelect createFromSelect = (CreateTableFromSelect)DBSession.getImplementation(CreateTableFromSelect.class);
        createFromSelect.setTableName(this.getCorrectsTableName());
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.resourceTable});
        CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.type);
        cast.setUseCastFunction(true);
        OperatorCondition cond = new OperatorCondition((Object)cast, null, " IS NOT ");
        select.setFilter((Condition)cond);
        logger.debug((Object)("query for correct : " + select.getExpression()));
        createFromSelect.setSelect(select);
        createFromSelect.setWithData();
        createFromSelect.execute(session);
        ModifyColumnType modifyColumn = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
        modifyColumn.setNewType(this.type);
        modifyColumn.setTable(new Table(this.getCorrectsTableName()));
        modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
        modifyColumn.setUseCast(true);
        modifyColumn.execute(session);
        CreateTableLike createTableLike = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
        createTableLike.setTableName(this.getWrongsTableName());
        createTableLike.setTableLike(this.resourceTable);
        SimpleTable wrongTable = createTableLike.execute(session);
        InsertFromSelect insertFromSelectQuery = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertFromSelectQuery.setTable(wrongTable);
        select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.resourceTable});
        cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.type);
        cast.setUseCastFunction(true);
        cond = new OperatorCondition((Object)cast, null, " IS ");
        select.setFilter((Condition)cond);
        logger.debug((Object)("query for wrong : " + select.getExpression()));
        insertFromSelectQuery.setSubQuery(select);
        insertFromSelectQuery.execute(session);
    }

    @Override
    public void replaceValue(int rowId, Object value) throws Exception {
        logger.debug((Object)("replacing value " + rowId + " " + value.toString()));
        Select select = (Select)DBSession.getImplementation(Select.class);
        CastObject cast = Utility.getCast((String)value.toString(), (Type)this.type);
        cast.setUseCastFunction(true);
        OperatorCondition cond = new OperatorCondition((Object)cast, null, " IS NOT ");
        select.setAttributes(new Attribute[]{new BooleanAttribute("field", (Condition)cond)});
        DBSession session = null;
        try {
            session = DBSession.connect();
            ResultSet rs = select.getResults(session, new boolean[]{false});
            rs.next();
            if (!rs.getBoolean(1)) {
                throw new InvalidValueException();
            }
            if (value.toString().length() > this.fieldlength[0] || ImportUtil.getAfterDotLength((String)value.toString()) > this.fieldlength[1]) {
                int valueLength = this.fieldlength[0];
                if (value.toString().length() > this.fieldlength[0]) {
                    valueLength = value.toString().length();
                }
                int precisionFloat = this.fieldlength[1];
                if (ImportUtil.getAfterDotLength((String)value.toString()) > this.fieldlength[1]) {
                    precisionFloat = ImportUtil.getAfterDotLength((String)value.toString());
                }
                this.fieldlength = new int[]{valueLength, precisionFloat};
                this.getDataType().setPrecision(new int[]{valueLength, precisionFloat});
                ModifyColumnType modifyCol = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
                modifyCol.setTable((Table)this.getCorrectsTable());
                modifyCol.setColumn(new SimpleAttribute(this.fieldId));
                modifyCol.setNewType(this.getDataType());
                modifyCol.execute(session);
            }
            session.disableAutoCommit();
            select = (Select)DBSession.getImplementation(Select.class);
            ArrayList<Object> attributes = new ArrayList<Object>();
            for (String key : this.getCorrectsTable().getFieldsMapping().keySet()) {
                if (key.equals(this.fieldId)) {
                    attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId), (Object)cast));
                    continue;
                }
                attributes.add(new SimpleAttribute(key));
            }
            select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
            select.setTables(new Table[]{new Table(this.getWrongsTableName())});
            select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            InsertFromSelect insertFromSelect = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
            insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
            insertFromSelect.setSubQuery(select);
            insertFromSelect.execute(session);
            logger.trace((Object)("replaceValue: " + insertFromSelect.getExpression()));
            Delete deleteEntry = (Delete)DBSession.getImplementation(Delete.class);
            deleteEntry.setTable(new Table(this.getWrongsTableName()));
            deleteEntry.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            deleteEntry.execute(session);
            session.commit();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceIds(String fieldId, String oldId, String newId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public List<ErrorPair> getDistinctErrors() throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getPossibleValues(String word) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public ColumnDefinition getTemporaryColumnDefinition(ColumnDefinition oldColumnDefinition) throws Exception {
        ColumnDefinition definition = new ColumnDefinition();
        definition.setId(this.fieldId);
        definition.setColumnType(oldColumnDefinition.getColumnType());
        definition.setLabel(oldColumnDefinition.getLabel());
        definition.setValueType(Util.mapSqlToJava(this.type.getType()));
        return definition;
    }

    public Type getDataType() {
        return this.type;
    }
}

