/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.NOTCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.Edit;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.InvalidValueException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.FilterExplorer;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;

public class RuleEditor
extends Edit {
    private static final long serialVersionUID = 7217900599962841532L;
    private static transient GCUBELog logger = new GCUBELog(RuleEditor.class);
    private List<Rule> rules;
    private ColumnDefinition[] columnsDefinition;
    private final String TABLE_ALIAS = "tableAlias";

    public RuleEditor(String resourceId, String fieldId, SimpleTable resourceTable, int[] fieldLength, boolean withoutError, List<Rule> rules, ColumnDefinition[] columnsDefinition, String ... rowIdLabel) {
        super(resourceId, fieldId, resourceTable, fieldLength, withoutError, rowIdLabel);
        this.rules = rules;
        this.columnsDefinition = columnsDefinition;
    }

    @Override
    protected void internalInitialize(DBSession session) throws Exception {
        CreateTableFromSelect createFromSelect = (CreateTableFromSelect)DBSession.getImplementation(CreateTableFromSelect.class);
        createFromSelect.setTableName(this.getCorrectsTableName());
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "tableAlias")});
        Condition[] conditions = new Condition[this.rules.size()];
        int i = 0;
        while (i < this.rules.size()) {
            conditions[i] = FilterExplorer.getCondition(this.rules.get(i).getFilter(), this.columnsDefinition, "tableAlias", this.getFieldId());
            ++i;
        }
        select.setFilter((Condition)new ANDCondition(conditions));
        logger.debug((Object)("query for correct : " + select.getExpression()));
        createFromSelect.setSelect(select);
        createFromSelect.setWithData();
        createFromSelect.execute(session);
        CreateTableLike createTableLike = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
        createTableLike.setTableName(this.getWrongsTableName());
        createTableLike.setTableLike(this.resourceTable);
        SimpleTable wrongTable = createTableLike.execute(session);
        InsertFromSelect insertFromSelectQuery = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertFromSelectQuery.setTable(wrongTable);
        select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "tableAlias")});
        conditions = new Condition[this.rules.size()];
        int i2 = 0;
        while (i2 < this.rules.size()) {
            conditions[i2] = FilterExplorer.getCondition(this.rules.get(i2).getFilter(), this.columnsDefinition, "tableAlias", this.getFieldId());
            ++i2;
        }
        select.setFilter((Condition)new NOTCondition((Condition)new ANDCondition(conditions)));
        logger.debug((Object)("query for wrong : " + select.getExpression()));
        insertFromSelectQuery.setSubQuery(select);
        insertFromSelectQuery.execute(session);
    }

    @Override
    public long check() throws Exception {
        DBSession session = null;
        try {
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            select.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "tableAlias")});
            Condition[] conditions = new Condition[this.rules.size()];
            int i = 0;
            while (i < this.rules.size()) {
                conditions[i] = FilterExplorer.getCondition(this.rules.get(i).getFilter(), this.columnsDefinition, "tableAlias", this.getFieldId());
                ++i;
            }
            select.setFilter((Condition)new NOTCondition((Condition)new ANDCondition(conditions)));
            ResultSet result = select.getResults(session, new boolean[0]);
            long l = result.getLong(1);
            return l;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public void replaceValue(int rowId, Object value) throws Exception {
        logger.debug((Object)("replacing value " + rowId + " " + value.toString()));
        Select select = (Select)DBSession.getImplementation(Select.class);
        Condition[] conditions = new Condition[this.rules.size()];
        CastObject valueCast = Utility.getCast((String)value.toString(), (Type)((Type)this.resourceTable.getFieldsMapping().get(this.fieldId)));
        int i = 0;
        while (i < this.rules.size()) {
            conditions[i] = FilterExplorer.getConditionUsingValue(this.rules.get(i).getFilter(), valueCast);
            ++i;
        }
        select.setAttributes(new Attribute[]{new BooleanAttribute("field", (Condition)new ANDCondition(conditions))});
        logger.debug((Object)("checking the new value: " + select.getExpression()));
        DBSession session = null;
        try {
            session = DBSession.connect();
            ResultSet rs = select.getResults(session, new boolean[]{false});
            rs.next();
            if (!rs.getBoolean(1)) {
                throw new InvalidValueException();
            }
            session.disableAutoCommit();
            select = (Select)DBSession.getImplementation(Select.class);
            ArrayList<Object> attributes = new ArrayList<Object>();
            for (String key : this.getCorrectsTable().getFieldsMapping().keySet()) {
                if (key.equals(this.fieldId)) {
                    attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId), (Object)valueCast));
                    continue;
                }
                attributes.add(new SimpleAttribute(key));
            }
            select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
            select.setTables(new Table[]{new Table(this.getWrongsTableName())});
            select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            InsertFromSelect insertFromSelect = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
            insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
            insertFromSelect.setSubQuery(select);
            insertFromSelect.execute(session);
            logger.trace((Object)("replaceValue: " + insertFromSelect.getExpression()));
            Delete deleteEntry = (Delete)DBSession.getImplementation(Delete.class);
            deleteEntry.setTable(new Table(this.getWrongsTableName()));
            deleteEntry.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            deleteEntry.execute(session);
            session.commit();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    @Override
    public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceIds(String fieldId, String oldId, String newId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public List<ErrorPair> getDistinctErrors() throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getPossibleValues(String word) throws Exception {
        throw new OperationNotSupportedException();
    }

    @Override
    public ColumnDefinition getTemporaryColumnDefinition(ColumnDefinition oldColumnDefinition) throws Exception {
        return oldColumnDefinition;
    }
}

