/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.history;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;

@TableRootDefinition
public class TSHistory
implements Serializable {
    private static final long serialVersionUID = 7515773534337438628L;
    @FieldDefinition
    private LinkedList<TSHistoryItem> historyList;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private Date historyCreationDate;
    @FieldDefinition(precision={200}, specifications={Specification.NOT_NULL})
    private String parentName;
    @FieldDefinition(precision={200}, specifications={Specification.NOT_NULL})
    private String author;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    public int itemLimit;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private ParentType parentType;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL})
    private String parentId;
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;

    public TSHistory(String id, String curParentId, Date historyCreationDate, int itemLimit, String parentTitle, String author) {
        this.historyList = null;
        this.parentType = ParentType.CUR;
        this.parentId = curParentId;
        this.itemLimit = itemLimit;
        this.historyCreationDate = historyCreationDate;
        this.id = id;
        this.parentName = parentTitle;
        this.author = author;
    }

    public TSHistory(String id, String tsParentId, Date historyCreationDate, String parentTitle, String author) {
        this.historyList = new LinkedList();
        this.parentType = ParentType.TS;
        this.parentId = tsParentId;
        this.historyCreationDate = historyCreationDate;
        this.id = id;
        this.parentName = parentTitle;
        this.itemLimit = 0;
        this.author = author;
    }

    private TSHistory() {
    }

    public LinkedList<TSHistoryItem> getHistoryList() {
        return this.historyList;
    }

    protected void setHistoryList(LinkedList<TSHistoryItem> historyList) {
        this.historyList = historyList;
    }

    public ParentType getParentType() {
        return this.parentType;
    }

    public void setParentType(ParentType parentType) {
        this.parentType = parentType;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void addHistoryItems(TSHistoryItem item) {
        this.historyList.add(item);
    }

    public void removeAllHistoryItems(List<TSHistoryItem> items) {
        this.historyList = new LinkedList();
    }

    public Date getHistoryCreationDate() {
        return this.historyCreationDate;
    }

    public void setHistoryCreationDate(Date historyCreationDate) {
        this.historyCreationDate = historyCreationDate;
    }

    public String getId() {
        return this.id;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public int getItemLimit() {
        return this.itemLimit;
    }

    public void setItemLimit(int itemLimit) {
        this.itemLimit = itemLimit;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void store() throws Exception {
        ObjectPersistency op = ObjectPersistency.get(TSHistory.class);
        if (!op.existsKey((Object)this.getId())) {
            op.insert((Object)this);
        } else {
            op.update((Object)this);
        }
    }

    public static TSHistory retrieveHistory(String id) throws Exception {
        return (TSHistory)ObjectPersistency.get(TSHistory.class).getByKey((Object)id);
    }

    public static enum ParentType {
        TS,
        CUR;

    }
}

