/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries;

import java.sql.Timestamp;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;

@TableRootDefinition
public class TimeSeries {
    @FieldDefinition(specifications={Specification.PRIMARY_KEY}, precision={50})
    private String id;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String title;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String description;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String creator;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String publisher;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
    private String type;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
    private String sourceId;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String sourceName;
    @FieldDefinition(precision={50})
    private String isVersionOf = "";
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String rights;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private Timestamp date;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={10})
    private int legth;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private boolean published = false;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String users;
    @FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
    private String scope;

    public TimeSeries(String id) {
        this.id = id;
        this.date = new Timestamp(System.currentTimeMillis());
    }

    private TimeSeries() {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getIsVersionOf() {
        return this.isVersionOf;
    }

    public void setIsVersionOf(String isVersionOf) {
        this.isVersionOf = isVersionOf;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public Timestamp getDate() {
        return this.date;
    }

    public void setDate(Timestamp date) {
        this.date = date;
    }

    public int getLegth() {
        return this.legth;
    }

    public void setLegth(int legth) {
        this.legth = legth;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public String getUsers() {
        return this.users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public void store() throws Exception {
        ObjectPersistency persistency = ObjectPersistency.get(TimeSeries.class);
        if (!persistency.existsKey((Object)this.id)) {
            persistency.insert((Object)this);
        } else {
            persistency.update((Object)this);
        }
    }

    public void delete() throws Exception {
        ObjectPersistency persistency = ObjectPersistency.get(TimeSeries.class);
        if (persistency.getByKey((Object)this.id) == null) {
            return;
        }
        persistency.deleteByKey((Object)this.getId());
    }

    public static TimeSeries get(String id) throws Exception {
        ObjectPersistency persistency = ObjectPersistency.get(TimeSeries.class);
        TimeSeries ts = (TimeSeries)persistency.getByKey((Object)id);
        if (ts == null) {
            throw new ObjectNotFoundException();
        }
        return ts;
    }

    public static String getTableName() throws Exception {
        return ObjectPersistency.get(TimeSeries.class).getTable().getTableName();
    }
}

