/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.io.Serializable;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.DropTable;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state.TimeSeriesResource;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.globus.wsrf.ResourceKey;

public abstract class Operation
implements Serializable {
    protected ColumnDefinition[] columnDefinition = null;
    protected static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static GCUBELog logger = new GCUBELog(Operation.class);
    private TSHistoryItem historyItem;
    protected long extimatedCount;
    protected CurrentState currentState = CurrentState.Closed;
    protected OperationType type = OperationType.None;
    protected String viewName;
    protected SimpleTable viewTable = null;
    protected long count;

    public abstract void setParameters(Object ... var1) throws Exception;

    protected abstract void initialize(String var1, ColumnDefinition[] var2, DBSession var3) throws Exception;

    public String getDataAsJSon(org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit limit, Order order) throws Exception {
        Select selectQuery = (Select)DBSession.getImplementation(Select.class);
        selectQuery.setTables(new Table[]{new Table(this.viewName)});
        selectQuery.setLimit(new Limit(limit.getLowerLimit(), limit.getUpperLimit()));
        if (order != null) {
            Order.OrderType orderType = order.getOrder().getValue().equals("Ascending") ? Order.OrderType.ASC : Order.OrderType.DESC;
            selectQuery.setOrders(new org.gcube.common.dbinterface.Order[]{new org.gcube.common.dbinterface.Order(orderType, (Attribute)new SimpleAttribute(order.getField()))});
        }
        logger.trace((Object)("operation query: " + selectQuery.getExpression()));
        return selectQuery.getResultAsJSon(true, new boolean[0]);
    }

    protected static TimeSeriesResource getResource(String resourceId) throws Exception {
        return (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(resourceId));
    }

    public synchronized void apply(final String previuosTableName, final ColumnDefinition[] previousTableDefinition) throws Exception {
        this.setCurrentState(CurrentState.InProgress);
        new Thread(){

            @Override
            public void run() {
                DBSession session = null;
                try {
                    try {
                        session = DBSession.connect();
                        Operation.this.initialize(previuosTableName, Operation.this.cloneColumnDefinition(previousTableDefinition), session);
                        Operation.this.setCurrentState(CurrentState.Closed);
                    }
                    catch (Throwable e) {
                        Operation.this.setCurrentState(CurrentState.Error);
                        logger.error((Object)"an error occurred initializing the request operation", e);
                        try {
                            Operation.this.discard();
                        }
                        catch (Exception e1) {
                            logger.error((Object)"error occurred discarding after an error");
                        }
                        if (session != null) {
                            session.release();
                        }
                    }
                }
                finally {
                    if (session != null) {
                        session.release();
                    }
                }
            }
        }.start();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public OperationType getType() {
        return this.type;
    }

    public void setType(OperationType _type) {
        this.type = _type;
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(CurrentState currentState) {
        this.currentState = currentState;
    }

    public ColumnDefinition[] getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(ColumnDefinition[] columnDefintion) {
        this.columnDefinition = columnDefintion;
    }

    public synchronized void discard() throws Exception {
        DBSession session = DBSession.connect();
        DropTable drop = (DropTable)DBSession.getImplementation(DropTable.class);
        drop.setTableName(this.viewName);
        try {
            drop.execute(session);
        }
        finally {
            session.release();
        }
    }

    protected void createTable(Select query, DBSession session, boolean data) throws Exception {
        CreateTableFromSelect createQuery = (CreateTableFromSelect)DBSession.getImplementation(CreateTableFromSelect.class);
        createQuery.setSelect(query);
        createQuery.setTableName(this.viewName);
        if (!data) {
            createQuery.setWithoutData();
        }
        logger.debug((Object)("create query:" + createQuery.getExpression()));
        this.viewTable = createQuery.execute(session);
        this.createIndexesOnTable(session);
    }

    protected void createTable(String previousTableName, DBSession session) throws Exception {
        CreateTableLike createTable = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
        createTable.setTableLike(new SimpleTable(previousTableName));
        createTable.setTableName(this.viewName);
        this.viewTable = createTable.execute(session);
    }

    private void createIndexesOnTable(DBSession session) throws Exception {
        ColumnDefinition[] columnDefinitionArray = this.getColumnDefinition();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition def = columnDefinitionArray[n2];
            if (!def.getId().contains("pivot_") && def.getColumnType() == EntryType.Dimension) {
                Utility.createIndexOnField((Table)this.viewTable, (String)(String.valueOf(def.getId()) + "_id"), (boolean)false);
            }
            ++n2;
        }
    }

    public static ColumnDefinition getColumnDefinitionReference(String fieldId, ColumnDefinition[] columnsDefintion) throws Exception {
        ColumnDefinition[] columnDefinitionArray = columnsDefintion;
        int n = columnsDefintion.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition def = columnDefinitionArray[n2];
            if (def.getId().compareTo(fieldId) == 0) {
                return def;
            }
            ++n2;
        }
        throw new Exception("fieldId " + fieldId + " not found in Operation");
    }

    public TSHistoryItem getHistoryItem() {
        return this.historyItem;
    }

    public void setHistoryItem(TSHistoryItem historyItem) {
        this.historyItem = historyItem;
    }

    private ColumnDefinition[] cloneColumnDefinition(ColumnDefinition[] def) {
        ColumnDefinition[] newDef = new ColumnDefinition[def.length];
        int i = 0;
        while (i < def.length) {
            newDef[i] = new ColumnDefinition(def[i].getColumnType(), def[i].getDimension(), def[i].getDimensionRelatedFieldId(), def[i].getId(), def[i].getKey(), def[i].getLabel(), def[i].getValueType());
            ++i;
        }
        return newDef;
    }
}

