package org.gcube.contentmanagement.timeseriesservice.impl.curation;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;


@TableRootDefinition
public class Curation {

	@FieldDefinition(specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY}, precision={50})
	private String id;
	
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
	private String title;
			
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String description;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
	private String creator;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
	private String sourceId;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
	private String sourceName;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private Timestamp date;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={10})
	private int length;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={50})
	private String type;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
	private String publisher;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String rights;
	@FieldDefinition(specifications={Specification.NOT_NULL}, precision={150})
	private String scope;
	
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private HashMap<String, ArrayList<Rule>> fieldRulesMapping= new HashMap<String, ArrayList<Rule>>();
	
	public Curation(String id) {
		super();
		this.id = id;
	}
	
	@SuppressWarnings("unused")
	private Curation(){};
	
	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the creator
	 */
	public String getCreator() {
		return creator;
	}
	/**
	 * @param creator the creator to set
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}
	/**
	 * @return the sourceId
	 */
	public String getSourceId() {
		return sourceId;
	}
	/**
	 * @param sourceId the sourceId to set
	 */
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
	/**
	 * @return the sourceName
	 */
	public String getSourceName() {
		return sourceName;
	}
	/**
	 * @param sourceName the sourceName to set
	 */
	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}
	/**
	 * @return the date
	 */
	public Timestamp getDate() {
		return date;
	}
	/**
	 * @param date the date to set
	 */
	public void setDate(Timestamp date) {
		this.date = date;
	}
	/**
	 * @return the length
	 */
	public int getLength() {
		return length;
	}
	/**
	 * @param length the length to set
	 */
	public void setLength(int length) {
		this.length = length;
	}
	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}
	/**
	 * @param type the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * @return the publisher
	 */
	public String getPublisher() {
		return publisher;
	}
	/**
	 * @param publisher the publisher to set
	 */
	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}
	/**
	 * @return the rights
	 */
	public String getRights() {
		return rights;
	}
	/**
	 * @param rights the rights to set
	 */
	public void setRights(String rights) {
		this.rights = rights;
	}
	/**
	 * @return the scope
	 */
	public String getScope() {
		return scope;
	}
	/**
	 * @param scope the scope to set
	 */
	public void setScope(String scope) {
		this.scope = scope;
	}
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * @return the fieldRulesMapping
	 */
	public HashMap<String, ArrayList<Rule>> getFieldRulesMapping() {
		return fieldRulesMapping;
	}

	public void addRuleToField(String fieldId, Rule rule){
		if(this.getFieldRulesMapping().get(fieldId)==null){
			ArrayList<Rule> singletonArray = new ArrayList<Rule>();
			singletonArray.add(rule);
			this.getFieldRulesMapping().put(fieldId, singletonArray);
		}
		else this.getFieldRulesMapping().get(fieldId).add(rule);
	}
	
	public void removeAllRulesForField(String fieldId){
		this.getFieldRulesMapping().remove(fieldId);
	}
	
	
	public void store() throws Exception{
		ObjectPersistency<Curation> persistency= ObjectPersistency.get(Curation.class);
		if(!persistency.existsKey(this.id))
			persistency.insert(this);
		else persistency.update(this);
	}
	
	public static Curation getCurationItem(String id) throws Exception{
		return ObjectPersistency.get(Curation.class).getByKey(id);		
	}
}
