package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.InvalidValueException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;

public class ColumnEditor extends Edit {

	private static transient GCUBELog logger = new GCUBELog(ColumnEditor.class);
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4411160417374524492L;
	
	private Type type;

	public ColumnEditor(String resourceId, String fieldId,
			SimpleTable resourceTable, int[] fieldLength,
			boolean withoutError, Type type, String ... rowIdLabel) {
		super(resourceId, fieldId, resourceTable, fieldLength, withoutError, rowIdLabel);
		this.type = type;
		if (this.type.getType()==Types.FLOAT) this.type.setPrecision(fieldLength[0]+fieldLength[1], fieldLength[1]);
		else this.type.setPrecision(fieldLength);
		this.editorType= TYPE.Column;
	}
	
	public long check() throws Exception{
		DBSession session= null;
		try{
			Select select= DBSession.getImplementation(Select.class);
			select.setAttributes(new AggregatedAttribute("*",AggregationFunctions.COUNT));
			select.setTables(this.resourceTable);
			CastObject cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.type);
			cast.setUseCastFunction(true);
			
			Condition cond = new OperatorCondition<CastObject, Object>(cast, null," IS ");
		
			select.setFilter(cond);
			ResultSet result = select.getResults(session);
			return result.getLong(1);
		}finally {
			if(session!=null)session.release();
		}
	}
	
	@Override
	public void internalInitialize(DBSession session) throws Exception {
		//creating correct table
		CreateTableFromSelect createFromSelect = DBSession.getImplementation(CreateTableFromSelect.class);
		createFromSelect.setTableName(getCorrectsTableName());
		
		Select select= DBSession.getImplementation(Select.class);
		select.setTables(this.resourceTable);
		CastObject cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.type);
		cast.setUseCastFunction(true);
		
		Condition cond = new OperatorCondition<CastObject, Object>(cast, null," IS NOT ");
		
		select.setFilter(cond);
		
		logger.debug("query for correct : "+select.getExpression());
		
		createFromSelect.setSelect(select);
		createFromSelect.setWithData();
		createFromSelect.execute(session);
		
		ModifyColumnType modifyColumn = DBSession.getImplementation(ModifyColumnType.class);
		modifyColumn.setNewType(this.type);
		modifyColumn.setTable(new Table(getCorrectsTableName()));
		modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
		modifyColumn.setUseCast(true);
		modifyColumn.execute(session);
		
		//creating wrong entry table
		CreateTableLike createTableLike = DBSession.getImplementation(CreateTableLike.class);
		createTableLike.setTableName(getWrongsTableName());
		createTableLike.setTableLike(this.resourceTable);
		SimpleTable wrongTable = createTableLike.execute(session);
		
		InsertFromSelect insertFromSelectQuery = DBSession.getImplementation(InsertFromSelect.class);
		insertFromSelectQuery.setTable(wrongTable);
		select= DBSession.getImplementation(Select.class);
		select.setTables(this.resourceTable);
		cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.type);
		cast.setUseCastFunction(true);
		
		
		cond = new OperatorCondition<CastObject, Object>(cast, null," IS ");
		
		select.setFilter(cond);
		
		logger.debug("query for wrong : "+select.getExpression());
		
		insertFromSelectQuery.setSubQuery(select);
		insertFromSelectQuery.execute(session);
		
	}

	@Override
	public void replaceValue(int rowId, Object value) throws Exception {
		logger.debug("replacing value "+rowId+" "+value.toString());
		Select select = DBSession.getImplementation(Select.class);
		CastObject cast= Utility.getCast(value.toString(), this.type);
		cast.setUseCastFunction(true);
		
		Condition cond = new OperatorCondition<CastObject, Object>(cast, null," IS NOT ");
		
		select.setAttributes(new BooleanAttribute("field", cond ));
		DBSession session = null;
		try{
			session = DBSession.connect();
			ResultSet rs = select.getResults(session, false);
			rs.next();
			if (!rs.getBoolean(1)) throw new InvalidValueException();
			
			if (value.toString().length()>this.fieldlength[0] || ImportUtil.getAfterDotLength(value.toString())>this.fieldlength[1]){
				int valueLength = this.fieldlength[0];
				if (value.toString().length()>this.fieldlength[0])
					valueLength = value.toString().length();
				int precisionFloat = this.fieldlength[1];
				if (ImportUtil.getAfterDotLength(value.toString())>this.fieldlength[1])
					precisionFloat = ImportUtil.getAfterDotLength(value.toString());
				this.fieldlength = new int[]{valueLength, precisionFloat};
				
				
				
				this.getDataType().setPrecision(new int[]{valueLength, precisionFloat});
				ModifyColumnType modifyCol= DBSession.getImplementation(ModifyColumnType.class);
				modifyCol.setTable(this.getCorrectsTable());
				modifyCol.setColumn(new SimpleAttribute(fieldId));
				modifyCol.setNewType(this.getDataType());
				modifyCol.execute(session);
				
			}
			
			session.disableAutoCommit();
			//retrieving the row from wrong entries and inserting in the correct table
			select = DBSession.getImplementation(Select.class);
			List<Attribute> attributes = new ArrayList<Attribute>();
			for (String key :getCorrectsTable().getFieldsMapping().keySet()){
				if (key.equals(fieldId))attributes.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), cast));
				else attributes.add(new SimpleAttribute(key));
			}
			
			select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
			select.setTables(new Table(this.getWrongsTableName()));
			select.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			
			//TODO: test if is enough (insert without cast)
			
			InsertFromSelect insertFromSelect =  DBSession.getImplementation(InsertFromSelect.class);
			insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
			insertFromSelect.setSubQuery(select);
			insertFromSelect.execute(session);
			
			logger.trace("replaceValue: "+insertFromSelect.getExpression());
			
			Delete deleteEntry = DBSession.getImplementation(Delete.class);
			deleteEntry.setTable(new Table(this.getWrongsTableName()));
			deleteEntry.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			deleteEntry.execute(session);
			
			session.commit();
			
		}finally{
			if (session!=null) session.release();
		}
	
			
	}
	
	public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceIds(String fieldId, String oldId, String newId) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception{
		throw new OperationNotSupportedException();
	}

	@Override
	public List<ErrorPair> getDistinctErrors() throws Exception {
		throw new OperationNotSupportedException();
	}

	@Override
	public String getPossibleValues(String word) throws Exception {
		throw new OperationNotSupportedException();
	}

	@Override
	public ColumnDefinition getTemporaryColumnDefinition(ColumnDefinition oldColumnDefinition) throws Exception {
		ColumnDefinition definition = new ColumnDefinition();
		definition.setId(this.fieldId);
		definition.setColumnType(oldColumnDefinition.getColumnType());
		definition.setLabel(oldColumnDefinition.getLabel());
		definition.setValueType(Util.mapSqlToJava(this.type.getType()));
		return definition;
	}

	public Type getDataType(){
		return this.type;
	}
	
}
