package org.gcube.contentmanagement.timeseriesservice.impl.history;

import java.util.Date;
import java.util.LinkedList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;

/**
 * 
 * @author lucio
 *
 */
@TableRootDefinition
public class CurationHistory{

	//public static final String HISTORY_TABLE="CurHistoryTable";
	
	//public static final String HISTORY_PREF="HC";
	
	private static GCUBELog logger= new GCUBELog(CurationHistory.class);
	
	/*public static final String getTableName(String id){
		return HISTORY_PREF+id.replace("-", "_");
	}*/
	
	@FieldDefinition()
	private LinkedList<CurationHistoryItem> items;
	
	private String query;
	
	@FieldDefinition(precision={200},specifications={Specification.NOT_NULL})
	private String creator;
	
	@FieldDefinition(precision={200},specifications={Specification.NOT_NULL})
	private String parentTitle;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	private String csvParentId;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL})
	private Date date;
	
	@FieldDefinition(precision={40},specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
	private String id;
		
	/**
	 * 
	 * @param timestamp
	 * @param opType
	 * @param query
	 * @param humanDescription
	 */
	public CurationHistory(String id, String parentCSVId, String parentTitle,Date historyCreationDate, String creator) throws Exception{
		this.id= id;
		this.date= historyCreationDate;
		this.items= new LinkedList<CurationHistoryItem>();
		this.csvParentId= parentCSVId;
		this.parentTitle= parentTitle;
		this.creator= creator;
		logger.trace("curation history created");
	}
	
	@SuppressWarnings("unused")
	private CurationHistory(){}
	
	/**
	 * 
	 * @return
	 */
	public String getQuery() {
		return query;
	}

	/**
	 * 
	 * @return
	 */
	public Date getDate() {
		return date;
	}


	public String getCsvParentId() {
		return csvParentId;
	}

	public LinkedList<CurationHistoryItem> getItems() {
		return items;
	}

	protected void setItems(LinkedList<CurationHistoryItem> items) {
		this.items = items;
	}

	public String getParentTitle() {
		return parentTitle;
	}

	public void setParentTitle(String parentTitle) {
		this.parentTitle = parentTitle;
	}
	
	public String getId() {
		return id;
	}
	
	public void addItem(CurationHistoryItem item) throws Exception{
		this.getItems().add(item);
		this.store();
	}
	
	
	public static CurationHistory retrieveHistory(String id) throws Exception{
		return ObjectPersistency.get(CurationHistory.class).getByKey(id);
	}

	public String getCreator() {
		return creator;
	}

	public void setCreator(String creator) {
		this.creator = creator;
	}
	
	public void store() throws Exception{
		ObjectPersistency<CurationHistory> op = ObjectPersistency.get(CurationHistory.class);
		if (!op.existsKey(this.getId()))
			op.insert(this);
		else op.update(this);
	}
	
	public void destroy() throws Exception{
		ObjectPersistency.get(CurationHistory.class).deleteByKey(this.id);
	}
	
}
